/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client;

import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.ShutDownRequest;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.impl.KubernetesNativeApplicationClient$;
import org.apache.streampark.flink.client.impl.KubernetesNativeSessionClient$;
import org.apache.streampark.flink.client.impl.LocalClient$;
import org.apache.streampark.flink.client.impl.RemoteClient$;
import org.apache.streampark.flink.client.impl.YarnApplicationClient$;
import org.apache.streampark.flink.client.impl.YarnPerJobClient$;
import org.apache.streampark.flink.client.impl.YarnSessionClient$;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class FlinkClientHandler$ {
    public static FlinkClientHandler$ MODULE$;
    private final Map<ExecutionMode, FlinkClientTrait> clients;

    static {
        new FlinkClientHandler$();
    }

    public SubmitResponse submit(SubmitRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (!(option instanceof Some)) {
            throw new UnsupportedOperationException(new StringBuilder(20).append("Unsupported ").append(request.executionMode()).append(" submit ").toString());
        }
        Some some = (Some)option;
        FlinkClientTrait client = (FlinkClientTrait)some.value();
        SubmitResponse submitResponse = client.submit(request);
        return submitResponse;
    }

    public CancelResponse cancel(CancelRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (!(option instanceof Some)) {
            throw new UnsupportedOperationException(new StringBuilder(20).append("Unsupported ").append(request.executionMode()).append(" cancel ").toString());
        }
        Some some = (Some)option;
        FlinkClientTrait client = (FlinkClientTrait)some.value();
        CancelResponse cancelResponse = client.cancel(request);
        return cancelResponse;
    }

    public SavepointResponse triggerSavepoint(TriggerSavepointRequest request) {
        Option option = this.clients.get((Object)request.executionMode());
        if (!(option instanceof Some)) {
            throw new UnsupportedOperationException(new StringBuilder(30).append("Unsupported ").append(request.executionMode()).append(" triggerSavepoint ").toString());
        }
        Some some = (Some)option;
        FlinkClientTrait client = (FlinkClientTrait)some.value();
        SavepointResponse savepointResponse = client.triggerSavepoint(request);
        return savepointResponse;
    }

    public DeployResponse deploy(DeployRequest request) {
        DeployResponse deployResponse;
        ExecutionMode executionMode = request.executionMode();
        if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            deployResponse = YarnSessionClient$.MODULE$.deploy(request);
        } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
            deployResponse = KubernetesNativeSessionClient$.MODULE$.deploy(request);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Unsupported ").append(request.executionMode()).append(" deploy cluster ").toString());
        }
        return deployResponse;
    }

    public ShutDownResponse shutdown(ShutDownRequest request) {
        ShutDownResponse shutDownResponse;
        ExecutionMode executionMode = request.executionMode();
        if (ExecutionMode.YARN_SESSION.equals(executionMode)) {
            shutDownResponse = YarnSessionClient$.MODULE$.shutdown(request);
        } else if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals(executionMode)) {
            shutDownResponse = KubernetesNativeSessionClient$.MODULE$.shutdown(request);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(30).append("Unsupported ").append(request.executionMode()).append(" shutdown cluster ").toString());
        }
        return shutDownResponse;
    }

    private FlinkClientHandler$() {
        MODULE$ = this;
        this.clients = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.LOCAL), (Object)LocalClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.REMOTE), (Object)RemoteClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_APPLICATION), (Object)YarnApplicationClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_SESSION), (Object)YarnSessionClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.YARN_PER_JOB), (Object)YarnPerJobClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.KUBERNETES_NATIVE_SESSION), (Object)KubernetesNativeSessionClient$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ExecutionMode.KUBERNETES_NATIVE_APPLICATION), (Object)KubernetesNativeApplicationClient$.MODULE$)}));
    }
}

