/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.WrappingProxy;

@Internal
public final class WrappingProxyUtil {
    @VisibleForTesting
    static final int SAFETY_NET_MAX_ITERATIONS = 128;

    private WrappingProxyUtil() {
        throw new AssertionError();
    }

    public static <T> T stripProxy(@Nullable WrappingProxy<T> wrappingProxy) {
        if (wrappingProxy == null) {
            return null;
        }
        T delegate = wrappingProxy.getWrappedDelegate();
        int numProxiesStripped = 0;
        while (delegate instanceof WrappingProxy) {
            WrappingProxyUtil.throwIfSafetyNetExceeded(++numProxiesStripped);
            delegate = ((WrappingProxy)delegate).getWrappedDelegate();
        }
        return delegate;
    }

    private static void throwIfSafetyNetExceeded(int numProxiesStripped) {
        if (numProxiesStripped >= 128) {
            throw new IllegalArgumentException(String.format("Already stripped %d proxies. Are there loops in the object graph?", 128));
        }
    }
}

