/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslator;
import org.apache.flink.client.PlanTranslator;
import org.apache.flink.client.StreamGraphTranslator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;

public final class FlinkPipelineTranslationUtil {
    public static JobGraph getJobGraph(Pipeline pipeline, Configuration optimizerConfiguration, int defaultParallelism) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(pipeline);
        return pipelineTranslator.translateToJobGraph(pipeline, optimizerConfiguration, defaultParallelism);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobGraph getJobGraphUnderUserClassLoader(ClassLoader userClassloader, Pipeline pipeline, Configuration configuration, int defaultParallelism) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userClassloader);
            JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraph(pipeline, configuration, defaultParallelism);
            return jobGraph;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static String translateToJSONExecutionPlan(Pipeline pipeline) {
        FlinkPipelineTranslator pipelineTranslator = FlinkPipelineTranslationUtil.getPipelineTranslator(pipeline);
        return pipelineTranslator.translateToJSONExecutionPlan(pipeline);
    }

    private static FlinkPipelineTranslator getPipelineTranslator(Pipeline pipeline) {
        PlanTranslator planTranslator = new PlanTranslator();
        if (planTranslator.canTranslate(pipeline)) {
            return planTranslator;
        }
        StreamGraphTranslator streamGraphTranslator = new StreamGraphTranslator();
        if (streamGraphTranslator.canTranslate(pipeline)) {
            return streamGraphTranslator;
        }
        throw new RuntimeException("Translator " + streamGraphTranslator + " cannot translate the given pipeline " + pipeline + ".");
    }
}

