/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.core.bean.MavenExclusion;

public class MavenPom {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private Set<MavenExclusion> exclusions = Collections.emptySet();

    public boolean equals(Object o) {
        boolean classify;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenPom that = (MavenPom)o;
        boolean basic = this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version);
        boolean bl = classify = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.classifier, that.classifier}) || this.classifier.equals(that.classifier);
        if (basic && classify) {
            Set<Object> thisEx = this.exclusions == null ? Collections.emptySet() : this.exclusions;
            Set<Object> thatEx = that.exclusions == null ? Collections.emptySet() : that.exclusions;
            return thisEx.size() == thatEx.size() && thisEx.containsAll(thatEx);
        }
        return false;
    }

    public String artifactName() {
        if (StringUtils.isBlank((CharSequence)this.classifier)) {
            return String.format("%s-%s.jar", this.artifactId, this.version);
        }
        return String.format("%s-%s-%s.jar", this.artifactId, this.version, this.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + this.getClassifier();
    }

    public Set<String> toExclusionString() {
        return this.exclusions.stream().map(x -> String.format("%s:%s", x.getGroupId(), x.getArtifactId())).collect(Collectors.toSet());
    }

    public String getClassifier() {
        return StringUtils.isBlank((CharSequence)this.classifier) ? "" : ":" + this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<MavenExclusion> getExclusions() {
        return this.exclusions;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setExclusions(Set<MavenExclusion> exclusions) {
        this.exclusions = exclusions;
    }
}

