/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class DoubleComparator
extends BasicTypeComparator<Double> {
    private static final long serialVersionUID = 1L;

    public DoubleComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        double l2;
        double l1 = firstSource.readDouble();
        int comp = l1 < (l2 = secondSource.readDouble()) ? -1 : (l1 > l2 ? 1 : 0);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 0;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(Double value, MemorySegment target, int offset, int numBytes) {
        throw new UnsupportedOperationException();
    }

    public DoubleComparator duplicate() {
        return new DoubleComparator(this.ascendingComparison);
    }
}

