/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobgraph.OperatorID;

public class OperatorIDPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final OperatorID generatedOperatorID;
    private final OperatorID userDefinedOperatorID;

    private OperatorIDPair(OperatorID generatedOperatorID, @Nullable OperatorID userDefinedOperatorID) {
        this.generatedOperatorID = generatedOperatorID;
        this.userDefinedOperatorID = userDefinedOperatorID;
    }

    public static OperatorIDPair of(OperatorID generatedOperatorID, @Nullable OperatorID userDefinedOperatorID) {
        return new OperatorIDPair(generatedOperatorID, userDefinedOperatorID);
    }

    public static OperatorIDPair generatedIDOnly(OperatorID generatedOperatorID) {
        return new OperatorIDPair(generatedOperatorID, null);
    }

    public OperatorID getGeneratedOperatorID() {
        return this.generatedOperatorID;
    }

    public Optional<OperatorID> getUserDefinedOperatorID() {
        return Optional.ofNullable(this.userDefinedOperatorID);
    }
}

