/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.proxy.ChildFirstClassLoader;
import org.apache.streampark.flink.proxy.ClassLoaderObjectInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlinkShimsProxy$
implements Logger {
    public static FlinkShimsProxy$ MODULE$;
    private String FLINK_SHIMS_PREFIX;
    private final Map<String, ClassLoader> SHIMS_CLASS_LOADER_CACHE;
    private final Map<String, ClassLoader> VERIFY_SQL_CLASS_LOADER_CACHE;
    private final Pattern INCLUDE_PATTERN;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile boolean bitmap$0;

    static {
        new FlinkShimsProxy$();
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private Pattern getFlinkShimsResourcePattern(String flinkLargeVersion) {
        return Pattern.compile(new StringBuilder(19).append("flink-(.*)-").append(flinkLargeVersion).append("(.*).jar").toString(), 34);
    }

    private String FLINK_SHIMS_PREFIX$lzycompute() {
        FlinkShimsProxy$ flinkShimsProxy$ = this;
        synchronized (flinkShimsProxy$) {
            if (!this.bitmap$0) {
                this.FLINK_SHIMS_PREFIX = "streampark-flink-shims_flink";
                this.bitmap$0 = true;
            }
        }
        return this.FLINK_SHIMS_PREFIX;
    }

    private String FLINK_SHIMS_PREFIX() {
        return !this.bitmap$0 ? this.FLINK_SHIMS_PREFIX$lzycompute() : this.FLINK_SHIMS_PREFIX;
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function1<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply((Object)shimsClassLoader));
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply(shimsClassLoader));
    }

    public ClassLoader getVerifySqlLibClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("add verify sql lib,flink version: ").append(flinkVersion).toString());
        return (ClassLoader)this.VERIFY_SQL_CLASS_LOADER_CACHE.getOrElseUpdate((Object)String.valueOf(flinkVersion.fullVersion()), (Function0 & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable getFlinkTable = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkShimsProxy$.$anonfun$getVerifySqlLibClassLoader$3(x$1));
            List<URL> libTableURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "lib", (Function1<File, Object>)getFlinkTable);
            List<URL> optTableURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "opt", (Function1<File, Object>)getFlinkTable);
            ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)libTableURL.$plus$plus(optTableURL, List$.MODULE$.canBuildFrom()));
            MODULE$.addShimsUrls(flinkVersion, (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                FlinkShimsProxy$.$anonfun$getVerifySqlLibClassLoader$4(shimsUrls, file);
                return BoxedUnit.UNIT;
            });
            return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), MODULE$.getFlinkShimsResourcePattern(flinkVersion.majorVersion()));
        });
    }

    public void addShimsUrls(FlinkVersion flinkVersion, Function1<File, BoxedUnit> addShimUrl) {
        String appHome = System.getProperty(ConfigConst$.MODULE$.KEY_APP_HOME());
        Predef$.MODULE$.require(appHome != null, (Function0 & Serializable & scala.Serializable)() -> String.format("%s is not found on System env.", ConfigConst$.MODULE$.KEY_APP_HOME()));
        File libPath = new File(new StringBuilder(4).append(appHome).append("/lib").toString());
        Predef$.MODULE$.require(libPath.exists());
        String majorVersion = flinkVersion.majorVersion();
        String scalaVersion = flinkVersion.scalaVersion();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])libPath.listFiles())).foreach((Function1 & Serializable & scala.Serializable)jar -> {
            FlinkShimsProxy$.$anonfun$addShimsUrls$2(majorVersion, scalaVersion, addShimUrl, jar);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T proxyVerifySql(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getVerifySqlLibClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply(shimsClassLoader));
    }

    private ClassLoader getFlinkShimsClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("add flink shims urls classloader,flink version: ").append(flinkVersion).toString());
        return (ClassLoader)this.SHIMS_CLASS_LOADER_CACHE.getOrElseUpdate((Object)String.valueOf(flinkVersion.fullVersion()), (Function0 & Serializable & scala.Serializable)() -> {
            List<URL> libURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "lib", (Function1<File, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkShimsProxy$.$anonfun$getFlinkShimsClassLoader$3(x$2)));
            ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply(libURL);
            MODULE$.addShimsUrls(flinkVersion, (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                FlinkShimsProxy$.$anonfun$getFlinkShimsClassLoader$4(shimsUrls, file);
                return BoxedUnit.UNIT;
            });
            return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), MODULE$.getFlinkShimsResourcePattern(flinkVersion.majorVersion()));
        });
    }

    private List<URL> getFlinkHomeLib(String flinkHome, String childDir, Function1<File, Object> filterFun) {
        File file = new File(flinkHome, childDir);
        Predef$.MODULE$.require(file.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("FLINK_HOME ").append(file).append(" does not exist").toString());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).filter(filterFun))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FlinkShimsProxy$.$anonfun$getFlinkHomeLib$2(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList();
    }

    public <T> T getObject(ClassLoader loader, Object obj) throws Exception {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Object result = Utils$.MODULE$.using((AutoCloseable)new ObjectOutputStream(arrayOutputStream), (Function1 & Serializable & scala.Serializable)objectOutputStream -> {
            objectOutputStream.writeObject(obj);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(arrayOutputStream.toByteArray());
            return Utils$.MODULE$.using((AutoCloseable)new ClassLoaderObjectInputStream(loader, byteArrayInputStream), (Function1 & Serializable & scala.Serializable)x$5 -> x$5.readObject(), (Function1)Predef$.MODULE$.$conforms());
        }, (Function1)Predef$.MODULE$.$conforms());
        return (T)result;
    }

    public static final /* synthetic */ boolean $anonfun$getVerifySqlLibClassLoader$3(File x$1) {
        return x$1.getName().startsWith("flink-table");
    }

    public static final /* synthetic */ void $anonfun$getVerifySqlLibClassLoader$4(ListBuffer shimsUrls$1, File file) {
        block0: {
            if (!file.getName().startsWith("streampark-flink-shims")) break block0;
            shimsUrls$1.$plus$eq((Object)file.toURI().toURL());
        }
    }

    public static final /* synthetic */ void $anonfun$addShimsUrls$2(String majorVersion$1, String scalaVersion$1, Function1 addShimUrl$1, File jar) {
        block0: {
            String jarName;
            block2: {
                block1: {
                    jarName = jar.getName();
                    if (!jarName.endsWith(".jar")) break block0;
                    if (!jarName.startsWith(MODULE$.FLINK_SHIMS_PREFIX())) break block1;
                    String prefixVer = new StringBuilder(2).append(MODULE$.FLINK_SHIMS_PREFIX()).append("-").append(majorVersion$1).append("_").append(scalaVersion$1).toString();
                    if (!jarName.startsWith(prefixVer)) break block0;
                    addShimUrl$1.apply((Object)jar);
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("include flink shims jar lib: ").append(jarName).toString());
                    break block0;
                }
                if (!FlinkShimsProxy$.MODULE$.INCLUDE_PATTERN.matcher(jarName).matches()) break block2;
                addShimUrl$1.apply((Object)jar);
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("include jar lib: ").append(jarName).toString());
                break block0;
            }
            if (!jarName.matches(new StringBuilder(18).append("^streampark-.*_").append(scalaVersion$1).append(".*$").toString())) break block0;
            addShimUrl$1.apply((Object)jar);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("include streampark lib: ").append(jarName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFlinkShimsClassLoader$3(File x$2) {
        return !x$2.getName().toLowerCase().startsWith("log4j");
    }

    public static final /* synthetic */ void $anonfun$getFlinkShimsClassLoader$4(ListBuffer shimsUrls$2, File file) {
        block0: {
            if (file == null) break block0;
            shimsUrls$2.$plus$eq((Object)file.toURI().toURL());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFlinkHomeLib$2(File x$3) {
        return x$3.getName().toLowerCase().endsWith(".jar");
    }

    private FlinkShimsProxy$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        this.SHIMS_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.VERIFY_SQL_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.INCLUDE_PATTERN = Pattern.compile("(streampark-shaded-jackson-)(.*).jar", 34);
    }
}

