/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.util.Preconditions;

public interface SequenceNumberRange {
    public SequenceNumber from();

    public SequenceNumber to();

    public long size();

    public boolean contains(SequenceNumber var1);

    public boolean isEmpty();

    public static SequenceNumberRange generic(SequenceNumber from, SequenceNumber to) {
        return new GenericSequenceNumberRange((SequenceNumber.GenericSequenceNumber)from, (SequenceNumber.GenericSequenceNumber)to);
    }

    public static class GenericSequenceNumberRange
    implements SequenceNumberRange {
        private final SequenceNumber.GenericSequenceNumber from;
        private final SequenceNumber.GenericSequenceNumber to;
        private final long size;

        public GenericSequenceNumberRange(SequenceNumber.GenericSequenceNumber from, SequenceNumber.GenericSequenceNumber to) {
            this.from = from;
            this.to = to;
            this.size = to.number - from.number;
            Preconditions.checkArgument((this.size >= 0L ? 1 : 0) != 0);
        }

        @Override
        public SequenceNumber from() {
            return this.from;
        }

        @Override
        public SequenceNumber to() {
            return this.to;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public boolean contains(SequenceNumber sqn) {
            return this.from.compareTo(sqn) <= 0 && sqn.compareTo(this.to) < 0;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0L;
        }

        public String toString() {
            return String.format("from=%s, to=%s, size=%d", this.from, this.to, this.size);
        }
    }
}

