/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.aspect;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.MemberService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class StreamParkAspect {
    private static final Logger log = LoggerFactory.getLogger(StreamParkAspect.class);
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ApplicationService applicationService;

    @Pointcut(value="execution(public org.apache.streampark.console.base.domain.RestResponse org.apache.streampark.console.*.controller.*.*(..))")
    public void apiAccess() {
    }

    @Around(value="apiAccess()")
    public RestResponse apiAccess(ProceedingJoinPoint joinPoint) throws Throwable {
        ApiAccess apiAccess;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("restResponse aspect, method:{}", (Object)methodSignature.getName());
        Boolean isApi = (Boolean)SecurityUtils.getSubject().getSession().getAttribute((Object)"is_api_token");
        if (isApi != null && isApi.booleanValue() && (apiAccess = methodSignature.getMethod().getAnnotation(ApiAccess.class)) == null) {
            throw new ApiAlertException("current api unsupported!");
        }
        return (RestResponse)joinPoint.proceed();
    }

    @Pointcut(value="@annotation(org.apache.streampark.console.core.annotation.AppUpdated)")
    public void appUpdated() {
    }

    @Around(value="appUpdated()")
    public Object appUpdated(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("appUpdated aspect, method:{}", (Object)methodSignature.getName());
        Object target = joinPoint.proceed();
        this.flinkAppHttpWatcher.initialize();
        return target;
    }

    @Pointcut(value="@annotation(org.apache.streampark.console.core.annotation.PermissionScope)")
    public void permissionAction() {
    }

    @Around(value="permissionAction()")
    public RestResponse permissionAction(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean isAdmin;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        PermissionScope permissionScope = methodSignature.getMethod().getAnnotation(PermissionScope.class);
        User currentUser = this.serviceHelper.getLoginUser();
        ApiAlertException.throwIfNull(currentUser, "Permission denied, please login first.");
        boolean bl = isAdmin = currentUser.getUserType() == UserType.ADMIN;
        if (!isAdmin) {
            Long appId;
            Long userId = this.getId(joinPoint, methodSignature, permissionScope.user());
            ApiAlertException.throwIfTrue(userId != null && !currentUser.getUserId().equals(userId), "Permission denied, operations can only be performed with the permissions of the currently logged-in user.");
            Long teamId = this.getId(joinPoint, methodSignature, permissionScope.team());
            if (teamId != null) {
                Member member = this.memberService.findByUserName(teamId, currentUser.getUsername());
                ApiAlertException.throwIfTrue(member == null, "Permission denied, only members of this team can access this permission");
            }
            if ((appId = this.getId(joinPoint, methodSignature, permissionScope.app())) != null) {
                Application app = (Application)this.applicationService.getById(appId);
                ApiAlertException.throwIfTrue(app == null, "Invalid operation, application is null");
                if (!currentUser.getUserId().equals(app.getUserId())) {
                    Member member = this.memberService.findByUserName(app.getTeamId(), currentUser.getUsername());
                    ApiAlertException.throwIfTrue(member == null, "Permission denied, this job not created by the current user, And the job cannot be found in the current user's team.");
                }
            }
        }
        return (RestResponse)joinPoint.proceed();
    }

    private Long getId(ProceedingJoinPoint joinPoint, MethodSignature methodSignature, String expr) {
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return null;
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expr);
        StandardEvaluationContext context = new StandardEvaluationContext();
        Object[] args = joinPoint.getArgs();
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(methodSignature.getMethod());
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        Object value = expression.getValue((EvaluationContext)context);
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            throw new ApiAlertException("Wrong use of annotation on method " + methodSignature.getName(), e);
        }
    }
}

