/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV1Serializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV2Serializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;

public class MetadataSerializers {
    private static final Map<Integer, MetadataSerializer> SERIALIZERS = new HashMap<Integer, MetadataSerializer>(3);

    private static void registerSerializer(MetadataSerializer serializer) {
        SERIALIZERS.put(serializer.getVersion(), serializer);
    }

    public static MetadataSerializer getSerializer(int version) {
        MetadataSerializer serializer = SERIALIZERS.get(version);
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("Unrecognized checkpoint version number: " + version);
    }

    private MetadataSerializers() {
    }

    static {
        MetadataSerializers.registerSerializer(MetadataV1Serializer.INSTANCE);
        MetadataSerializers.registerSerializer(MetadataV2Serializer.INSTANCE);
        MetadataSerializers.registerSerializer(MetadataV3Serializer.INSTANCE);
    }
}

