/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.core.scala;

import java.time.Duration;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.runtime.operators.util.AssignerWithPeriodicWatermarksAdapter;
import org.apache.flink.streaming.runtime.operators.util.AssignerWithPunctuatedWatermarksAdapter;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dx!B\n\u0015\u0011\u0003\tc!B\u0012\u0015\u0011\u0003!\u0003\"\u0002\u0016\u0002\t\u0003Yc\u0001\u0002\u0017\u0002\u00015B\u0001bL\u0002\u0003\u0002\u0003\u0006I\u0001\r\u0005\t\t\u000e\u0011\u0019\u0011)A\u0006\u000b\")!f\u0001C\u0001\u001d\")Ak\u0001C\u0001+\")qm\u0001C\u0001Q\"1qp\u0001C\u0001\u0003\u0003Aq!a\n\u0004\t\u0003\tI\u0003C\u0004\u0002@\r!\t!!\u0011\t\u000f\u0005M3\u0001\"\u0001\u0002V!I\u0011QR\u0002\u0012\u0002\u0013\u0005\u0011q\u0012\u0004\u0006C\u0006\u0001\u0011q\u0016\u0005\u000b\u0003gs!Q1A\u0005\u0002\u0005U\u0006BCAd\u001d\t\u0005\t\u0015!\u0003\u00028\"1!F\u0004C\u0001\u0003\u0013Da\u0001\u0016\b\u0005\u0002\u0005=\u0017!\u0004#bi\u0006\u001cFO]3b[\u0016CHO\u0003\u0002\u0016-\u0005)1oY1mC*\u0011q\u0003G\u0001\u0005G>\u0014XM\u0003\u0002\u001a5\u0005)a\r\\5oW*\u00111\u0004H\u0001\u000bgR\u0014X-Y7qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002#\u00035\tACA\u0007ECR\f7\u000b\u001e:fC6,\u0005\u0010^\n\u0003\u0003\u0015\u0002\"A\n\u0015\u000e\u0003\u001dR\u0011!F\u0005\u0003S\u001d\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\"\u0005)!\u0015\r^1TiJ,\u0017-\\\u000b\u0003]m\u001a\"aA\u0013\u0002\u0015\u0011\fG/Y*ue\u0016\fW\u000eE\u00022qej\u0011A\r\u0006\u0003+MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00033qI!\u0001\f\u001a\u0011\u0005iZD\u0002\u0001\u0003\u0006y\r\u0011\r!\u0010\u0002\u0002)F\u0011a(\u0011\t\u0003M}J!\u0001Q\u0014\u0003\u000f9{G\u000f[5oOB\u0011aEQ\u0005\u0003\u0007\u001e\u00121!\u00118z\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\r2KT\"A$\u000b\u0005!K\u0015\u0001\u0003;za\u0016LgNZ8\u000b\u0005)[\u0015AB2p[6|gN\u0003\u00025o%\u0011Qj\u0012\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]R\u0011qj\u0015\u000b\u0003!J\u00032!U\u0002:\u001b\u0005\t\u0001\"\u0002#\u0007\u0001\b)\u0005\"B\u0018\u0007\u0001\u0004\u0001\u0014aB:jI\u0016|U\u000f\u001e\u000b\u0003aYCQaV\u0004A\u0002a\u000b1AZ;o!\u00151\u0013,O.e\u0013\tQvEA\u0005Gk:\u001cG/[8oeA\u0011AL\u0019\t\u0005;\u0002L\u0014(D\u0001_\u0015\ty6'A\u0005gk:\u001cG/[8og&\u0011\u0011M\u0018\u0002\u0010!J|7-Z:t\rVt7\r^5p]&\u00111\r\u0019\u0002\b\u0007>tG/\u001a=u!\t1S-\u0003\u0002gO\t!QK\\5u\u0003\u001d\u0019\u0018\u000eZ3HKR,\"![7\u0015\u0005)\u0014HCA6p!\r\t\u0004\b\u001c\t\u0003u5$QA\u001c\u0005C\u0002u\u0012\u0011A\u0015\u0005\ba\"\t\t\u0011q\u0001r\u0003))g/\u001b3f]\u000e,GE\r\t\u0004\r2c\u0007\"B:\t\u0001\u0004!\u0018aB:jI\u0016$\u0016m\u001a\t\u0003krt!A\u001e>\u0011\u0005]<S\"\u0001=\u000b\u0005e\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002|O\u00051\u0001K]3eK\u001aL!! @\u0003\rM#(/\u001b8h\u0015\tYx%\u0001\u0010c_VtG-\u001a3PkR|em\u0014:eKJtWm]:XCR,'/\\1sWR)\u0001'a\u0001\u0002\u0014!9\u0011QA\u0005A\u0002\u0005\u001d\u0011\u0001\u00024v]\u000e\u0004bAJA\u0005s\u00055\u0011bAA\u0006O\tIa)\u001e8di&|g.\r\t\u0004M\u0005=\u0011bAA\tO\t!Aj\u001c8h\u0011\u001d\t)\"\u0003a\u0001\u0003/\t\u0001\u0002Z;sCRLwN\u001c\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\tAA)\u001e:bi&|g.\u0001\tuS6,G*Y4XCR,'/\\1sWR)\u0001'a\u000b\u0002.!1qK\u0003a\u0001\u0003\u000fAq!a\f\u000b\u0001\u0004\t\t$\u0001\u0006nCb$\u0016.\\3MC\u001e\u0004B!a\r\u0002<5\u0011\u0011Q\u0007\u0006\u0005\u0003;\t9DC\u0002\u0002:M\n\u0011b^5oI><\u0018N\\4\n\t\u0005u\u0012Q\u0007\u0002\u0005)&lW-A\nqk:\u001cG/^1uK\u0012<\u0016\r^3s[\u0006\u00148\u000eF\u00031\u0003\u0007\n9\u0005C\u0004\u0002F-\u0001\r!a\u0002\u0002\u001d\u0015DHO]1diRKW.\u001a$v]\"9\u0011\u0011J\u0006A\u0002\u0005-\u0013!C2iK\u000e\\g)\u001e8d!\u00191\u0013\u0011B\u001d\u0002NA\u0019a%a\u0014\n\u0007\u0005EsEA\u0004C_>dW-\u00198\u0002\tA\u0014xnY\u000b\u0005\u0003/\ny\u0006\u0006\u0004\u0002Z\u0005\u001d\u0014\u0011\u0011\u000b\u0005\u00037\n\t\u0007\u0005\u00032q\u0005u\u0003c\u0001\u001e\u0002`\u0011)a\u000e\u0004b\u0001{!I\u00111\r\u0007\u0002\u0002\u0003\u000f\u0011QM\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003\u0002$M\u0003;Bq!!\u001b\r\u0001\u0004\tY'A\bqe>\u001cWm]:Gk:\u001cG/[8o!%1\u0013QN\u001d\u0002r\u0005UD-C\u0002\u0002p\u001d\u0012\u0011BR;oGRLwN\\\u001a\u0011\u0007\u0005M$\rE\u0003^Af\ni\u0006\u0005\u0004\u0002x\u0005u\u0014QL\u0007\u0003\u0003sR1!a\u001f8\u0003\u0011)H/\u001b7\n\t\u0005}\u0014\u0011\u0010\u0002\n\u0007>dG.Z2u_JD\u0011\"a!\r!\u0003\u0005\r!!\"\u0002\u001f=tG+[7fe\u001a+hn\u0019;j_:\u0004\"BJA7\u0003\u001b\t9)!\u001ee!\u0011\t\u0019(!#\n\u0007\u0005-\u0005M\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\u0002\u001dA\u0014xn\u0019\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011\u0011SAW+\t\t\u0019J\u000b\u0003\u0002\u0016\u0006m\u0005c\u0001\u0014\u0002\u0018&\u0019\u0011\u0011T\u0014\u0003\t9+H\u000e\\\u0016\u0003\u0003;\u0003B!a(\u0002*6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0005v]\u000eDWmY6fI*\u0019\u0011qU\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0006\u0005&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)a.\u0004b\u0001{U1\u0011\u0011WA_\u0003\u0007\u001c\"AD\u0013\u0002\u0007\r$\b0\u0006\u0002\u00028B\u0019\u0011\u0011\u00182\u0011\ru\u0003\u00171XAa!\rQ\u0014Q\u0018\u0003\u0007\u0003\u007fs!\u0019A\u001f\u0003\u0005%s\u0005c\u0001\u001e\u0002D\u00121\u0011Q\u0019\bC\u0002u\u00121aT+U\u0003\u0011\u0019G\u000f\u001f\u0011\u0015\t\u0005-\u0017Q\u001a\t\u0007#:\tY,!1\t\u000f\u0005M\u0016\u00031\u0001\u00028V!\u0011\u0011[Ao)\u0019\t\u0019.a8\u0002dR\u0019A-!6\t\u0013\u0005]'#!AA\u0004\u0005e\u0017AC3wS\u0012,gnY3%iA!a\tTAn!\rQ\u0014Q\u001c\u0003\u0006]J\u0011\r!\u0010\u0005\u0007\u0003C\u0014\u0002\u0019\u0001;\u0002\u0013=,H\u000f];u)\u0006<\u0007bBAs%\u0001\u0007\u00111\\\u0001\u0006m\u0006dW/\u001a")
public final class DataStreamExt {

    public static class DataStream<T> {
        private final org.apache.flink.streaming.api.scala.DataStream<T> dataStream;
        private final TypeInformation<T> evidence$1;

        public org.apache.flink.streaming.api.scala.DataStream<T> sideOut(Function2<T, ProcessFunction.Context, BoxedUnit> fun) {
            return this.dataStream.process(new org.apache.flink.streaming.api.functions.ProcessFunction<T, T>(null, fun){
                private final Function2 fun$1;

                public void processElement(T value, ProcessFunction.Context ctx, Collector<T> out) {
                    this.fun$1.apply(value, (Object)ctx);
                    out.collect(value);
                }
                {
                    this.fun$1 = fun$1;
                }
            }, this.evidence$1);
        }

        public <R> org.apache.flink.streaming.api.scala.DataStream<R> sideGet(String sideTag, TypeInformation<R> evidence$2) {
            return this.dataStream.getSideOutput(new org.apache.flink.streaming.api.scala.OutputTag(sideTag, evidence$2), evidence$2);
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> boundedOutOfOrdernessWatermark(Function1<T, Object> func, Duration duration) {
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forBoundedOutOfOrderness((Duration)duration).withTimestampAssigner(new SerializableTimestampAssigner<T>(null, func){
                private final Function1 func$1;

                public long extractTimestamp(T element, long recordTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.func$1.apply(element));
                }
                {
                    this.func$1 = func$1;
                }
            }));
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> timeLagWatermark(Function1<T, Object> fun, Time maxTimeLag) {
            AssignerWithPeriodicWatermarks assigner = new AssignerWithPeriodicWatermarks<T>(null, fun, maxTimeLag){
                private final Function1 fun$2;
                private final Time maxTimeLag$1;

                public long extractTimestamp(T element, long previousElementTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.fun$2.apply(element));
                }

                public Watermark getCurrentWatermark() {
                    return new Watermark(System.currentTimeMillis() - this.maxTimeLag$1.toMilliseconds());
                }
                {
                    void var3_3;
                    this.fun$2 = fun$2;
                    this.maxTimeLag$1 = var3_3;
                }
            };
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)new AssignerWithPeriodicWatermarksAdapter.Strategy(assigner)));
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> punctuatedWatermark(Function1<T, Object> extractTimeFun, Function1<T, Object> checkFunc) {
            AssignerWithPunctuatedWatermarks assigner = new AssignerWithPunctuatedWatermarks<T>(null, extractTimeFun, checkFunc){
                private final Function1 extractTimeFun$1;
                private final Function1 checkFunc$1;

                public long extractTimestamp(T element, long previousElementTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.extractTimeFun$1.apply(element));
                }

                public Watermark checkAndGetNextWatermark(T lastElement, long extractedTimestamp) {
                    return BoxesRunTime.unboxToBoolean((Object)this.checkFunc$1.apply(lastElement)) ? new Watermark(extractedTimestamp) : null;
                }
                {
                    void var3_3;
                    this.extractTimeFun$1 = extractTimeFun$1;
                    this.checkFunc$1 = var3_3;
                }
            };
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)new AssignerWithPunctuatedWatermarksAdapter.Strategy(assigner)));
        }

        public <R> org.apache.flink.streaming.api.scala.DataStream<R> proc(Function3<T, ProcessFunction.Context, Collector<R>, BoxedUnit> processFunction, Function3<Object, ProcessFunction.OnTimerContext, Collector<R>, BoxedUnit> onTimerFunction, TypeInformation<R> evidence$3) {
            return this.dataStream.process(new org.apache.flink.streaming.api.functions.ProcessFunction<T, R>(null, processFunction, onTimerFunction){
                private final Function3 processFunction$1;
                private final Function3 onTimerFunction$1;

                public void processElement(T value, ProcessFunction.Context ctx, Collector<R> out) {
                    this.processFunction$1.apply(value, (Object)ctx, out);
                }

                public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<R> out) {
                    if (this.onTimerFunction$1 != null) {
                        this.onTimerFunction$1.apply((Object)BoxesRunTime.boxToLong((long)timestamp), (Object)ctx, out);
                    } else {
                        super.onTimer(timestamp, ctx, out);
                    }
                }
                {
                    void var3_3;
                    this.processFunction$1 = processFunction$1;
                    this.onTimerFunction$1 = var3_3;
                }
            }, evidence$3);
        }

        public <R> Null$ proc$default$2() {
            return null;
        }

        public DataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, TypeInformation<T> evidence$1) {
            this.dataStream = dataStream;
            this.evidence$1 = evidence$1;
        }
    }

    public static class ProcessFunction<IN, OUT> {
        private final ProcessFunction.Context ctx;

        public ProcessFunction.Context ctx() {
            return this.ctx;
        }

        public <R> void sideOut(String outputTag, R value, TypeInformation<R> evidence$4) {
            org.apache.flink.streaming.api.scala.OutputTag tag = new org.apache.flink.streaming.api.scala.OutputTag(outputTag, evidence$4);
            this.ctx().output((OutputTag)tag, value);
        }

        public ProcessFunction(ProcessFunction.Context ctx) {
            this.ctx = ctx;
        }
    }
}

