/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.ConsumerRegionGroupExecutionView;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.ConsumerRegionGroupExecutionViewMaintainer;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PartitionGroupReleaseStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PipelinedRegionExecutionView;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

public class RegionPartitionGroupReleaseStrategy
implements PartitionGroupReleaseStrategy {
    private final SchedulingTopology schedulingTopology;
    private final Map<ExecutionVertexID, PipelinedRegionExecutionView> regionExecutionViewByVertex = new HashMap<ExecutionVertexID, PipelinedRegionExecutionView>();
    private final Map<ConsumedPartitionGroup, ConsumerRegionGroupExecutionView> partitionGroupConsumerRegions = new HashMap<ConsumedPartitionGroup, ConsumerRegionGroupExecutionView>();
    private final ConsumerRegionGroupExecutionViewMaintainer consumerRegionGroupExecutionViewMaintainer;

    public RegionPartitionGroupReleaseStrategy(SchedulingTopology schedulingTopology) {
        this.schedulingTopology = (SchedulingTopology)Preconditions.checkNotNull((Object)schedulingTopology);
        this.initRegionExecutionViewByVertex();
        this.initPartitionGroupConsumerRegions();
        this.consumerRegionGroupExecutionViewMaintainer = new ConsumerRegionGroupExecutionViewMaintainer(this.partitionGroupConsumerRegions.values());
    }

    private void initRegionExecutionViewByVertex() {
        for (SchedulingPipelinedRegion pipelinedRegion : this.schedulingTopology.getAllPipelinedRegions()) {
            PipelinedRegionExecutionView regionExecutionView = new PipelinedRegionExecutionView(pipelinedRegion);
            for (SchedulingExecutionVertex executionVertexId : pipelinedRegion.getVertices()) {
                this.regionExecutionViewByVertex.put((ExecutionVertexID)executionVertexId.getId(), regionExecutionView);
            }
        }
    }

    private void initPartitionGroupConsumerRegions() {
        for (SchedulingPipelinedRegion region : this.schedulingTopology.getAllPipelinedRegions()) {
            for (ConsumedPartitionGroup consumedPartitionGroup : region.getAllBlockingConsumedPartitionGroups()) {
                this.partitionGroupConsumerRegions.computeIfAbsent(consumedPartitionGroup, g -> new ConsumerRegionGroupExecutionView()).add(region);
            }
        }
    }

    @Override
    public List<ConsumedPartitionGroup> vertexFinished(ExecutionVertexID finishedVertex) {
        PipelinedRegionExecutionView regionExecutionView = this.getPipelinedRegionExecutionViewForVertex(finishedVertex);
        regionExecutionView.vertexFinished(finishedVertex);
        if (regionExecutionView.isFinished()) {
            SchedulingPipelinedRegion pipelinedRegion = (SchedulingPipelinedRegion)this.schedulingTopology.getPipelinedRegionOfVertex(finishedVertex);
            this.consumerRegionGroupExecutionViewMaintainer.regionFinished(pipelinedRegion);
            return this.filterReleasablePartitionGroups(pipelinedRegion.getAllBlockingConsumedPartitionGroups());
        }
        return Collections.emptyList();
    }

    @Override
    public void vertexUnfinished(ExecutionVertexID executionVertexId) {
        PipelinedRegionExecutionView regionExecutionView = this.getPipelinedRegionExecutionViewForVertex(executionVertexId);
        regionExecutionView.vertexUnfinished(executionVertexId);
        SchedulingPipelinedRegion pipelinedRegion = (SchedulingPipelinedRegion)this.schedulingTopology.getPipelinedRegionOfVertex(executionVertexId);
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished(pipelinedRegion);
    }

    private PipelinedRegionExecutionView getPipelinedRegionExecutionViewForVertex(ExecutionVertexID executionVertexId) {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = this.regionExecutionViewByVertex.get(executionVertexId);
        Preconditions.checkState((pipelinedRegionExecutionView != null ? 1 : 0) != 0, (String)"PipelinedRegionExecutionView not found for execution vertex %s", (Object[])new Object[]{executionVertexId});
        return pipelinedRegionExecutionView;
    }

    private List<ConsumedPartitionGroup> filterReleasablePartitionGroups(Iterable<ConsumedPartitionGroup> consumedPartitionGroups) {
        ArrayList<ConsumedPartitionGroup> releasablePartitionGroups = new ArrayList<ConsumedPartitionGroup>();
        for (ConsumedPartitionGroup consumedPartitionGroup : consumedPartitionGroups) {
            ConsumerRegionGroupExecutionView consumerRegionGroup = this.partitionGroupConsumerRegions.get(consumedPartitionGroup);
            if (!consumerRegionGroup.isFinished()) continue;
            releasablePartitionGroups.add(consumedPartitionGroup);
        }
        return releasablePartitionGroups;
    }

    public static class Factory
    implements PartitionGroupReleaseStrategy.Factory {
        @Override
        public PartitionGroupReleaseStrategy createInstance(SchedulingTopology schedulingStrategy) {
            return new RegionPartitionGroupReleaseStrategy(schedulingStrategy);
        }
    }
}

