/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClientFactory;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.AbstractID;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.DeployResponse$;
import org.apache.streampark.flink.client.bean.KubernetesDeployRequest;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.client.bean.ShutDownResponse$;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.tool.FlinkSessionSubmitHelper$;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import org.apache.streampark.flink.client.trait.FlinkClientTrait$class;
import org.apache.streampark.flink.client.trait.KubernetesNativeClientTrait;
import org.apache.streampark.flink.client.trait.KubernetesNativeClientTrait$class;
import org.apache.streampark.flink.deployment.FlinkKubernetesClient;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesNativeSessionClient$
implements KubernetesNativeClientTrait {
    public static final KubernetesNativeSessionClient$ MODULE$;
    private final String PARAM_KEY_FLINK_CONF;
    private final String PARAM_KEY_FLINK_SQL;
    private final String PARAM_KEY_APP_CONF;
    private final String PARAM_KEY_APP_NAME;
    private final String PARAM_KEY_FLINK_PARALLELISM;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new KubernetesNativeSessionClient$();
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait$class.cancelJob(this, cancelRequest, jobID, client);
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait$class.triggerSavepoint(this, savepointRequest, jobID, client);
    }

    @Override
    public void setConfig(SubmitRequest submitRequest, Configuration flinkConfig) {
        KubernetesNativeClientTrait$class.setConfig(this, submitRequest, flinkConfig);
    }

    @Override
    public <O, R extends SavepointRequestTrait> O executeClientAction(R request, Configuration flinkConfig, Function2<JobID, ClusterClient<?>, O> actFunc) {
        return (O)KubernetesNativeClientTrait$class.executeClientAction(this, request, flinkConfig, actFunc);
    }

    @Override
    public Tuple2<KubernetesClusterDescriptor, ClusterSpecification> getK8sClusterDescriptorAndSpecification(Configuration flinkConfig) {
        return KubernetesNativeClientTrait$class.getK8sClusterDescriptorAndSpecification(this, flinkConfig);
    }

    @Override
    public KubernetesClusterDescriptor getK8sClusterDescriptor(Configuration flinkConfig) {
        return KubernetesNativeClientTrait$class.getK8sClusterDescriptor(this, flinkConfig);
    }

    @Override
    public String flinkConfIdentifierInfo(@Nonnull Configuration conf) {
        return KubernetesNativeClientTrait$class.flinkConfIdentifierInfo(this, conf);
    }

    @Override
    public String getDefaultKubernetesConf(String k8sConf) {
        return KubernetesNativeClientTrait$class.getDefaultKubernetesConf(this, k8sConf);
    }

    private String PARAM_KEY_FLINK_CONF$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PARAM_KEY_FLINK_CONF = FlinkClientTrait$class.PARAM_KEY_FLINK_CONF(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.PARAM_KEY_FLINK_CONF;
        }
    }

    @Override
    public String PARAM_KEY_FLINK_CONF() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PARAM_KEY_FLINK_CONF$lzycompute() : this.PARAM_KEY_FLINK_CONF;
    }

    private String PARAM_KEY_FLINK_SQL$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.PARAM_KEY_FLINK_SQL = FlinkClientTrait$class.PARAM_KEY_FLINK_SQL(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.PARAM_KEY_FLINK_SQL;
        }
    }

    @Override
    public String PARAM_KEY_FLINK_SQL() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.PARAM_KEY_FLINK_SQL$lzycompute() : this.PARAM_KEY_FLINK_SQL;
    }

    private String PARAM_KEY_APP_CONF$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.PARAM_KEY_APP_CONF = FlinkClientTrait$class.PARAM_KEY_APP_CONF(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.PARAM_KEY_APP_CONF;
        }
    }

    @Override
    public String PARAM_KEY_APP_CONF() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.PARAM_KEY_APP_CONF$lzycompute() : this.PARAM_KEY_APP_CONF;
    }

    private String PARAM_KEY_APP_NAME$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.PARAM_KEY_APP_NAME = FlinkClientTrait$class.PARAM_KEY_APP_NAME(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.PARAM_KEY_APP_NAME;
        }
    }

    @Override
    public String PARAM_KEY_APP_NAME() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.PARAM_KEY_APP_NAME$lzycompute() : this.PARAM_KEY_APP_NAME;
    }

    private String PARAM_KEY_FLINK_PARALLELISM$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.PARAM_KEY_FLINK_PARALLELISM = FlinkClientTrait$class.PARAM_KEY_FLINK_PARALLELISM(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.PARAM_KEY_FLINK_PARALLELISM;
        }
    }

    @Override
    public String PARAM_KEY_FLINK_PARALLELISM() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.PARAM_KEY_FLINK_PARALLELISM$lzycompute() : this.PARAM_KEY_FLINK_PARALLELISM;
    }

    @Override
    public SubmitResponse submit(SubmitRequest submitRequest) throws Exception {
        return FlinkClientTrait$class.submit(this, submitRequest);
    }

    @Override
    public SavepointResponse triggerSavepoint(TriggerSavepointRequest savepointRequest) throws Exception {
        return FlinkClientTrait$class.triggerSavepoint(this, savepointRequest);
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) throws Exception {
        return FlinkClientTrait$class.cancel(this, cancelRequest);
    }

    @Override
    public SubmitResponse trySubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3<SubmitRequest, Configuration, File, SubmitResponse> jobGraphFunc, Function3<SubmitRequest, Configuration, File, SubmitResponse> restApiFunc) {
        return FlinkClientTrait$class.trySubmit(this, submitRequest, flinkConfig, jarFile, jobGraphFunc, restApiFunc);
    }

    @Override
    public Tuple2<PackagedProgram, JobGraph> getJobGraph(Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        return FlinkClientTrait$class.getJobGraph(this, flinkConfig, submitRequest, jarFile);
    }

    @Override
    public JobID getJobID(String jobId) {
        return FlinkClientTrait$class.getJobID(this, jobId);
    }

    @Override
    public CustomCommandLine validateAndGetActiveCommandLine(List<CustomCommandLine> customCommandLines, CommandLine commandLine) {
        return FlinkClientTrait$class.validateAndGetActiveCommandLine(this, customCommandLines, commandLine);
    }

    @Override
    public Integer getParallelism(SubmitRequest submitRequest) {
        return FlinkClientTrait$class.getParallelism(this, submitRequest);
    }

    @Override
    public Options getCommandLineOptions(String flinkHome) {
        return FlinkClientTrait$class.getCommandLineOptions(this, flinkHome);
    }

    @Override
    public Configuration extractConfiguration(String flinkHome, Map<String, Object> properties) {
        return FlinkClientTrait$class.extractConfiguration(this, flinkHome, properties);
    }

    @Override
    public FlinkClientTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(Configuration flinkConfig) {
        return FlinkClientTrait$class.EnhanceFlinkConfiguration(this, flinkConfig);
    }

    @Override
    public String cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait$class.cancelJob(this, cancelRequest, jobID, client);
    }

    @Override
    public String triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait$class.triggerSavepoint(this, savepointRequest, jobID, client);
    }

    @Override
    public void closeSubmit(SubmitRequest submitRequest, Seq<AutoCloseable> close) {
        FlinkClientTrait$class.closeSubmit(this, submitRequest, close);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    @Override
    public SubmitResponse doSubmit(SubmitRequest submitRequest, Configuration flinkConfig) throws Exception {
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)submitRequest.clusterId()), (Function0)new Serializable(flinkConfig){
            public static final long serialVersionUID = 0L;
            private final Configuration flinkConfig$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] submit flink job failed, clusterId is null, mode=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkConfig$1.get(DeploymentOptions.TARGET)}));
            }
            {
                this.flinkConfig$1 = flinkConfig$1;
            }
        });
        return FlinkClientTrait$class.trySubmit(this, submitRequest, flinkConfig, submitRequest.userJarFile(), (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SubmitResponse apply(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile) {
                return KubernetesNativeSessionClient$.MODULE$.jobGraphSubmit(submitRequest, flinkConfig, jarFile);
            }
        }, (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SubmitResponse apply(SubmitRequest submitRequest, Configuration flinkConfig, File fatJar) {
                return KubernetesNativeSessionClient$.MODULE$.restApiSubmit(submitRequest, flinkConfig, fatJar);
            }
        });
    }

    public SubmitResponse restApiSubmit(SubmitRequest submitRequest, Configuration flinkConfig, File fatJar) throws Exception {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(submitRequest, flinkConfig, fatJar){
            public static final long serialVersionUID = 0L;
            private final SubmitRequest submitRequest$2;
            private final Configuration flinkConfig$3;
            private final File fatJar$1;

            public final SubmitResponse apply() {
                ClusterKey clusterKey = new ClusterKey(FlinkK8sExecuteMode$.MODULE$.SESSION(), this.submitRequest$2.kubernetesNamespace(), this.submitRequest$2.clusterId());
                String jmRestUrl = (String)KubernetesRetriever$.MODULE$.retrieveFlinkRestUrl(clusterKey).getOrElse((Function0)new Serializable(this, clusterKey){
                    public static final long serialVersionUID = 0L;
                    private final ClusterKey clusterKey$1;

                    public final Nothing$ apply() {
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] retrieve flink session rest url failed, clusterKey=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterKey$1})));
                    }
                    {
                        this.clusterKey$1 = clusterKey$1;
                    }
                });
                String jobId = FlinkSessionSubmitHelper$.MODULE$.submitViaRestApi(jmRestUrl, this.fatJar$1, this.flinkConfig$3);
                return new SubmitResponse(clusterKey.clusterId(), this.flinkConfig$3.toMap(), jobId, jmRestUrl);
            }
            {
                this.submitRequest$2 = submitRequest$2;
                this.flinkConfig$3 = flinkConfig$3;
                this.fatJar$1 = fatJar$1;
            }
        });
        if (try_ instanceof Success) {
            SubmitResponse s;
            Success success2 = (Success)try_;
            SubmitResponse submitResponse = s = (SubmitResponse)success2.value();
            return submitResponse;
        }
        if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable e = failure2.exception();
            this.logError((Function0<String>)new Serializable(submitRequest){
                public static final long serialVersionUID = 0L;
                private final SubmitRequest submitRequest$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"submit flink job fail in ", " mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submitRequest$2.executionMode()}));
                }
                {
                    this.submitRequest$2 = submitRequest$2;
                }
            });
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    /*
     * WARNING - void declaration
     */
    public SubmitResponse jobGraphSubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile) throws Exception {
        SubmitResponse submitResponse;
        KubernetesClusterDescriptor clusterDescriptor = null;
        PackagedProgram packageProgram = null;
        ClusterClient client = null;
        try {
            clusterDescriptor = this.getK8sClusterDescriptor(flinkConfig);
            Tuple2 packageProgramJobGraph = FlinkClientTrait$class.getJobGraph(this, flinkConfig, submitRequest, jarFile);
            packageProgram = (PackagedProgram)packageProgramJobGraph._1();
            JobGraph jobGraph = (JobGraph)packageProgramJobGraph._2();
            client = clusterDescriptor.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
            CompletableFuture submitResult = client.submitJob(jobGraph);
            String jobId = ((AbstractID)submitResult.get()).toString();
            SubmitResponse result2 = new SubmitResponse((String)client.getClusterId(), flinkConfig.toMap(), jobId, client.getWebInterfaceURL());
            this.logInfo((Function0<String>)new Serializable(flinkConfig, jobId){
                public static final long serialVersionUID = 0L;
                private final Configuration flinkConfig$2;
                private final String jobId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] flink job has been submitted. ", ", jobId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KubernetesNativeSessionClient$.MODULE$.flinkConfIdentifierInfo(this.flinkConfig$2), this.jobId$1}));
                }
                {
                    this.flinkConfig$2 = flinkConfig$2;
                    this.jobId$1 = jobId$1;
                }
            });
            submitResponse = result2;
        }
        catch (Exception exception) {
            try {
                this.logError((Function0<String>)new Serializable(submitRequest){
                    public static final long serialVersionUID = 0L;
                    private final SubmitRequest submitRequest$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"submit flink job fail in ", " mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submitRequest$1.executionMode()}));
                    }
                    {
                        this.submitRequest$1 = submitRequest$1;
                    }
                });
                exception.printStackTrace();
                throw exception;
            }
            catch (Throwable throwable) {
                void var6_6;
                void var4_4;
                if (submitRequest.safePackageProgram()) {
                    void var5_5;
                    Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PackagedProgram[]{var5_5}));
                    Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
                    Utils$.MODULE$.close(x$1, x$2);
                }
                void x$3 = var4_4;
                void x$4 = var6_6;
                Function1 x$5 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}));
                Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}), x$5);
                throw throwable;
            }
        }
        if (submitRequest.safePackageProgram()) {
            Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PackagedProgram[]{packageProgram}));
            Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
            Utils$.MODULE$.close(x$1, x$2);
        }
        KubernetesClusterDescriptor x$3 = clusterDescriptor;
        ClusterClient x$4 = client;
        Function1 x$5 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}));
        Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}), x$5);
        return submitResponse;
    }

    @Override
    public CancelResponse doCancel(CancelRequest cancelRequest, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_SESSION.getName());
        return KubernetesNativeClientTrait$class.doCancel(this, cancelRequest, flinkConf);
    }

    public DeployResponse deploy(DeployRequest deployReq) throws Exception {
        DeployResponse deployResponse;
        KubernetesDeployRequest deployRequest = (KubernetesDeployRequest)deployReq;
        this.logInfo((Function0<String>)new Serializable(deployRequest){
            public static final long serialVersionUID = 0L;
            private final KubernetesDeployRequest deployRequest$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |--------------------------------------- kubernetes session cluster start ---------------------------------------\n         |    userFlinkHome    : ", "\n         |    flinkVersion     : ", "\n         |    execMode         : ", "\n         |    clusterId        : ", "\n         |    namespace        : ", "\n         |    exposedType      : ", "\n         |    serviceAccount   : ", "\n         |    flinkImage       : ", "\n         |    properties       : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deployRequest$1.flinkVersion().flinkHome(), this.deployRequest$1.flinkVersion().version(), this.deployRequest$1.executionMode().name(), this.deployRequest$1.clusterId(), this.deployRequest$1.kubernetesNamespace(), this.deployRequest$1.flinkRestExposedType(), this.deployRequest$1.serviceAccount(), this.deployRequest$1.flinkImage(), JavaConversions$.MODULE$.mapAsScalaMap(this.deployRequest$1.properties()).mkString(" ")})))).stripMargin();
            }
            {
                this.deployRequest$1 = deployRequest$1;
            }
        });
        Configuration flinkConfig = this.getFlinkK8sConfig(deployRequest);
        FlinkSessionSubmitHelper$.MODULE$.doReplaceJobName(flinkConfig, deployRequest.clusterName());
        FlinkKubeClient kubeClient = FlinkKubeClientFactory.getInstance().fromConfiguration(flinkConfig, "client");
        KubernetesClusterDescriptor clusterDescriptor = null;
        ClusterClient client = null;
        try {
            try {
                Tuple2<KubernetesClusterDescriptor, ClusterSpecification> kubernetesClusterDescriptor = this.getK8sClusterDescriptorAndSpecification(flinkConfig);
                clusterDescriptor = (KubernetesClusterDescriptor)kubernetesClusterDescriptor._1();
                FlinkKubernetesClient kubeClientWrapper = new FlinkKubernetesClient(kubeClient);
                Optional kubeService = kubeClientWrapper.getService(deployRequest.clusterId());
                client = kubeService.isPresent() ? clusterDescriptor.retrieve(deployRequest.clusterId()).getClusterClient() : clusterDescriptor.deploySessionCluster((ClusterSpecification)kubernetesClusterDescriptor._2()).getClusterClient();
                deployResponse = new DeployResponse(client.getWebInterfaceURL(), (String)client.getClusterId(), DeployResponse$.MODULE$.apply$default$3());
            }
            catch (Exception exception) {
                Exception x$6 = exception;
                String x$7 = DeployResponse$.MODULE$.apply$default$1();
                String x$8 = DeployResponse$.MODULE$.apply$default$2();
                deployResponse = new DeployResponse(x$7, x$8, (Throwable)x$6);
            }
        }
        catch (Throwable throwable) {
            ClusterClient x$9 = client;
            KubernetesClusterDescriptor x$10 = clusterDescriptor;
            FlinkKubeClient x$11 = kubeClient;
            Function1 x$12 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$9, x$10, x$11}));
            Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$9, x$10, x$11}), x$12);
            throw throwable;
        }
        ClusterClient x$9 = client;
        KubernetesClusterDescriptor x$10 = clusterDescriptor;
        FlinkKubeClient x$11 = kubeClient;
        Function1 x$12 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$9, x$10, x$11}));
        Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$9, x$10, x$11}), x$12);
        return deployResponse;
    }

    public ShutDownResponse shutdown(DeployRequest deployRequest) throws Exception {
        Try try_;
        block4: {
            Try try_2;
            block7: {
                ShutDownResponse shutDownResponse;
                block3: {
                    ShutDownResponse shutDownResponse2;
                    block6: {
                        block5: {
                            block2: {
                                KubernetesDeployRequest shutDownRequest = (KubernetesDeployRequest)deployRequest;
                                this.logInfo((Function0<String>)new Serializable(shutDownRequest){
                                    public static final long serialVersionUID = 0L;
                                    private final KubernetesDeployRequest shutDownRequest$1;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |--------------------------------------- kubernetes session cluster shutdown ---------------------------------------\n         |    userFlinkHome     : ", "\n         |    namespace         : ", "\n         |    clusterId         : ", "\n         |    execMode          : ", "\n         |    flinkImage        : ", "\n         |    exposedType       : ", "\n         |    kubeConf          : ", "\n         |    serviceAccount    : ", "\n         |    properties        : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shutDownRequest$1.flinkVersion().version(), this.shutDownRequest$1.kubernetesNamespace(), this.shutDownRequest$1.clusterId(), this.shutDownRequest$1.executionMode().getName(), this.shutDownRequest$1.flinkImage(), this.shutDownRequest$1.flinkRestExposedType().getName(), this.shutDownRequest$1.kubeConf(), this.shutDownRequest$1.serviceAccount(), JavaConversions$.MODULE$.mapAsScalaMap(this.shutDownRequest$1.properties()).mkString(" ")})))).stripMargin();
                                    }
                                    {
                                        this.shutDownRequest$1 = shutDownRequest$1;
                                    }
                                });
                                Configuration flinkConfig = this.getFlinkK8sConfig(shutDownRequest);
                                KubernetesClusterDescriptor clusterDescriptor = this.getK8sClusterDescriptor(flinkConfig);
                                try_ = Try$.MODULE$.apply((Function0)new Serializable(flinkConfig, clusterDescriptor){
                                    public static final long serialVersionUID = 0L;
                                    private final Configuration flinkConfig$4;
                                    private final KubernetesClusterDescriptor clusterDescriptor$1;

                                    public final ClusterClient<String> apply() {
                                        return this.clusterDescriptor$1.retrieve(this.flinkConfig$4.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
                                    }
                                    {
                                        this.flinkConfig$4 = flinkConfig$4;
                                        this.clusterDescriptor$1 = clusterDescriptor$1;
                                    }
                                });
                                if (!(try_ instanceof Failure)) break block2;
                                Failure failure2 = (Failure)try_;
                                Throwable e = failure2.exception();
                                shutDownResponse = new ShutDownResponse(e);
                                break block3;
                            }
                            if (!(try_ instanceof Success)) break block4;
                            Success success2 = (Success)try_;
                            ClusterClient c = (ClusterClient)success2.value();
                            try_2 = Try$.MODULE$.apply((Function0)new Serializable(c){
                                public static final long serialVersionUID = 0L;
                                private final ClusterClient c$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.c$1.shutDownCluster();
                                }
                                {
                                    this.c$1 = c$1;
                                }
                            });
                            if (!(try_2 instanceof Success)) break block5;
                            shutDownResponse2 = new ShutDownResponse(ShutDownResponse$.MODULE$.apply$default$1());
                            break block6;
                        }
                        if (!(try_2 instanceof Failure)) break block7;
                        Failure failure3 = (Failure)try_2;
                        Throwable e = failure3.exception();
                        shutDownResponse2 = new ShutDownResponse(e);
                    }
                    shutDownResponse = shutDownResponse2;
                }
                return shutDownResponse;
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    private Configuration getFlinkK8sConfig(KubernetesDeployRequest deployRequest) {
        return this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.extractConfiguration(deployRequest.flinkVersion().flinkHome(), deployRequest.properties())).safeSet(DeploymentOptions.TARGET, KubernetesDeploymentTarget.SESSION.getName())).safeSet(KubernetesConfigOptions.NAMESPACE, deployRequest.kubernetesNamespace())).safeSet(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT, deployRequest.serviceAccount())).safeSet(KubernetesConfigOptions.CLUSTER_ID, deployRequest.clusterId())).safeSet(KubernetesConfigOptions.CONTAINER_IMAGE, deployRequest.flinkImage())).safeSet(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, KubernetesConfigOptions.ServiceExposedType.valueOf((String)deployRequest.flinkRestExposedType().getName()))).safeSet(KubernetesConfigOptions.KUBE_CONFIG_FILE, this.getDefaultKubernetesConf(deployRequest.kubeConf()))).safeSet(DeploymentOptionsInternal.CONF_DIR, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deployRequest.flinkVersion().flinkHome()})));
    }

    @Override
    public SavepointResponse doTriggerSavepoint(TriggerSavepointRequest request, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_SESSION.getName());
        return KubernetesNativeClientTrait$class.doTriggerSavepoint(this, request, flinkConf);
    }

    private KubernetesNativeSessionClient$() {
        MODULE$ = this;
        Logger.class.$init$((Logger)this);
        FlinkClientTrait$class.$init$(this);
        KubernetesNativeClientTrait$class.$init$(this);
    }
}

