/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.streampark.console.base.domain.router.RouterTree;
import org.apache.streampark.console.base.domain.router.VueRouter;

public final class VueRouterUtils {
    private static final String TOP_NODE_ID = "0";

    private VueRouterUtils() {
    }

    public static <T> RouterTree<T> buildRouterTree(List<RouterTree<T>> nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList topNodes = new ArrayList();
        nodes.forEach(node -> {
            String pid = node.getParentId();
            if (pid == null || TOP_NODE_ID.equals(pid)) {
                topNodes.add(node);
                return;
            }
            for (RouterTree n : nodes) {
                String id = n.getId();
                if (id == null || !id.equals(pid)) continue;
                if (n.getChildren() == null) {
                    n.initChildren();
                }
                n.getChildren().add(node);
                node.setHasParent(true);
                n.setHasChildren(true);
                n.setHasParent(true);
                return;
            }
            if (topNodes.isEmpty()) {
                topNodes.add(node);
            }
        });
        RouterTree root = new RouterTree();
        root.setId(TOP_NODE_ID);
        root.setParentId("");
        root.setHasParent(false);
        root.setHasChildren(true);
        root.setChildren(topNodes);
        root.setText("root");
        return root;
    }

    public static <T> ArrayList<VueRouter<T>> buildVueRouter(List<VueRouter<T>> routes) {
        if (routes == null) {
            return null;
        }
        ArrayList topRoutes = new ArrayList();
        routes.forEach(route -> {
            String parentId = route.getParentId();
            if (parentId == null || TOP_NODE_ID.equals(parentId)) {
                topRoutes.add(route);
                return;
            }
            for (VueRouter parent : routes) {
                String id = parent.getId();
                if (!parentId.equals(id)) continue;
                if (parent.getChildren() == null) {
                    parent.initChildren();
                }
                parent.getChildren().add(route);
                parent.setHasChildren(true);
                route.setHasParent(true);
                parent.setHasParent(true);
                return;
            }
        });
        ArrayList<VueRouter<T>> list = new ArrayList<VueRouter<T>>();
        VueRouter root = new VueRouter();
        root.setName("Root");
        root.setComponent("BasicView");
        root.setPath("/");
        root.setChildren(topRoutes);
        list.add(root);
        return list;
    }
}

