/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import javax.annotation.Nullable;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.Savepoint;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.SavepointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/savepoint"})
public class SavepointController {
    private static final Logger log = LoggerFactory.getLogger(SavepointController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SavepointService savepointService;

    @PostMapping(value={"history"})
    @PermissionScope(app="#sp.appId", team="#sp.teamId")
    public RestResponse history(Savepoint sp, RestRequest request) {
        IPage<Savepoint> page = this.savepointService.page(sp, request);
        return RestResponse.success(page);
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"savepoint:delete"})
    @PermissionScope(app="#sp.appId", team="#sp.teamId")
    public RestResponse delete(Savepoint sp) throws InternalException {
        Savepoint savepoint = (Savepoint)this.savepointService.getById(sp.getId());
        Application application = (Application)this.applicationService.getById(savepoint.getAppId());
        Boolean deleted = this.savepointService.delete(sp.getId(), application);
        return RestResponse.success(deleted);
    }

    @PostMapping(value={"trigger"})
    @RequiresPermissions(value={"savepoint:trigger"})
    @PermissionScope(app="#savepoint.appId", team="#savepoint.teamId")
    public RestResponse trigger(Savepoint savepoint, @Nullable String savepointPath) throws Exception {
        this.savepointService.trigger(savepoint.getAppId(), savepointPath);
        return RestResponse.success(true);
    }
}

