/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

abstract class TwofishCBC
implements Cipher {
    private static final int ivsize = 16;
    private BufferedBlockCipher cipher;

    TwofishCBC() {
    }

    @Override
    public int getIVSize() {
        return 16;
    }

    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        int bsize;
        byte[] tmp;
        if (iv.length > 16) {
            tmp = new byte[16];
            System.arraycopy(iv, 0, tmp, 0, tmp.length);
            iv = tmp;
        }
        if (key.length > (bsize = this.getBlockSize())) {
            tmp = new byte[bsize];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        try {
            ParametersWithIV keyspec = new ParametersWithIV((CipherParameters)new KeyParameter(key, 0, key.length), iv, 0, iv.length);
            this.cipher = new DefaultBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)new TwofishEngine()));
            this.cipher.init(mode == 0, (CipherParameters)keyspec);
        }
        catch (Exception e) {
            this.cipher = null;
            throw e;
        }
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.cipher.processBytes(foo, s1, len, bar, s2);
    }

    @Override
    public boolean isCBC() {
        return true;
    }
}

