/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt;

import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.DecoderResult;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttConnAckMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttConnectMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttConnectPayload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttFixedHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttPubAckMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttPublishMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttSubAckMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttSubAckPayload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttSubscribePayload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.mqtt.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubAckPayload)payload);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (ByteBuf)payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: {
                return new MqttMessage(mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return new MqttMessage(mqttFixedHeader, (MqttReasonCodeAndPropertiesVariableHeader)variableHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure(cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure(cause));
    }

    private MqttMessageFactory() {
    }
}

