/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.configuration;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.util.Preconditions;

@Internal
public enum KubernetesDeploymentTarget {
    SESSION("kubernetes-session"),
    APPLICATION("kubernetes-application");

    private final String name;

    private KubernetesDeploymentTarget(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public static KubernetesDeploymentTarget fromConfig(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String deploymentTargetStr = (String)configuration.get(DeploymentOptions.TARGET);
        KubernetesDeploymentTarget deploymentTarget = KubernetesDeploymentTarget.getFromName(deploymentTargetStr);
        if (deploymentTarget == null) {
            throw new IllegalArgumentException("Unknown Kubernetes deployment target \"" + deploymentTargetStr + "\". The available options are: " + KubernetesDeploymentTarget.options());
        }
        return deploymentTarget;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isValidKubernetesTarget(String configValue) {
        return configValue != null && Arrays.stream(KubernetesDeploymentTarget.values()).anyMatch(kubernetesDeploymentTarget -> kubernetesDeploymentTarget.name.equalsIgnoreCase(configValue));
    }

    private static KubernetesDeploymentTarget getFromName(String deploymentTarget) {
        if (deploymentTarget == null) {
            return null;
        }
        if (KubernetesDeploymentTarget.SESSION.name.equalsIgnoreCase(deploymentTarget)) {
            return SESSION;
        }
        if (KubernetesDeploymentTarget.APPLICATION.name.equalsIgnoreCase(deploymentTarget)) {
            return APPLICATION;
        }
        return null;
    }

    private static String options() {
        return Arrays.stream(KubernetesDeploymentTarget.values()).map(KubernetesDeploymentTarget::getName).collect(Collectors.joining(","));
    }
}

