/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.trait;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.kubernetes.KubernetesClusterClientFactory;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.trait.KubernetesNativeClientTrait;
import org.apache.streampark.flink.kubernetes.PodTemplateTool$;
import org.apache.streampark.flink.packer.pipeline.DockerImageBuildResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KubernetesNativeClientTrait$class {
    public static void setConfig(KubernetesNativeClientTrait $this, SubmitRequest submitRequest, Configuration flinkConfig) {
        $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig).safeSet(KubernetesConfigOptions.CLUSTER_ID, submitRequest.clusterId())).safeSet(KubernetesConfigOptions.NAMESPACE, submitRequest.kubernetesNamespace())).safeSet(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, KubernetesNativeClientTrait$class.covertToServiceExposedType($this, submitRequest.flinkRestExposedType()));
        if (submitRequest.buildResult() != null) {
            ExecutionMode executionMode = submitRequest.executionMode();
            ExecutionMode executionMode2 = ExecutionMode.KUBERNETES_NATIVE_APPLICATION;
            if (!(executionMode != null ? !executionMode.equals(executionMode2) : executionMode2 != null)) {
                DockerImageBuildResponse buildResult = (DockerImageBuildResponse)submitRequest.buildResult();
                buildResult.podTemplatePaths().foreach((Function1)new Serializable($this, flinkConfig){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KubernetesNativeClientTrait $outer;
                    private final Configuration flinkConfig$1;

                    public final Object apply(Tuple2<String, String> p) {
                        return PodTemplateTool$.MODULE$.KUBERNETES_POD_TEMPLATE().key().equals(p._1()) ? this.$outer.EnhanceFlinkConfiguration(this.flinkConfig$1).safeSet(KubernetesConfigOptions.KUBERNETES_POD_TEMPLATE, p._2()) : (PodTemplateTool$.MODULE$.KUBERNETES_JM_POD_TEMPLATE().key().equals(p._1()) ? this.$outer.EnhanceFlinkConfiguration(this.flinkConfig$1).safeSet(KubernetesConfigOptions.JOB_MANAGER_POD_TEMPLATE, p._2()) : (PodTemplateTool$.MODULE$.KUBERNETES_TM_POD_TEMPLATE().key().equals(p._1()) ? this.$outer.EnhanceFlinkConfiguration(this.flinkConfig$1).safeSet(KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE, p._2()) : BoxedUnit.UNIT));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.flinkConfig$1 = flinkConfig$1;
                    }
                });
            }
        }
        Object object = flinkConfig.contains(DeploymentOptionsInternal.CONF_DIR) ? BoxedUnit.UNIT : $this.EnhanceFlinkConfiguration(flinkConfig).safeSet(DeploymentOptionsInternal.CONF_DIR, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{submitRequest.flinkVersion().flinkHome()})));
        Object object2 = ((String)flinkConfig.get(KubernetesConfigOptions.NAMESPACE)).isEmpty() ? BoxesRunTime.boxToBoolean((boolean)flinkConfig.removeConfig(KubernetesConfigOptions.NAMESPACE)) : BoxedUnit.UNIT;
        KubernetesNativeClientTrait$class.addPodLabels($this, flinkConfig, KubernetesConfigOptions.JOB_MANAGER_LABELS, submitRequest);
        KubernetesNativeClientTrait$class.addPodLabels($this, flinkConfig, KubernetesConfigOptions.TASK_MANAGER_LABELS, submitRequest);
        $this.logInfo((Function0)new Serializable($this, flinkConfig){
            public static final long serialVersionUID = 0L;
            private final Configuration flinkConfig$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |------------------------------------------------------------------\n               |Effective submit configuration: ", "\n               |------------------------------------------------------------------\n               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkConfig$1})))).stripMargin();
            }
            {
                this.flinkConfig$1 = flinkConfig$1;
            }
        });
    }

    public static CancelResponse doCancel(KubernetesNativeClientTrait $this, CancelRequest cancelRequest, Configuration flinkConfig) throws Exception {
        return (CancelResponse)$this.executeClientAction(cancelRequest, flinkConfig, new Serializable($this, cancelRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesNativeClientTrait $outer;
            private final CancelRequest cancelRequest$1;

            public final CancelResponse apply(JobID jobId, ClusterClient<?> client) {
                String resp = this.$outer.org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$cancelJob(this.cancelRequest$1, jobId, client);
                return new CancelResponse(resp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cancelRequest$1 = cancelRequest$1;
            }
        });
    }

    public static Object executeClientAction(KubernetesNativeClientTrait $this, SavepointRequestTrait request, Configuration flinkConfig, Function2 actFunc) {
        String hints = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-client] execute ", " for flink job failed,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getClass().getSimpleName()}));
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)request.clusterId()), (Function0)new Serializable($this, hints, flinkConfig){
            public static final long serialVersionUID = 0L;
            private final String hints$1;
            private final Configuration flinkConfig$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", clusterId is null, mode=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hints$1, this.flinkConfig$2.get(DeploymentOptions.TARGET)}));
            }
            {
                this.hints$1 = hints$1;
                this.flinkConfig$2 = flinkConfig$2;
            }
        });
        $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig).safeSet(KubernetesConfigOptions.CLUSTER_ID, request.clusterId())).safeSet(KubernetesConfigOptions.NAMESPACE, request.kubernetesNamespace());
        KubernetesClusterDescriptor clusterDescriptor = null;
        ClusterClient client = null;
        try {
            clusterDescriptor = $this.getK8sClusterDescriptor(flinkConfig);
            client = clusterDescriptor.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
            return actFunc.apply((Object)JobID.fromHexString((String)request.jobId()), (Object)client);
        }
        catch (Exception exception) {
            $this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " mode=", ", request=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hints, flinkConfig.get(DeploymentOptions.TARGET), request})));
            throw exception;
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (clusterDescriptor != null) {
                clusterDescriptor.close();
            }
        }
    }

    public static SavepointResponse doTriggerSavepoint(KubernetesNativeClientTrait $this, TriggerSavepointRequest request, Configuration flinkConfig) throws Exception {
        return (SavepointResponse)$this.executeClientAction(request, flinkConfig, new Serializable($this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesNativeClientTrait $outer;
            private final TriggerSavepointRequest request$1;

            public final SavepointResponse apply(JobID jobId, ClusterClient<?> clusterClient) {
                String actionResult = this.$outer.org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$triggerSavepoint(this.request$1, jobId, clusterClient);
                return new SavepointResponse(actionResult);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        });
    }

    public static Tuple2 getK8sClusterDescriptorAndSpecification(KubernetesNativeClientTrait $this, Configuration flinkConfig) {
        KubernetesClusterClientFactory clientFactory = new KubernetesClusterClientFactory();
        KubernetesClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(flinkConfig);
        ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(flinkConfig);
        return new Tuple2((Object)clusterDescriptor, (Object)clusterSpecification);
    }

    public static KubernetesClusterDescriptor getK8sClusterDescriptor(KubernetesNativeClientTrait $this, Configuration flinkConfig) {
        KubernetesClusterClientFactory clientFactory = new KubernetesClusterClientFactory();
        return clientFactory.createClusterDescriptor(flinkConfig);
    }

    public static String flinkConfIdentifierInfo(KubernetesNativeClientTrait $this, @Nonnull Configuration conf) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executionMode=", ", clusterId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(DeploymentOptions.TARGET), conf.get(KubernetesConfigOptions.CLUSTER_ID)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"namespace=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.get(KubernetesConfigOptions.NAMESPACE)}))).toString();
    }

    private static KubernetesConfigOptions.ServiceExposedType covertToServiceExposedType(KubernetesNativeClientTrait $this, FlinkK8sRestExposedType exposedType) {
        FlinkK8sRestExposedType flinkK8sRestExposedType = exposedType;
        KubernetesConfigOptions.ServiceExposedType serviceExposedType = FlinkK8sRestExposedType.CLUSTER_IP.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.ClusterIP : (FlinkK8sRestExposedType.LOAD_BALANCER.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.LoadBalancer : (FlinkK8sRestExposedType.NODE_PORT.equals(flinkK8sRestExposedType) ? KubernetesConfigOptions.ServiceExposedType.NodePort : KubernetesConfigOptions.ServiceExposedType.LoadBalancer));
        return serviceExposedType;
    }

    public static String getDefaultKubernetesConf(KubernetesNativeClientTrait $this, String k8sConf) {
        if (k8sConf == null) {
            return null;
        }
        String homePath = System.getProperty("user.home");
        return k8sConf.replace("~", homePath);
    }

    private static void addPodLabels(KubernetesNativeClientTrait $this, Configuration flinkConfig, ConfigOption opt, SubmitRequest submitRequest) {
        Map labels = flinkConfig.getOptional(opt).orElse(new HashMap());
        labels.put("jobId", submitRequest.jobId());
        $this.EnhanceFlinkConfiguration(flinkConfig).safeSet(opt, labels);
    }

    public static void $init$(KubernetesNativeClientTrait $this) {
    }
}

