/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.github.dockerjava.core.util.FilePathUtil;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

public class BuildImageCmdImpl
extends AbstrAsyncDockerCmd<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd {
    private InputStream tarInputStream;
    @Deprecated
    private String tag;
    private Set<String> tags;
    private Set<String> cacheFrom;
    private Boolean noCache;
    private Boolean remove = true;
    private Boolean quiet;
    private Boolean pull;
    private AuthConfigurations buildAuthConfigs;
    private File dockerFile;
    private String dockerFilePath;
    private File baseDirectory;
    private String cpusetcpus;
    private Long memory;
    private String cpushares;
    private Boolean forcerm;
    private Long memswap;
    private Long shmsize;
    private URI remote;
    private Map<String, String> buildArgs;
    private Map<String, String> labels;
    private String networkMode;
    private String platform;
    private String target;
    private Set<String> extraHosts;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec) {
        super(exec);
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, File dockerFileOrFolder) {
        super(exec);
        Preconditions.checkNotNull((Object)dockerFileOrFolder, (Object)"dockerFolder is null");
        if (dockerFileOrFolder.isDirectory()) {
            this.withBaseDirectory(dockerFileOrFolder);
            this.withDockerfile(new File(dockerFileOrFolder, "Dockerfile"));
        } else {
            this.withDockerfile(dockerFileOrFolder);
        }
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, InputStream tarInputStream) {
        super(exec);
        Preconditions.checkNotNull((Object)tarInputStream, (Object)"tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Deprecated
    public String getTag() {
        return this.tag;
    }

    @CheckForNull
    public Set<String> getTags() {
        return this.tags;
    }

    @CheckForNull
    public Set<String> getCacheFrom() {
        return this.cacheFrom;
    }

    public URI getRemote() {
        return this.remote;
    }

    public Boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    public Boolean hasRemoveEnabled() {
        return this.remove;
    }

    public Boolean isForcerm() {
        return this.forcerm;
    }

    public Boolean isQuiet() {
        return this.quiet;
    }

    public Boolean hasPullEnabled() {
        return this.pull;
    }

    public String getPathToDockerfile() {
        if (this.dockerFilePath != null) {
            return this.dockerFilePath;
        }
        if (this.baseDirectory != null && this.dockerFile != null) {
            return FilePathUtil.relativize(this.baseDirectory, this.dockerFile);
        }
        return null;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemswap() {
        return this.memswap;
    }

    public String getCpushares() {
        return this.cpushares;
    }

    public String getCpusetcpus() {
        return this.cpusetcpus;
    }

    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getTarget() {
        return this.target;
    }

    public AuthConfigurations getBuildAuthConfigs() {
        return this.buildAuthConfigs;
    }

    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    public Long getShmsize() {
        return this.shmsize;
    }

    public Set<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Deprecated
    public BuildImageCmdImpl withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Tag is null");
        this.tag = tag;
        return this;
    }

    public BuildImageCmd withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public BuildImageCmd withCacheFrom(Set<String> cacheFrom) {
        this.cacheFrom = cacheFrom;
        return this;
    }

    public BuildImageCmd withRemote(URI remote) {
        this.remote = remote;
        return this;
    }

    public BuildImageCmdImpl withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public BuildImageCmdImpl withRemove(Boolean rm) {
        this.remove = rm;
        return this;
    }

    public BuildImageCmd withForcerm(Boolean forcerm) {
        this.forcerm = forcerm;
        return this;
    }

    public BuildImageCmdImpl withQuiet(Boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public BuildImageCmdImpl withPull(Boolean pull) {
        this.pull = pull;
        return this;
    }

    public BuildImageCmd withMemory(Long memory) {
        this.memory = memory;
        return this;
    }

    public BuildImageCmd withMemswap(Long memswap) {
        this.memswap = memswap;
        return this;
    }

    public BuildImageCmd withCpushares(String cpushares) {
        this.cpushares = cpushares;
        return this;
    }

    public BuildImageCmd withCpusetcpus(String cpusetcpus) {
        this.cpusetcpus = cpusetcpus;
        return this;
    }

    public BuildImageCmd withBuildArg(String key, String value) {
        if (this.buildArgs == null) {
            this.buildArgs = new HashMap<String, String>();
        }
        this.buildArgs.put(key, value);
        return this;
    }

    public BuildImageCmd withBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    public BuildImageCmdImpl withDockerfile(File dockerfile) {
        Preconditions.checkNotNull((Object)dockerfile);
        if (!dockerfile.exists()) {
            throw new IllegalArgumentException("Dockerfile does not exist");
        }
        if (!dockerfile.isFile()) {
            throw new IllegalArgumentException("Dockerfile is not a file");
        }
        if (this.baseDirectory == null) {
            this.withBaseDirectory(dockerfile.getParentFile());
        }
        this.dockerFile = dockerfile;
        try {
            this.withTarInputStream(new Dockerfile(dockerfile, this.baseDirectory).parse().buildDockerFolderTar());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public BuildImageCmd withDockerfilePath(String dockerfilePath) {
        Preconditions.checkNotNull((Object)dockerfilePath, (Object)"dockerfilePath is null");
        this.dockerFilePath = dockerfilePath;
        return this;
    }

    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull((Object)tarInputStream, (Object)"tarInputStream is null");
        this.tarInputStream = tarInputStream;
        return this;
    }

    public BuildImageCmd withBuildAuthConfigs(AuthConfigurations authConfigs) {
        Preconditions.checkNotNull((Object)authConfigs, (Object)"authConfig is null");
        this.buildAuthConfigs = authConfigs;
        return this;
    }

    public BuildImageCmd withShmsize(Long shmsize) {
        this.shmsize = shmsize;
        return this;
    }

    public BuildImageCmd withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public BuildImageCmd withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public BuildImageCmd withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public BuildImageCmd withTarget(String target) {
        this.target = target;
        return this;
    }

    public BuildImageCmd withExtraHosts(Set<String> extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.tarInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

