/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.join;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.join.JoinFunctionAssigner;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.java.typeutils.TypeExtractor;

@Public
public class JoinOperatorSetsBase<I1, I2> {
    protected final DataSet<I1> input1;
    protected final DataSet<I2> input2;
    protected final JoinOperatorBase.JoinHint joinHint;
    protected final JoinType joinType;

    public JoinOperatorSetsBase(DataSet<I1> input1, DataSet<I2> input2) {
        this(input1, input2, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    public JoinOperatorSetsBase(DataSet<I1> input1, DataSet<I2> input2, JoinOperatorBase.JoinHint hint) {
        this(input1, input2, hint, JoinType.INNER);
    }

    public JoinOperatorSetsBase(DataSet<I1> input1, DataSet<I2> input2, JoinOperatorBase.JoinHint hint, JoinType type) {
        if (input1 == null || input2 == null) {
            throw new NullPointerException();
        }
        this.input1 = input1;
        this.input2 = input2;
        this.joinHint = hint;
        this.joinType = type;
    }

    public JoinOperatorSetsPredicateBase where(int ... fields) {
        return new JoinOperatorSetsPredicateBase(new Keys.ExpressionKeys(fields, this.input1.getType()));
    }

    public JoinOperatorSetsPredicateBase where(String ... fields) {
        return new JoinOperatorSetsPredicateBase(new Keys.ExpressionKeys(fields, this.input1.getType()));
    }

    public <K> JoinOperatorSetsPredicateBase where(KeySelector<I1, K> keySelector) {
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, this.input1.getType());
        return new JoinOperatorSetsPredicateBase(new Keys.SelectorFunctionKeys(keySelector, this.input1.getType(), keyType));
    }

    public class JoinOperatorSetsPredicateBase {
        protected final Keys<I1> keys1;

        protected JoinOperatorSetsPredicateBase(Keys<I1> keys1) {
            if (keys1 == null) {
                throw new NullPointerException();
            }
            if (keys1.isEmpty()) {
                throw new InvalidProgramException("The join keys must not be empty.");
            }
            this.keys1 = keys1;
        }

        public JoinFunctionAssigner<I1, I2> equalTo(int ... fields) {
            return this.createJoinFunctionAssigner((Keys)new Keys.ExpressionKeys(fields, JoinOperatorSetsBase.this.input2.getType()));
        }

        public JoinFunctionAssigner<I1, I2> equalTo(String ... fields) {
            return this.createJoinFunctionAssigner((Keys)new Keys.ExpressionKeys(fields, JoinOperatorSetsBase.this.input2.getType()));
        }

        public <K> JoinFunctionAssigner<I1, I2> equalTo(KeySelector<I2, K> keySelector) {
            TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, JoinOperatorSetsBase.this.input2.getType());
            return this.createJoinFunctionAssigner((Keys)new Keys.SelectorFunctionKeys(keySelector, JoinOperatorSetsBase.this.input2.getType(), keyType));
        }

        protected JoinFunctionAssigner<I1, I2> createJoinFunctionAssigner(Keys<I2> keys2) {
            JoinOperator.DefaultJoin join = this.createDefaultJoin(keys2);
            return new DefaultJoinFunctionAssigner(join);
        }

        protected JoinOperator.DefaultJoin<I1, I2> createDefaultJoin(Keys<I2> keys2) {
            if (keys2 == null) {
                throw new NullPointerException("The join keys may not be null.");
            }
            if (keys2.isEmpty()) {
                throw new InvalidProgramException("The join keys may not be empty.");
            }
            try {
                this.keys1.areCompatible(keys2);
            }
            catch (Keys.IncompatibleKeysException e) {
                throw new InvalidProgramException("The pair of join keys are not compatible with each other.", (Throwable)e);
            }
            return new JoinOperator.DefaultJoin(JoinOperatorSetsBase.this.input1, JoinOperatorSetsBase.this.input2, this.keys1, keys2, JoinOperatorSetsBase.this.joinHint, Utils.getCallLocationName(4), JoinOperatorSetsBase.this.joinType);
        }

        private class DefaultJoinFunctionAssigner
        implements JoinFunctionAssigner<I1, I2> {
            private final JoinOperator.DefaultJoin<I1, I2> defaultJoin;

            public DefaultJoinFunctionAssigner(JoinOperator.DefaultJoin<I1, I2> defaultJoin) {
                this.defaultJoin = defaultJoin;
            }

            @Override
            public <R> JoinOperator.EquiJoin<I1, I2, R> with(JoinFunction<I1, I2, R> joinFunction) {
                return this.defaultJoin.with(joinFunction);
            }

            @Override
            public <R> JoinOperator.EquiJoin<I1, I2, R> with(FlatJoinFunction<I1, I2, R> joinFunction) {
                return this.defaultJoin.with(joinFunction);
            }
        }
    }
}

