/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.operators.sort.CircularElement;
import org.apache.flink.runtime.operators.sort.CombineValueIterator;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.sort.SpillingThread;
import org.apache.flink.runtime.operators.sort.WriterCollector;
import org.apache.flink.runtime.util.NonReusingKeyGroupedIterator;
import org.apache.flink.runtime.util.ReusingKeyGroupedIterator;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CombiningSpillingBehaviour<R>
implements SpillingThread.SpillingBehaviour<R> {
    private static final Logger LOG = LoggerFactory.getLogger(CombiningSpillingBehaviour.class);
    private final GroupCombineFunction<R, R> combineFunction;
    private final TypeSerializer<R> serializer;
    private final TypeComparator<R> comparator;
    private final boolean objectReuseEnabled;
    private final Configuration udfConfig;

    CombiningSpillingBehaviour(GroupCombineFunction<R, R> combineFunction, TypeSerializer<R> serializer, TypeComparator<R> comparator, boolean objectReuseEnabled, Configuration udfConfig) {
        this.combineFunction = combineFunction;
        this.serializer = serializer;
        this.objectReuseEnabled = objectReuseEnabled;
        this.udfConfig = udfConfig;
        this.comparator = comparator;
    }

    @Override
    public void open() {
        try {
            FunctionUtils.openFunction(this.combineFunction, (Configuration)this.udfConfig);
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException("The user-defined combiner failed in its 'open()' method.", t);
        }
    }

    @Override
    public void close() {
        try {
            FunctionUtils.closeFunction(this.combineFunction);
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException("The user-defined combiner failed in its 'close()' method.", t);
        }
    }

    @Override
    public void spillBuffer(CircularElement<R> element, ChannelWriterOutputView output, LargeRecordHandler<R> largeRecordHandler) throws IOException {
        int i;
        LOG.debug("Combining buffer {}.", (Object)element.getId());
        InMemorySorter<R> buffer = element.getBuffer();
        CombineValueIterator<Object> iter = new CombineValueIterator<Object>(buffer, this.serializer.createInstance(), this.objectReuseEnabled);
        WriterCollector<R> collector = new WriterCollector<R>(output, this.serializer);
        int stop = buffer.size() - 1;
        try {
            for (i = 0; i < stop; ++i) {
                int seqStart = i;
                while (i < stop && 0 == buffer.compare(i, i + 1)) {
                    ++i;
                }
                if (i == seqStart) {
                    buffer.writeToOutput(output, seqStart, 1);
                    continue;
                }
                iter.set(seqStart, i);
                this.combineFunction.combine(iter, collector);
            }
        }
        catch (Exception ex) {
            throw new IOException("An error occurred in the combiner user code.", ex);
        }
        if (i == stop) {
            buffer.writeToOutput(output, stop, 1);
        }
        LOG.debug("Combined and spilled buffer {}.", (Object)element.getId());
    }

    @Override
    public void mergeRecords(MergeIterator<R> mergeIterator, ChannelWriterOutputView output) throws IOException {
        WriterCollector<R> collector = new WriterCollector<R>(output, this.serializer);
        try {
            if (this.objectReuseEnabled) {
                ReusingKeyGroupedIterator<R> groupedIter = new ReusingKeyGroupedIterator<R>(mergeIterator, this.serializer, this.comparator);
                while (groupedIter.nextKey()) {
                    this.combineFunction.combine((Iterable)groupedIter.getValues(), collector);
                }
            } else {
                NonReusingKeyGroupedIterator<R> groupedIter = new NonReusingKeyGroupedIterator<R>(mergeIterator, this.comparator);
                while (groupedIter.nextKey()) {
                    this.combineFunction.combine((Iterable)groupedIter.getValues(), collector);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("An error occurred in the combiner user code.");
        }
    }
}

