/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.api.reader.MutableReader;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.runtime.plugable.ReusingDeserializationDelegate;
import org.apache.flink.util.MutableObjectIterator;

public class ReaderIterator<T>
implements MutableObjectIterator<T> {
    private final MutableReader<DeserializationDelegate<T>> reader;
    private final ReusingDeserializationDelegate<T> reusingDelegate;
    private final NonReusingDeserializationDelegate<T> nonReusingDelegate;

    public ReaderIterator(MutableReader<DeserializationDelegate<T>> reader, TypeSerializer<T> serializer) {
        this.reader = reader;
        this.reusingDelegate = new ReusingDeserializationDelegate<T>(serializer);
        this.nonReusingDelegate = new NonReusingDeserializationDelegate<T>(serializer);
    }

    public T next(T target) throws IOException {
        this.reusingDelegate.setInstance(target);
        try {
            if (this.reader.next(this.reusingDelegate)) {
                return this.reusingDelegate.getInstance();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException("Reader interrupted.", e);
        }
    }

    public T next() throws IOException {
        try {
            if (this.reader.next(this.nonReusingDelegate)) {
                return this.nonReusingDelegate.getInstance();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException("Reader interrupted.", e);
        }
    }
}

