/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.stats.Statistics;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoStats;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoTracker;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoRequestCoordinator;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.Preconditions;

public class JobVertexThreadInfoTrackerBuilder<T extends Statistics> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final Function<JobVertexThreadInfoStats, T> createStatsFn;
    private final ScheduledExecutorService executor;
    private final Time restTimeout;
    private ThreadInfoRequestCoordinator coordinator;
    private Duration cleanUpInterval;
    private int numSamples;
    private Duration statsRefreshInterval;
    private Duration delayBetweenSamples;
    private int maxThreadInfoDepth;
    private Cache<JobVertexThreadInfoTracker.Key, T> vertexStatsCache;

    JobVertexThreadInfoTrackerBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Function<JobVertexThreadInfoStats, T> createStatsFn, ScheduledExecutorService executor, Time restTimeout) {
        this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
        this.createStatsFn = createStatsFn;
        this.executor = executor;
        this.restTimeout = restTimeout;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setCoordinator(ThreadInfoRequestCoordinator coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setCleanUpInterval(Duration cleanUpInterval) {
        this.cleanUpInterval = cleanUpInterval;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setNumSamples(int numSamples) {
        this.numSamples = numSamples;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setStatsRefreshInterval(Duration statsRefreshInterval) {
        this.statsRefreshInterval = statsRefreshInterval;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setDelayBetweenSamples(Duration delayBetweenSamples) {
        this.delayBetweenSamples = delayBetweenSamples;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setMaxThreadInfoDepth(int maxThreadInfoDepth) {
        this.maxThreadInfoDepth = maxThreadInfoDepth;
        return this;
    }

    @VisibleForTesting
    JobVertexThreadInfoTrackerBuilder<T> setVertexStatsCache(Cache<JobVertexThreadInfoTracker.Key, T> vertexStatsCache) {
        this.vertexStatsCache = vertexStatsCache;
        return this;
    }

    public JobVertexThreadInfoTracker<T> build() {
        if (this.vertexStatsCache == null) {
            this.vertexStatsCache = this.defaultCache();
        }
        return new JobVertexThreadInfoTracker<T>(this.coordinator, this.resourceManagerGatewayRetriever, this.createStatsFn, this.executor, this.cleanUpInterval, this.numSamples, this.statsRefreshInterval, this.delayBetweenSamples, this.maxThreadInfoDepth, this.restTimeout, this.vertexStatsCache);
    }

    private Cache<JobVertexThreadInfoTracker.Key, T> defaultCache() {
        Preconditions.checkArgument((this.cleanUpInterval.toMillis() > 0L ? 1 : 0) != 0, (Object)"Clean up interval must be greater than 0");
        return CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(this.cleanUpInterval.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static <T extends Statistics> JobVertexThreadInfoTrackerBuilder<T> newBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Function<JobVertexThreadInfoStats, T> createStatsFn, ScheduledExecutorService executor, Time restTimeout) {
        return new JobVertexThreadInfoTrackerBuilder<T>(resourceManagerGatewayRetriever, createStatsFn, executor, restTimeout);
    }
}

