/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.InternalProcessApplyAllWindowContext;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class ReduceApplyProcessAllWindowFunction<W extends Window, T, R>
extends ProcessAllWindowFunction<T, R, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;
    private final ProcessAllWindowFunction<T, R, W> windowFunction;
    private transient InternalProcessApplyAllWindowContext<T, R, W> ctx;

    public ReduceApplyProcessAllWindowFunction(ReduceFunction<T> reduceFunction, ProcessAllWindowFunction<T, R, W> windowFunction) {
        this.windowFunction = windowFunction;
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void process(ProcessAllWindowFunction.Context context, Iterable<T> input, Collector<R> out) throws Exception {
        Object curr = null;
        for (T val : input) {
            if (curr == null) {
                curr = val;
                continue;
            }
            curr = this.reduceFunction.reduce(curr, val);
        }
        this.ctx.window = context.window();
        this.ctx.context = context;
        this.windowFunction.process(this.ctx, Collections.singletonList(curr), out);
    }

    @Override
    public void clear(ProcessAllWindowFunction.Context context) throws Exception {
        this.ctx.window = context.window();
        this.ctx.context = context;
        this.windowFunction.clear(this.ctx);
    }

    public void open(Configuration configuration) throws Exception {
        FunctionUtils.openFunction(this.windowFunction, (Configuration)configuration);
        this.ctx = new InternalProcessApplyAllWindowContext<T, R, W>(this.windowFunction);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.windowFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        FunctionUtils.setFunctionRuntimeContext(this.windowFunction, (RuntimeContext)t);
    }
}

