/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.tool;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.client.tool.JarRunRequest;
import org.apache.streampark.flink.client.tool.JarUploadResponse;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.jackson.Serialization$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FlinkSessionSubmitHelper$
implements Logger {
    public static FlinkSessionSubmitHelper$ MODULE$;
    private Timeout FLINK_CLIENT_TIMEOUT_SEC;
    private Timeout FLINK_REST_AWAIT_TIMEOUT_SEC;
    private transient DefaultFormats$ formats;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FlinkSessionSubmitHelper$();
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private Timeout FLINK_CLIENT_TIMEOUT_SEC$lzycompute() {
        FlinkSessionSubmitHelper$ flinkSessionSubmitHelper$ = this;
        synchronized (flinkSessionSubmitHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.FLINK_CLIENT_TIMEOUT_SEC = Timeout.ofMilliseconds((long)Duration.ofSeconds(60L).toMillis()).toTimeout();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    private Timeout FLINK_CLIENT_TIMEOUT_SEC() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.FLINK_CLIENT_TIMEOUT_SEC$lzycompute() : this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    private Timeout FLINK_REST_AWAIT_TIMEOUT_SEC$lzycompute() {
        FlinkSessionSubmitHelper$ flinkSessionSubmitHelper$ = this;
        synchronized (flinkSessionSubmitHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.FLINK_REST_AWAIT_TIMEOUT_SEC = Timeout.ofMilliseconds((long)30000L);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    private Timeout FLINK_REST_AWAIT_TIMEOUT_SEC() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.FLINK_REST_AWAIT_TIMEOUT_SEC$lzycompute() : this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    private DefaultFormats$ formats$lzycompute() {
        FlinkSessionSubmitHelper$ flinkSessionSubmitHelper$ = this;
        synchronized (flinkSessionSubmitHelper$) {
            if (!this.bitmap$trans$0) {
                this.formats = DefaultFormats$.MODULE$;
                this.bitmap$trans$0 = true;
            }
        }
        return this.formats;
    }

    public DefaultFormats$ formats() {
        return !this.bitmap$trans$0 ? this.formats$lzycompute() : this.formats;
    }

    public String submitViaRestApi(String jmRestUrl, File flinkJobJar, Configuration flinkConfig) throws Exception {
        String string;
        JarUploadResponse jarUploadResponse;
        String uploadResult = Request.post((String)new StringBuilder(12).append(jmRestUrl).append("/jars/upload").toString()).connectTimeout(this.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(this.FLINK_CLIENT_TIMEOUT_SEC()).body(MultipartEntityBuilder.create().addBinaryBody("jarfile", flinkJobJar, ContentType.create((String)"application/java-archive"), flinkJobJar.getName()).build()).execute().returnContent().asString(StandardCharsets.UTF_8);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse(uploadResult, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JValue ok = (JValue)success.value();
            jarUploadResponse = new JarUploadResponse((String)ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(ok), "filename")), this.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms()), (String)ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(ok), "status")), this.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms()));
        } else if (try_ instanceof Failure) {
            jarUploadResponse = null;
        } else {
            throw new MatchError((Object)try_);
        }
        JarUploadResponse jarUploadResponse2 = jarUploadResponse;
        if (!jarUploadResponse2.isSuccessful()) {
            throw new Exception(new StringBuilder(86).append("[flink-submit] upload flink jar to flink session cluster failed, jmRestUrl=").append(jmRestUrl).append(", response=").append(jarUploadResponse2).toString());
        }
        String resp = Request.post((String)new StringBuilder(10).append(jmRestUrl).append("/jars/").append(jarUploadResponse2.jarId()).append("/run").toString()).connectTimeout(this.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(this.FLINK_CLIENT_TIMEOUT_SEC()).body((HttpEntity)new StringEntity(Serialization$.MODULE$.write(new JarRunRequest(flinkConfig), this.formats()))).execute().returnContent().asString(StandardCharsets.UTF_8);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse(resp, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            JValue ok = (JValue)success.value();
            string = (String)ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(ok), "jobid")), this.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms());
        } else if (try_2 instanceof Failure) {
            string = null;
        } else {
            throw new MatchError((Object)try_2);
        }
        return string;
    }

    public void doReplaceJobName(Configuration flinkConfig, String replacement) {
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(flinkConfig.keySet()).foreach((Function1 & Serializable & scala.Serializable)k -> {
            FlinkSessionSubmitHelper$.$anonfun$doReplaceJobName$1(flinkConfig, replacement, k);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$doReplaceJobName$1(Configuration flinkConfig$1, String replacement$1, String k) {
        block0: {
            String v = flinkConfig$1.getString(k, null);
            if (v == null) break block0;
            String result = v.replaceAll("\\$\\{job(Name|name)}|\\$job(Name|name)", replacement$1);
            flinkConfig$1.setString(k, result);
        }
    }

    private FlinkSessionSubmitHelper$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
    }
}

