/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;

@Internal
public class LocalDataOutputStream
extends FSDataOutputStream {
    private final FileOutputStream fos;

    public LocalDataOutputStream(File file) throws IOException {
        this.fos = new FileOutputStream(file);
    }

    @Override
    public void write(int b) throws IOException {
        this.fos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fos.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.fos.close();
    }

    @Override
    public void flush() throws IOException {
        this.fos.flush();
    }

    @Override
    public void sync() throws IOException {
        this.fos.getFD().sync();
    }

    @Override
    public long getPos() throws IOException {
        return this.fos.getChannel().position();
    }
}

