/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.tiles.annotation.TilesAddAttribute;
import org.apache.struts2.tiles.annotation.TilesAddListAttribute;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.apache.struts2.tiles.annotation.TilesPutListAttribute;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.Expression;
import org.apache.tiles.api.ListAttribute;

public class StrutsTilesAnnotationProcessor {
    public TilesDefinition findAnnotation(Object action, String tileName) {
        Class<?> clazz = action.getClass();
        TilesDefinition tilesDefinition = clazz.getAnnotation(TilesDefinition.class);
        TilesDefinitions tilesDefinitions = clazz.getAnnotation(TilesDefinitions.class);
        if (tilesDefinition == null && tilesDefinitions != null) {
            if (!StringUtils.isEmpty((CharSequence)tileName)) {
                for (TilesDefinition i : tilesDefinitions.value()) {
                    if (!i.name().equals(tileName)) continue;
                    tilesDefinition = i;
                    break;
                }
            } else if (tilesDefinitions.value().length > 0) {
                tilesDefinition = tilesDefinitions.value()[0];
            }
        }
        return tilesDefinition;
    }

    public Definition buildTilesDefinition(String tileName, TilesDefinition tilesDefinition) {
        Attribute attribute;
        String preparer;
        Definition definition = new Definition();
        definition.setName(tileName);
        String extend = this.getValueOrNull(tilesDefinition.extend());
        if (extend != null) {
            definition.setExtends(extend);
        }
        if ((preparer = this.getValueOrNull(tilesDefinition.preparer())) != null) {
            definition.setPreparer(preparer);
        }
        definition.setTemplateAttribute(this.buildTemplateAttribute(tilesDefinition));
        for (TilesPutAttribute tilesPutAttribute : tilesDefinition.putAttributes()) {
            attribute = this.buildPutAttribute(tilesPutAttribute);
            definition.putAttribute(tilesPutAttribute.name(), attribute, tilesPutAttribute.cascade());
        }
        for (Annotation annotation : tilesDefinition.putListAttributes()) {
            attribute = this.buildPutListAttribute((TilesPutListAttribute)annotation);
            definition.putAttribute(annotation.name(), attribute, annotation.cascade());
        }
        return definition;
    }

    protected Attribute buildTemplateAttribute(TilesDefinition tilesDef) {
        Attribute attribute = Attribute.createTemplateAttribute(this.getValueOrNull(tilesDef.template()));
        String templateExpression = this.getValueOrNull(tilesDef.templateExpression());
        Expression expression = Expression.createExpressionFromDescribedExpression(templateExpression);
        attribute.setExpressionObject(expression);
        attribute.setRole(this.getValueOrNull(tilesDef.role()));
        String templateType = this.getValueOrNull(tilesDef.templateType());
        if (templateType != null) {
            attribute.setRenderer(templateType);
        } else if (this.getValueOrNull(tilesDef.extend()) != null) {
            attribute.setRenderer(null);
        }
        return attribute;
    }

    protected Attribute buildPutAttribute(TilesPutAttribute putAttribute) {
        Attribute attribute = new Attribute();
        attribute.setValue(this.getValueOrNull(putAttribute.value()));
        String expression = this.getValueOrNull(putAttribute.expression());
        attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(expression));
        attribute.setRole(this.getValueOrNull(putAttribute.role()));
        attribute.setRenderer(this.getValueOrNull(putAttribute.type()));
        return attribute;
    }

    protected Attribute buildPutListAttribute(TilesPutListAttribute putListAttribute) {
        ListAttribute attribute = new ListAttribute();
        attribute.setRole(this.getValueOrNull(putListAttribute.role()));
        attribute.setInherit(putListAttribute.inherit());
        for (TilesAddAttribute tilesAddAttribute : putListAttribute.addAttributes()) {
            attribute.add(this.buildAddAttribute(tilesAddAttribute));
        }
        for (Annotation annotation : putListAttribute.addListAttributes()) {
            attribute.add(this.buildAddListAttribute((TilesAddListAttribute)annotation));
        }
        return attribute;
    }

    protected Attribute buildAddAttribute(TilesAddAttribute addAttribute) {
        Attribute attribute = new Attribute();
        attribute.setValue(this.getValueOrNull(addAttribute.value()));
        String expression = this.getValueOrNull(addAttribute.expression());
        attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression(expression));
        attribute.setRole(this.getValueOrNull(addAttribute.role()));
        attribute.setRenderer(this.getValueOrNull(addAttribute.type()));
        return attribute;
    }

    protected Attribute buildAddListAttribute(TilesAddListAttribute addListAttribute) {
        ListAttribute attribute = new ListAttribute();
        attribute.setRole(this.getValueOrNull(addListAttribute.role()));
        for (TilesAddAttribute addAttribute : addListAttribute.addAttributes()) {
            attribute.add(this.buildAddAttribute(addAttribute));
        }
        return attribute;
    }

    protected String getValueOrNull(String value) {
        return value != null && value.length() > 0 ? value : null;
    }
}

