/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tiles.api.Attribute;

public class ListAttribute
extends Attribute {
    private boolean inherit = false;

    public ListAttribute() {
        this.setValue((Object)new ArrayList());
    }

    public ListAttribute(ListAttribute toCopy) {
        super(toCopy);
        Object attributesToCopy = toCopy.getValue();
        if (attributesToCopy != null) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributesToCopy.size());
            Iterator iterator = attributesToCopy.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute != null) {
                    attributes.add(attribute.copy());
                    continue;
                }
                attributes.add(null);
            }
            this.setValue(attributes);
        }
        this.inherit = toCopy.inherit;
    }

    public void setValue(List<Attribute> attributes) {
        super.setValue(attributes);
    }

    @Override
    public List<Attribute> getValue() {
        return (List)super.getValue();
    }

    public void add(Attribute element) {
        this.getValue().add(element);
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public void inherit(ListAttribute parent) {
        ArrayList<Attribute> tempList = new ArrayList<Attribute>();
        tempList.addAll((Collection<Attribute>)parent.getValue());
        tempList.addAll((Collection<Attribute>)this.getValue());
        this.setValue(tempList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttribute)) {
            return false;
        }
        ListAttribute attribute = (ListAttribute)obj;
        return super.equals(attribute) && this.inherit == attribute.inherit;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.valueOf(this.inherit).hashCode();
    }

    @Override
    public ListAttribute copy() {
        return new ListAttribute(this);
    }
}

