/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.parser.NamespaceVisitor;
import com.google.gxp.compiler.parser.OutputLanguageNamespace;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import com.google.gxp.compiler.parser.ParsedElementVisitor;
import com.google.gxp.compiler.parser.UnknownElementError;
import java.util.List;
import java.util.Map;

public class JavaNamespace
implements OutputLanguageNamespace {
    public static final OutputLanguageNamespace INSTANCE = new JavaNamespace();
    private static final Map<String, ElementType> ELEMENTS = JavaNamespace.initElements();

    private JavaNamespace() {
    }

    @Override
    public String getUri() {
        return "http://google.com/2001/gxp/code/java";
    }

    @Override
    public ParsedElement createElement(AlertSink alertSink, SourcePosition sourcePosition, String displayName, String tagName, List<ParsedAttribute> attrs, List<ParsedElement> children) {
        ElementType type = ELEMENTS.get(tagName);
        if (type == null) {
            alertSink.add(new UnknownElementError(sourcePosition, this, displayName));
            return null;
        }
        return new JavaElement(sourcePosition, displayName, attrs, children, type);
    }

    private static Map<String, ElementType> initElements() {
        ImmutableMap.Builder<String, ElementType> builder = ImmutableMap.builder();
        for (ElementType type : ElementType.values()) {
            builder.put(type.name().toLowerCase(), type);
        }
        return builder.build();
    }

    @Override
    public <T> T acceptVisitor(NamespaceVisitor<T> visitor) {
        return visitor.visitJavaNamespace(this);
    }

    @Override
    public OutputLanguage getOutputLanguage() {
        return OutputLanguage.JAVA;
    }

    private static enum ElementType {
        ANNOTATE{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, JavaElement element) {
                return visitor.visitJavaAnnotateElement(element);
            }
        };


        abstract <T> T acceptVisitor(ParsedElementVisitor<T> var1, JavaElement var2);
    }

    public static class JavaElement
    extends ParsedElement {
        private final ElementType elementType;

        public JavaElement(SourcePosition sourcePostion, String displayName, List<ParsedAttribute> attrs, List<? extends ParsedElement> children, ElementType elementType) {
            super(sourcePostion, displayName, attrs, children);
            this.elementType = elementType;
        }

        @Override
        public <T> T acceptVisitor(ParsedElementVisitor<T> visitor) {
            return this.elementType.acceptVisitor(visitor, this);
        }

        @Override
        protected JavaElement withChildrenImpl(List<ParsedElement> children) {
            return new JavaElement(this.getSourcePosition(), this.getDisplayName(), this.getAttributes(), children, this.elementType);
        }
    }
}

