/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.css;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.css.CssClosure;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Color
implements CssClosure {
    private final short red;
    private final short green;
    private final short blue;
    public static final Color AQUA = new Color(0, 255, 255);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color FUCHSIA = new Color(255, 0, 255);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color GREEN = new Color(0, 128, 0);
    public static final Color GREY = new Color(128, 128, 128);
    public static final Color INDIGO = new Color(75, 0, 130);
    public static final Color LIME = new Color(0, 255, 0);
    public static final Color MAROON = new Color(128, 0, 0);
    public static final Color NAVY = new Color(0, 0, 128);
    public static final Color OLIVE = new Color(128, 128, 0);
    public static final Color ORANGE = new Color(255, 165, 0);
    public static final Color PURPLE = new Color(128, 0, 128);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color SILVER = new Color(192, 192, 192);
    public static final Color TEAL = new Color(0, 128, 128);
    public static final Color VIOLET = new Color(238, 130, 238);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color YELLOW = new Color(255, 255, 0);
    private static final Map<String, Color> KEYWORD_MAP = new ImmutableMap.Builder<String, Color>().put("aqua", AQUA).put("black", BLACK).put("blue", BLUE).put("fuchsia", FUCHSIA).put("gray", GRAY).put("green", GREEN).put("grey", GREY).put("indigo", INDIGO).put("lime", LIME).put("maroon", MAROON).put("navy", NAVY).put("olive", OLIVE).put("orange", ORANGE).put("purple", PURPLE).put("red", RED).put("silver", SILVER).put("teal", TEAL).put("violet", VIOLET).put("white", WHITE).put("yellow", YELLOW).build();
    private static final Pattern THREE_DIGIT_PATTERN = Pattern.compile("#([0-9a-f])([0-9a-f])([0-9a-f])", 2);
    private static final Pattern SIX_DIGIT_PATTERN = Pattern.compile("#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})", 2);

    public Color(int red, int green, int blue) {
        this.red = this.validateComponent(red);
        this.green = this.validateComponent(green);
        this.blue = this.validateComponent(blue);
    }

    public static Color from24BitRgb(int rgb) {
        return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public String toString() {
        GxpContext gxpContext = new GxpContext(Locale.US);
        return gxpContext.getString(this);
    }

    @Override
    public void write(Appendable out, GxpContext gxpContext) throws IOException {
        out.append("#");
        if (Color.isFourBit(this.red) && Color.isFourBit(this.green) && Color.isFourBit(this.blue)) {
            Color.appendNybble(out, this.red);
            Color.appendNybble(out, this.green);
            Color.appendNybble(out, this.blue);
        } else {
            Color.appendByte(out, this.red);
            Color.appendByte(out, this.green);
            Color.appendByte(out, this.blue);
        }
    }

    private short validateComponent(int x) {
        if (x < 0 || x > 255) {
            throw new IllegalArgumentException(x + " is not a valid component value." + " Must be in range [0,255].");
        }
        return (short)x;
    }

    private static void appendNybble(Appendable out, int x) throws IOException {
        out.append(Integer.toHexString(x & 0xF));
    }

    private static void appendByte(Appendable out, int x) throws IOException {
        if (x <= 15) {
            out.append("0");
        }
        out.append(Integer.toHexString(x));
    }

    private static boolean isFourBit(int x) {
        return x % 17 == 0;
    }

    public boolean equals(Object that) {
        return that instanceof Color && this.equals((Color)that);
    }

    public boolean equals(Color that) {
        return this.red == that.red && this.blue == that.blue && this.green == that.green;
    }

    public int hashCode() {
        return Objects.hashCode(this.red, this.blue, this.green);
    }

    public static Color valueOf(String s) {
        Matcher m = THREE_DIGIT_PATTERN.matcher(s);
        if (m.matches()) {
            return new Color(Integer.parseInt(m.group(1), 16) * 17, Integer.parseInt(m.group(2), 16) * 17, Integer.parseInt(m.group(3), 16) * 17);
        }
        m = SIX_DIGIT_PATTERN.matcher(s);
        if (m.matches()) {
            return new Color(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
        }
        Color color = KEYWORD_MAP.get(s);
        if (color != null) {
            return color;
        }
        throw new IllegalArgumentException("Can't parse \"" + s + "\" as a CSS color.");
    }
}

