/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.html;

import com.google.gxp.base.GxpContext;
import com.google.gxp.base.MarkupAppender;
import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.css.CssClosure;
import com.google.gxp.html.HtmlClosure;
import com.google.gxp.js.JavascriptClosure;
import com.google.gxp.text.PlaintextClosure;
import com.google.i18n.Localizable;
import java.io.IOException;

public class HtmlAppender
extends MarkupAppender<HtmlClosure> {
    public static final HtmlAppender INSTANCE = new HtmlAppender();

    private HtmlAppender() {
    }

    @Override
    protected CharEscaper getCharEscaper(GxpContext gxpContext) {
        return CharEscapers.htmlEscaper();
    }

    @Override
    public <A extends Appendable> A append(A out, GxpContext gxpContext, CssClosure closure) throws IOException {
        Preconditions.checkNotNull(closure);
        out.append("<style type=\"text/css\">\n");
        closure.write(out, gxpContext);
        out.append("\n</style>");
        return out;
    }

    @Override
    public <A extends Appendable> A append(A out, GxpContext gxpContext, JavascriptClosure closure) throws IOException {
        Preconditions.checkNotNull(closure);
        out.append("<script type=\"text/javascript\">\n");
        closure.write(out, gxpContext);
        out.append("\n</script>");
        return out;
    }

    @Override
    public <A extends Appendable> A append(A out, GxpContext gxpContext, PlaintextClosure closure) throws IOException {
        Preconditions.checkNotNull(closure);
        closure.write(this.getCharEscaper(gxpContext).escape(out), gxpContext);
        return out;
    }

    @Override
    public <A extends Appendable> A append(A out, GxpContext gxpContext, Object value) throws IOException {
        Preconditions.checkNotNull(value);
        if (value instanceof Localizable) {
            this.append(out, gxpContext, (Localizable)value);
        } else if (value instanceof PlaintextClosure) {
            this.append(out, gxpContext, (PlaintextClosure)value);
        } else if (value instanceof CssClosure) {
            this.append(out, gxpContext, (CssClosure)value);
        } else if (value instanceof JavascriptClosure) {
            this.append(out, gxpContext, (JavascriptClosure)value);
        } else if (value instanceof HtmlClosure) {
            ((MarkupAppender)this).append(out, gxpContext, (HtmlClosure)value);
        } else {
            this.append(out, gxpContext, value.toString());
        }
        return out;
    }
}

