/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestConstructor;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.PropertyProvider;

public abstract class TestConstructorUtils {
    private TestConstructorUtils() {
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(executable, testClass, null);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(constructor, testClass, null);
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor((Constructor)executable, testClass, fallbackPropertyProvider);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        if (AnnotatedElementUtils.hasAnnotation(constructor, Autowired.class)) {
            return true;
        }
        TestConstructor.AutowireMode autowireMode = null;
        TestConstructor testConstructor = TestContextAnnotationUtils.findMergedAnnotation(testClass, TestConstructor.class);
        if (testConstructor != null) {
            autowireMode = testConstructor.autowireMode();
        } else {
            String value = SpringProperties.getProperty((String)"spring.test.constructor.autowire.mode");
            autowireMode = TestConstructor.AutowireMode.from(value);
            if (autowireMode == null && fallbackPropertyProvider != null) {
                value = fallbackPropertyProvider.get("spring.test.constructor.autowire.mode");
                autowireMode = TestConstructor.AutowireMode.from(value);
            }
        }
        return autowireMode == TestConstructor.AutowireMode.ALL;
    }
}

