/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;

public final class WriterOutputStream
extends ServletOutputStream {
    private Writer writer;
    private String encoding = null;
    private byte[] buffer = new byte[1];

    public WriterOutputStream(Writer writer) {
        this.writer = writer;
    }

    public WriterOutputStream(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void print(String s) throws IOException {
        this.writer.write(s);
    }

    public void write(byte[] ba) throws IOException {
        if (this.encoding == null) {
            this.writer.write(new String(ba));
        } else {
            this.writer.write(new String(ba, this.encoding));
        }
    }

    public void write(byte[] ba, int off, int len) throws IOException {
        if (this.encoding == null) {
            this.writer.write(new String(ba, off, len));
        } else {
            this.writer.write(new String(ba, off, len, this.encoding));
        }
    }

    public synchronized void write(int bite) throws IOException {
        this.buffer[0] = (byte)bite;
        this.write(this.buffer);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.encoding = null;
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

