<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 3.0.0 (Thu Aug 24 13:36:27 2023 -0600)

**Database Migrations**

- [#25053](https://github.com/apache/superset/pull/25053) fix: extend user email size (@dpgaspar)
- [#24982](https://github.com/apache/superset/pull/24982) fix(snowflake): opt-in denormalization of column names (@villebro)
- [#24939](https://github.com/apache/superset/pull/24939) chore: Add explicit ON DELETE CASCADE for embedded_dashboards (@john-bodley)
- [#24938](https://github.com/apache/superset/pull/24938) chore: Add explicit ON DELETE CASCADE for dashboard_slices (@john-bodley)
- [#24911](https://github.com/apache/superset/pull/24911) fix(logs): increase json field for logs table (@cnabro)
- [#24884](https://github.com/apache/superset/pull/24884) fix: Migration to fix out of sync schema_perm in charts and datasets (@jfrag1)
- [#24831](https://github.com/apache/superset/pull/24831) fix(migration): Ensure cascadeParentIds key exists (@john-bodley)
- [#24510](https://github.com/apache/superset/pull/24510) fix(dashboard): increase json_metadata field (@cnabro)
- [#24749](https://github.com/apache/superset/pull/24749) fix(native filter): clean deleted parent filter ids (@justinpark)
- [#24737](https://github.com/apache/superset/pull/24737) fix(druid): Delete obsolete Druid NoSQL slice parameters (@john-bodley)
- [#24628](https://github.com/apache/superset/pull/24628) chore(dao): Add explicit ON DELETE CASCADE for ownership (@john-bodley)
- [#24661](https://github.com/apache/superset/pull/24661) fix: Ensure config is a dict in cross filters scope migration (@kgabryje)
- [#24629](https://github.com/apache/superset/pull/24629) chore: Drop rouge constraints and tables (@john-bodley)
- [#24558](https://github.com/apache/superset/pull/24558) chore: better styling alerts/reports modal (@betodealmeida)
- [#24547](https://github.com/apache/superset/pull/24547) feat: customize screenshot width for alerts/reports (@betodealmeida)
- [#24553](https://github.com/apache/superset/pull/24553) feat: add description column to Tags (@hughhhh)
- [#24548](https://github.com/apache/superset/pull/24548) fix: heads (@betodealmeida)
- [#24488](https://github.com/apache/superset/pull/24488) chore(dao): Add explicit ON DELETE CASCADE when deleting datasets (@john-bodley)
- [#24517](https://github.com/apache/superset/pull/24517) feat: Implement currencies formatter for saved metrics (@kgabryje)
- [#24266](https://github.com/apache/superset/pull/24266) chore: Remove deprecated ENABLE_ACCESS_REQUEST workflow (@john-bodley)
- [#23910](https://github.com/apache/superset/pull/23910) feat: Migrates Dual Line Chart to Mixed Chart (@michael-s-molina)
- [#23741](https://github.com/apache/superset/pull/23741) feat: Migrates TreeMap chart (@michael-s-molina)
- [#23712](https://github.com/apache/superset/pull/23712) feat: Migrates Pivot Table v1 to v2 (@michael-s-molina)
- [#24306](https://github.com/apache/superset/pull/24306) chore: reorder k-v migration for 2.1.1 (@villebro)
- [#24280](https://github.com/apache/superset/pull/24280) fix: ensure json is not None (@eschutho)
- [#24197](https://github.com/apache/superset/pull/24197) chore(pre-commit): Add pyupgrade and pycln hooks (@john-bodley)
- [#24127](https://github.com/apache/superset/pull/24127) chore: Embrace the walrus operator (@john-bodley)
- [#24020](https://github.com/apache/superset/pull/24020) feat: Cross filters scoping (@kgabryje)
- [#23942](https://github.com/apache/superset/pull/23942) fix: update migration chart_ds_constraint to have separate batch op (@hughhhh)
- [#23925](https://github.com/apache/superset/pull/23925) fix(migration): add log for values unseen in `Slice.datasource_type` (@hughhhh)
- [#23614](https://github.com/apache/superset/pull/23614) chore: add check constraint to restrict `Slice` models datasource_type != "table" (@hughhhh)
- [#23650](https://github.com/apache/superset/pull/23650) fix(migration): Only attempt to drop types if they exist (@jfrag1)
- [#23526](https://github.com/apache/superset/pull/23526) fix(tags): convert postgres enum type to varchar (@nytai)
- [#23410](https://github.com/apache/superset/pull/23410) feat(echarts): Implement stream graph for Echarts Timeseries (@kgabryje)
- [#23173](https://github.com/apache/superset/pull/23173) chore: Update pre-commit packages (@hughhhh)
- [#23276](https://github.com/apache/superset/pull/23276) fix(migration): Address issue in #23228 (@john-bodley)
- [#23273](https://github.com/apache/superset/pull/23273) fix(plugin-chart-echarts): render horizontal categories from top (@villebro)
- [#23228](https://github.com/apache/superset/pull/23228) chore: Deprecate show_native_filters (@john-bodley)
- [#19677](https://github.com/apache/superset/pull/19677) chore(backend): Spelling (@jsoref)

**Features**

- [#24718](https://github.com/apache/superset/pull/24718) feat: Add currencies controls in control panels (@kgabryje)
- [#24960](https://github.com/apache/superset/pull/24960) feat: Adds options to show subtotals in Pivot Table (@michael-s-molina)
- [#24703](https://github.com/apache/superset/pull/24703) feat: migrate charts on import (@betodealmeida)
- [#24433](https://github.com/apache/superset/pull/24433) feat: use Scarf Gateway for Superset npm downloads (@arjundevarajan)
- [#24432](https://github.com/apache/superset/pull/24432) feat: use Scarf Gateway for Superset helm charts/Docker compose downloads (@arjundevarajan)
- [#24329](https://github.com/apache/superset/pull/24329) feat(sqllab): add shortcut for run current sql (@justinpark)
- [#24594](https://github.com/apache/superset/pull/24594) feat: Implement support for currencies in more charts (@kgabryje)
- [#24549](https://github.com/apache/superset/pull/24549) feat: screenshot reports with custom width (@betodealmeida)
- [#24518](https://github.com/apache/superset/pull/24518) feat(tags): move tags from navbar to settings (@hughhhh)
- [#24277](https://github.com/apache/superset/pull/24277) feat(docker): Add support LDAP/AD authorization (@alekseyolg)
- [#24388](https://github.com/apache/superset/pull/24388) feat: Allows new values for single value filters (@michael-s-molina)
- [#24287](https://github.com/apache/superset/pull/24287) feat: add dashboard page full xlsx export (@vitoldi)
- [#24368](https://github.com/apache/superset/pull/24368) feat: make data tables support html (@mistercrunch)
- [#24369](https://github.com/apache/superset/pull/24369) feat(sshtunnel): add configuration for SSH_TIMEOUT (@hughhhh)
- [#24348](https://github.com/apache/superset/pull/24348) feat: add a tooltip to clarify metric_name in the DatasetEditor (@mistercrunch)
- [#24043](https://github.com/apache/superset/pull/24043) feat: Configurable default row limit for native filters (@cleslie)
- [#24345](https://github.com/apache/superset/pull/24345) feat: Convert ENABLE_BROAD_ACTIVITY_ACCESS and MENU_HIDE_USER_INFO into feature flags (@michael-s-molina)
- [#23943](https://github.com/apache/superset/pull/23943) feat: Removes the preset-chart-xy plugin (@michael-s-molina)
- [#23933](https://github.com/apache/superset/pull/23933) feat: Removes the Multiple Line Charts (@michael-s-molina)
- [#24237](https://github.com/apache/superset/pull/24237) feat: support complex types and use get_columns implementation of starrocks python client (@miomiocat)
- [#24205](https://github.com/apache/superset/pull/24205) feat(sqllab): SQLEditor Extension (@Antonio-RiveroMartnez)
- [#24232](https://github.com/apache/superset/pull/24232) feat(flags): enabling and deprecating a few feature flags (@rusackas)
- [#24191](https://github.com/apache/superset/pull/24191) feat: extension hook for DB delete (@betodealmeida)
- [#23209](https://github.com/apache/superset/pull/23209) feat: Add StarRocks support (@miomiocat)
- [#24067](https://github.com/apache/superset/pull/24067) feat: split database information (@betodealmeida)
- [#23551](https://github.com/apache/superset/pull/23551) feat: Add deck.gl Heatmap Visualization (@Mattc1221)
- [#24005](https://github.com/apache/superset/pull/24005) feat: dashboard page xlsx export (@vitoldi)
- [#23174](https://github.com/apache/superset/pull/23174) feat: database extension registry (@betodealmeida)
- [#24048](https://github.com/apache/superset/pull/24048) feat: Make time shifted series colors match the original series (@michael-s-molina)
- [#23035](https://github.com/apache/superset/pull/23035) feat: Use AntD table in FilterableTable (@EugeneTorap)
- [#24035](https://github.com/apache/superset/pull/24035) feat: implement time grain in temporal filters (@villebro)
- [#23970](https://github.com/apache/superset/pull/23970) feat(chart-controls): Show detailed data type tooltip when hovering type icon (@ved-kashyap-samsung)
- [#23890](https://github.com/apache/superset/pull/23890) feat!: bump to Python3.9 (@sebastianliebscher)
- [#23975](https://github.com/apache/superset/pull/23975) feat: Allows dynamic type on viz migrations (@michael-s-molina)
- [#23917](https://github.com/apache/superset/pull/23917) feat: Adds a control to set the Secondary Y-axis bounds in Mixed charts (@michael-s-molina)
- [#23905](https://github.com/apache/superset/pull/23905) feat: Considers GENERIC_CHART_AXES in viz migrations (@michael-s-molina)
- [#20075](https://github.com/apache/superset/pull/20075) feat: custom d3 number locale (@ebaratte)
- [#23869](https://github.com/apache/superset/pull/23869) feat: Changes the Select component to preserve the search value when selecting (@michael-s-molina)
- [#23064](https://github.com/apache/superset/pull/23064) feat: conditional coloring for big number chart (@gbusch)
- [#23698](https://github.com/apache/superset/pull/23698) feat: format timestamps in drill by breadcrumbs (@lilykuang)
- [#23655](https://github.com/apache/superset/pull/23655) feat: add verbose map to get /dataset/ endpoint (@lilykuang)
- [#23716](https://github.com/apache/superset/pull/23716) feat: create dtype option for csv upload (@eschutho)
- [#23777](https://github.com/apache/superset/pull/23777) feat(revert): Re-introduces the RLS page (@michael-s-molina)
- [#22812](https://github.com/apache/superset/pull/22812) feat: Add Ocient support (@alexclavel-ocient)
- [#23768](https://github.com/apache/superset/pull/23768) feat: Display both queries result in Table mode for Mixed Chart in drill by modal (@kgabryje)
- [#23269](https://github.com/apache/superset/pull/23269) feat(native-filters): Add legacy (filter-box) to native filter migration script (@john-bodley)
- [#23748](https://github.com/apache/superset/pull/23748) feat(adhoc-column): add resize option (@villebro)
- [#23724](https://github.com/apache/superset/pull/23724) feat: Drill by error management (@kgabryje)
- [#23634](https://github.com/apache/superset/pull/23634) feat: Makes "Add to dashboard" in Save chart modal paginated (@michael-s-molina)
- [#23697](https://github.com/apache/superset/pull/23697) feat: Add loading state to sqllab save/overwrite dataset modal (@jfrag1)
- [#23720](https://github.com/apache/superset/pull/23720) feat(sqllab): add headers when copying results to clipboard (@villebro)
- [#23707](https://github.com/apache/superset/pull/23707) feat(helm): update redis version due to critical CVE (HIGH PRIORITY) (@justmike1)
- [#23664](https://github.com/apache/superset/pull/23664) feat: Implement breadcrumbs in Drill By modal (@kgabryje)
- [#23644](https://github.com/apache/superset/pull/23644) feat(plugin-chart-echarts): add x-axis sort to multi series (@villebro)
- [#23615](https://github.com/apache/superset/pull/23615) feat: Support further drill by in the modal (@kgabryje)
- [#23657](https://github.com/apache/superset/pull/23657) feat(dashboard): make color indices referable (@villebro)
- [#23603](https://github.com/apache/superset/pull/23603) feat: implement drill by table (@lilykuang)
- [#23402](https://github.com/apache/superset/pull/23402) feat(lang): update messages.po(t) and add missing German translations (@hbruch)
- [#23328](https://github.com/apache/superset/pull/23328) feat(wrap-text): Wrap text support for specific columns in Grid (@SamraHanifCareem)
- [#23601](https://github.com/apache/superset/pull/23601) feat(helm): ability to disable helm hooks (@justmike1)
- [#23602](https://github.com/apache/superset/pull/23602) feat(snowflake): `get_catalog_names` (@betodealmeida)
- [#23599](https://github.com/apache/superset/pull/23599) feat(presto): `get_catalog_names` (@betodealmeida)
- [#23547](https://github.com/apache/superset/pull/23547) feat: Shows user charts by default when editing a dashboard (@michael-s-molina)
- [#23590](https://github.com/apache/superset/pull/23590) feat: Enables ECharts legend selector (@michael-s-molina)
- [#23594](https://github.com/apache/superset/pull/23594) feat(helm): Upgrade default Superset version to 2.1.0 (@dnskr)
- [#23461](https://github.com/apache/superset/pull/23461) feat(bigquery): `get_catalog_names` (@betodealmeida)
- [#23575](https://github.com/apache/superset/pull/23575) feat: Drill by open in Explore (@kgabryje)
- [#23542](https://github.com/apache/superset/pull/23542) feat: Add metadata bar to drill by modal (@kgabryje)
- [#23524](https://github.com/apache/superset/pull/23524) feat: drill by display chart (@lilykuang)
- [#23509](https://github.com/apache/superset/pull/23509) feat(cross-filters): using verbose map in applied cross-filters (@Always-prog)
- [#23439](https://github.com/apache/superset/pull/23439) feat: add ability to disable cache (@villebro)
- [#23458](https://github.com/apache/superset/pull/23458) feat: drill by modal (@lilykuang)
- [#23454](https://github.com/apache/superset/pull/23454) feat: Implement context menu for drill by (@kgabryje)
- [#23416](https://github.com/apache/superset/pull/23416) feat(helm): add nodeselector and tolerations to init job (@dim-ops)
- [#23459](https://github.com/apache/superset/pull/23459) feat: Allows reload on default filter value error (@michael-s-molina)
- [#23447](https://github.com/apache/superset/pull/23447) feat(DB engine spec): `get_catalog_names` (@betodealmeida)
- [#23450](https://github.com/apache/superset/pull/23450) feat(echarts): Add x axis sort by to all series charts (@kgabryje)
- [#23415](https://github.com/apache/superset/pull/23415) feat: add new cache_query_by_user key (@eschutho)
- [#23377](https://github.com/apache/superset/pull/23377) feat(sqllab): log error_detail on fetch failed (@justinpark)
- [#23338](https://github.com/apache/superset/pull/23338) feat(chart): Added SriLanka country map (@rukshn)
- [#23401](https://github.com/apache/superset/pull/23401) feat(postgresql): dynamic schema (@betodealmeida)
- [#23392](https://github.com/apache/superset/pull/23392) feat(plugin-chart-echarts): add series sorting (@villebro)
- [#23319](https://github.com/apache/superset/pull/23319) feat(native-filters): allow cascading from time and numeric filters (@villebro)
- [#23350](https://github.com/apache/superset/pull/23350) feat(dashboard): Change default opacity of icon in FiltersBadge (@kgabryje)
- [#23286](https://github.com/apache/superset/pull/23286) feat(dashboard): Refactor FiltersBadge (@kgabryje)
- [#23287](https://github.com/apache/superset/pull/23287) feat(docs): adds BugHerd to documentation site. (@rusackas)
- [#23274](https://github.com/apache/superset/pull/23274) feat(generic-x-axis): add x sorting on series limit metric (@villebro)
- [#23138](https://github.com/apache/superset/pull/23138) feat: Cross Filters in FilterBar (@geido)
- [#23099](https://github.com/apache/superset/pull/23099) feat(ssh_tunnel): Import/Export Databases with SSHTunnel credentials (@Antonio-RiveroMartnez)
- [#23141](https://github.com/apache/superset/pull/23141) feat(dashboard): Add cross filter from context menu (@kgabryje)
- [#22886](https://github.com/apache/superset/pull/22886) feat: Enable cross filters in WorldMap and Graph charts (@kgabryje)
- [#23143](https://github.com/apache/superset/pull/23143) feat: return UUID on database creation (@betodealmeida)
- [#20876](https://github.com/apache/superset/pull/20876) feat: Frontend tagging (@cccs-RyanK)

**Fixes**

- [#25217](https://github.com/apache/superset/pull/25217) fix: inability to remove chart filter when dashboard time filter is applied (@lilykuang)
- [#25268](https://github.com/apache/superset/pull/25268) fix: Add line height to metadata bar (@kgabryje)
- [#25251](https://github.com/apache/superset/pull/25251) fix(dockefile): broken docker image (@hugosjoberg)
- [#25248](https://github.com/apache/superset/pull/25248) fix: Currency formatting in Table raw mode (@kgabryje)
- [#25249](https://github.com/apache/superset/pull/25249) fix: Don't apply number formatting to the label in Treemap (@kgabryje)
- [#25238](https://github.com/apache/superset/pull/25238) fix: Clearing the currency format has no effect on the chart (@michael-s-molina)
- [#25223](https://github.com/apache/superset/pull/25223) fix: Cypress test to force mouseover (follow-up) (@michael-s-molina)
- [#25213](https://github.com/apache/superset/pull/25213) fix: granularity_sqla and GENERIC_CHART_AXES (@betodealmeida)
- [#24859](https://github.com/apache/superset/pull/24859) fix(sqllab): Force trino client async execution (@giftig)
- [#25209](https://github.com/apache/superset/pull/25209) fix: Cypress test to force mouseover (@michael-s-molina)
- [#25189](https://github.com/apache/superset/pull/25189) fix: `is_select` (@betodealmeida)
- [#25202](https://github.com/apache/superset/pull/25202) fix: All values being selected in Select (@michael-s-molina)
- [#25190](https://github.com/apache/superset/pull/25190) fix: DML failures in SQL Lab (@hughhhh)
- [#25157](https://github.com/apache/superset/pull/25157) fix: Issue #24493; Resolved report selection menu in chart and dashboard page (@suicide11)
- [#25156](https://github.com/apache/superset/pull/25156) fix: Applying Dashboard Time Range Filters to Overwritten Charts (@lilykuang)
- [#25133](https://github.com/apache/superset/pull/25133) fix(sqllab): Invalid start date (@justinpark)
- [#25159](https://github.com/apache/superset/pull/25159) fix: Sunburst chart error when secondary metric is null (@michael-s-molina)
- [#20078](https://github.com/apache/superset/pull/20078) fix: Fixing untranslated FR strings (@aehanno)
- [#25150](https://github.com/apache/superset/pull/25150) fix: Chart series limit doesn't work for some databases (@KSPT-taylorjohn)
- [#25135](https://github.com/apache/superset/pull/25135) fix: Handle Python date format for GENERIC_CHART_AXES feature (@john-bodley)
- [#24711](https://github.com/apache/superset/pull/24711) fix: add format for timestamp in crdb to correctly use times values (@elewis787)
- [#25090](https://github.com/apache/superset/pull/25090) fix: Bumps Flask Caching to fix RCE vulnerability (@michael-s-molina)
- [#25119](https://github.com/apache/superset/pull/25119) fix(DB Connection): Update placeholder values for Snowflake connection (@Vitor-Avila)
- [#25113](https://github.com/apache/superset/pull/25113) fix: Date format when importing international timestamps (@michael-s-molina)
- [#25114](https://github.com/apache/superset/pull/25114) fix(sqllab): error while removing a referenced table (@justinpark)
- [#25091](https://github.com/apache/superset/pull/25091) fix(sqllab): rendering performance regression by resultset (@justinpark)
- [#25081](https://github.com/apache/superset/pull/25081) fix: Allow embedded guest user datasource access with dashboard context (@jfrag1)
- [#25086](https://github.com/apache/superset/pull/25086) fix(assets import): Ensure old datasource ids are not referenced in imported charts (@jfrag1)
- [#25087](https://github.com/apache/superset/pull/25087) fix: Filter names overflow wrap (@michael-s-molina)
- [#25043](https://github.com/apache/superset/pull/25043) fix: dataset update permission out of sync (@zephyring)
- [#25020](https://github.com/apache/superset/pull/25020) fix(embedded sdk): Remove trailing slash from passed superset domain if there is one (@jfrag1)
- [#25074](https://github.com/apache/superset/pull/25074) fix: Cross filters initial scope (@michael-s-molina)
- [#24008](https://github.com/apache/superset/pull/24008) fix(table): condition formatting can't formate 0 values (@Always-prog)
- [#21255](https://github.com/apache/superset/pull/21255) fix(cli): import-directory is missing the application context (@rdubois)
- [#25031](https://github.com/apache/superset/pull/25031) fix: Ensure SQLAlchemy sessions are closed (@john-bodley)
- [#24686](https://github.com/apache/superset/pull/24686) fix: dataset safe URL for explore_url (@dpgaspar)
- [#25057](https://github.com/apache/superset/pull/25057) fix: Error when using the legacy dataset editor (@michael-s-molina)
- [#25029](https://github.com/apache/superset/pull/25029) fix: Native filter dashboard RBAC aware dataset permission (@john-bodley)
- [#25055](https://github.com/apache/superset/pull/25055) fix: docker-compose non-dev (@michael-s-molina)
- [#24999](https://github.com/apache/superset/pull/24999) fix(mssql): avoid trying to return a resultset for DML queries with not resultset (@Yuval-Moshe)
- [#25014](https://github.com/apache/superset/pull/25014) fix: CTE queries with non-SELECT statements (@dpgaspar)
- [#25028](https://github.com/apache/superset/pull/25028) fix: Dashboard fullscreen is removing custom URL params (@michael-s-molina)
- [#25008](https://github.com/apache/superset/pull/25008) fix: Address regression introduced in #24789 (@john-bodley)
- [#24991](https://github.com/apache/superset/pull/24991) fix: Don't let users see dashboards only because it's favorited (@jfrag1)
- [#25017](https://github.com/apache/superset/pull/25017) fix: Downgrades Prophet to 1.1.1 and Holidays to 0.23 (@michael-s-molina)
- [#25009](https://github.com/apache/superset/pull/25009) fix: Date column in Heatmap is displayed as unix timestamp (@michael-s-molina)
- [#24965](https://github.com/apache/superset/pull/24965) fix(sqllab): scroll position after run current sql (@justinpark)
- [#24989](https://github.com/apache/superset/pull/24989) fix: Calendar Heatmap day offset (@michael-s-molina)
- [#24906](https://github.com/apache/superset/pull/24906) fix: Duplicated options in Select when using numerical values (@michael-s-molina)
- [#24959](https://github.com/apache/superset/pull/24959) fix: Tooltips don't disappear on the Heatmap chart (@michael-s-molina)
- [#24953](https://github.com/apache/superset/pull/24953) fix: calls to `_get_sqla_engine` (@betodealmeida)
- [#24903](https://github.com/apache/superset/pull/24903) fix(charts): View in SQL Lab with relevant perm (@giftig)
- [#24946](https://github.com/apache/superset/pull/24946) fix: remove unused file (@mdeshmu)
- [#24806](https://github.com/apache/superset/pull/24806) fix: Dashboard aware RBAC "Save as" menu item (@john-bodley)
- [#24916](https://github.com/apache/superset/pull/24916) fix: Tooltip of area chart shows undefined total (@michael-s-molina)
- [#24886](https://github.com/apache/superset/pull/24886) fix(explore): double resize triggered (@justinpark)
- [#24789](https://github.com/apache/superset/pull/24789) fix: Dashboard aware RBAC dataset permission (@john-bodley)
- [#24892](https://github.com/apache/superset/pull/24892) fix: revert "fix(embedded): adding logic to check dataset used by filters (#24808) (@john-bodley)
- [#24829](https://github.com/apache/superset/pull/24829) fix(dataset): resizable dataset layout left column (@justinpark)
- [#24876](https://github.com/apache/superset/pull/24876) fix(explore): invalid "No Filter" applied (@justinpark)
- [#24874](https://github.com/apache/superset/pull/24874) fix(annotation): Address regression from #24694 (@john-bodley)
- [#24849](https://github.com/apache/superset/pull/24849) fix: validation errors appearing after ssh tunnel switch (@hughhhh)
- [#24862](https://github.com/apache/superset/pull/24862) fix: Explore misleading save action (@michael-s-molina)
- [#24847](https://github.com/apache/superset/pull/24847) fix(sqllab): Add docText for long keyword (@justinpark)
- [#24850](https://github.com/apache/superset/pull/24850) fix(legacy-chart): corrupted raw chart data (@justinpark)
- [#24846](https://github.com/apache/superset/pull/24846) fix: Links in tooltips of dashboard chart cards (@michael-s-molina)
- [#24808](https://github.com/apache/superset/pull/24808) fix(embedded): adding logic to check dataset used by filters (@Vitor-Avila)
- [#24803](https://github.com/apache/superset/pull/24803) fix: Python3.11 (str, Enum) issue (@EugeneTorap)
- [#24796](https://github.com/apache/superset/pull/24796) fix(datasets): give possibility to add dataset with slashes in name (@Always-prog)
- [#24821](https://github.com/apache/superset/pull/24821) fix: Allow chart import to update the dataset an existing chart points to (@jfrag1)
- [#24814](https://github.com/apache/superset/pull/24814) fix: Removes unnecessary query on filters (@michael-s-molina)
- [#24815](https://github.com/apache/superset/pull/24815) fix: pass schema on dataset creation (@betodealmeida)
- [#24801](https://github.com/apache/superset/pull/24801) fix: Filters alert width (@michael-s-molina)
- [#24677](https://github.com/apache/superset/pull/24677) fix(sqllab): Replace autocomplete logic by a hook (@justinpark)
- [#24816](https://github.com/apache/superset/pull/24816) fix: docs invalid client redirect (@dpgaspar)
- [#23988](https://github.com/apache/superset/pull/23988) fix: Department names fixed for CountryMap of France (@xavier-GitHub76)
- [#24798](https://github.com/apache/superset/pull/24798) fix(chore): switching between languages should be without timeout 60 seconds (@Always-prog)
- [#24772](https://github.com/apache/superset/pull/24772) fix(sqllab): Replace margin style by gap on query results (@justinpark)
- [#24698](https://github.com/apache/superset/pull/24698) fix: Select onChange is being fired without explicit selection (@michael-s-molina)
- [#24747](https://github.com/apache/superset/pull/24747) fix: update svgr webpack config to use svg dimensions (@eschutho)
- [#23816](https://github.com/apache/superset/pull/23816) fix(docs): respect no_proxy environment variable (@karsten-wagner)
- [#24756](https://github.com/apache/superset/pull/24756) fix: Tooltip no longer highlights hovered data series (@michael-s-molina)
- [#24740](https://github.com/apache/superset/pull/24740) fix: column/metric type icons look too small (@mistercrunch)
- [#24739](https://github.com/apache/superset/pull/24739) fix: `search_path` in RDS (@betodealmeida)
- [#24599](https://github.com/apache/superset/pull/24599) fix(datasets): Replace left panel layout by TableSelector (@justinpark)
- [#24710](https://github.com/apache/superset/pull/24710) fix(pvt2): migrations from legacy pivot table error when form_data have pieces of pvt2 (@Always-prog)
- [#24746](https://github.com/apache/superset/pull/24746) fix: Dashboard time grain in Table (@michael-s-molina)
- [#24716](https://github.com/apache/superset/pull/24716) fix(range-slider): removed localization of metric key (@Always-prog)
- [#24671](https://github.com/apache/superset/pull/24671) fix(cache): Add cache warmup for non-legacy charts (@john-bodley)
- [#24670](https://github.com/apache/superset/pull/24670) fix: color collision in dashboard with tabs (@lilykuang)
- [#24663](https://github.com/apache/superset/pull/24663) fix(dataset-import): support empty strings for extra fields (@Vitor-Avila)
- [#24690](https://github.com/apache/superset/pull/24690) fix: embedded dashboard check (@betodealmeida)
- [#24665](https://github.com/apache/superset/pull/24665) fix: Dashboard time grain in Pivot Table (@michael-s-molina)
- [#24611](https://github.com/apache/superset/pull/24611) fix(sqllab): missing column meta on autocomplete (@justinpark)
- [#24630](https://github.com/apache/superset/pull/24630) fix: Chart can be added to dashboard by non-owner via save as option (@jfrag1)
- [#24642](https://github.com/apache/superset/pull/24642) fix: Incorrect initial global scoping of cross filters (@kgabryje)
- [#24610](https://github.com/apache/superset/pull/24610) fix: Validation of out of scope filters and interaction with Clear All (@michael-s-molina)
- [#24646](https://github.com/apache/superset/pull/24646) fix: CSP, bump FAB to 4.3.4 (@dpgaspar)
- [#24625](https://github.com/apache/superset/pull/24625) fix: fix extra insert for count on dataset creation (@hughhhh)
- [#24643](https://github.com/apache/superset/pull/24643) fix: Ensure metrics is an array in Mixed Chart (@kgabryje)
- [#24644](https://github.com/apache/superset/pull/24644) fix: remove spaces and EOL from nonce attr (@dpgaspar)
- [#24617](https://github.com/apache/superset/pull/24617) fix: Wrong positioning of filter tooltips on scroll (@michael-s-molina)
- [#24609](https://github.com/apache/superset/pull/24609) fix: change naming convention for count metric on Dataset creation (@hughhhh)
- [#24567](https://github.com/apache/superset/pull/24567) fix: remove underscore from builtin_time_grains label (@cnabro)
- [#24608](https://github.com/apache/superset/pull/24608) fix: Incorrect dependency between filters related feature flags (@michael-s-molina)
- [#24612](https://github.com/apache/superset/pull/24612) fix(report): edit without custom width (@betodealmeida)
- [#24552](https://github.com/apache/superset/pull/24552) fix(ssh): Editing Database w/ SSH Tunneling (@hughhhh)
- [#24556](https://github.com/apache/superset/pull/24556) fix: set max version for pyocient (@jwilliams-ocient)
- [#24129](https://github.com/apache/superset/pull/24129) fix: Bump prophet, re-enable tests, and remedy column eligibility logic (@john-bodley)
- [#24593](https://github.com/apache/superset/pull/24593) fix: Clicking on a tag in the dashboard and charts lists does not work (@michael-s-molina)
- [#24196](https://github.com/apache/superset/pull/24196) fix: SSH Tunnel creation with dynamic form (@hughhhh)
- [#24555](https://github.com/apache/superset/pull/24555) fix: Metric is truncated in tooltip (@michael-s-molina)
- [#24565](https://github.com/apache/superset/pull/24565) fix: docker compose refusing to start (@dpgaspar)
- [#24536](https://github.com/apache/superset/pull/24536) fix(sqllab): Add threshold for checking inactive queries (@justinpark)
- [#24546](https://github.com/apache/superset/pull/24546) fix: Error when searching for a dashboard in the chart list (@michael-s-molina)
- [#24550](https://github.com/apache/superset/pull/24550) fix: Deque mutated during iteration (@michael-s-molina)
- [#24541](https://github.com/apache/superset/pull/24541) fix(docs): Typo in filter migration. (@Hikari)
- [#24475](https://github.com/apache/superset/pull/24475) fix(translations): typo mistake (translation to Spanish) (@santi-pragma)
- [#24519](https://github.com/apache/superset/pull/24519) fix: SQL Lab - correct setting name from DISPLAY_MAX_ROWS to DISPLAY_MAX_ROW (@jgillick)
- [#24537](https://github.com/apache/superset/pull/24537) fix: Use Celery task ETA for alert/report schedule (@john-bodley)
- [#24545](https://github.com/apache/superset/pull/24545) fix: Revert enable strong session protection by default (#24256) (@michael-s-molina)
- [#24544](https://github.com/apache/superset/pull/24544) fix: Release scripts Python version (@michael-s-molina)
- [#24542](https://github.com/apache/superset/pull/24542) fix(native-filters): Infinite load when filter with default first value is out of scope in horizontal bar (@kgabryje)
- [#24492](https://github.com/apache/superset/pull/24492) fix(charts): big-number display broken in echarts (@curious86)
- [#24506](https://github.com/apache/superset/pull/24506) fix: Native filter dynamic numeric search (@john-bodley)
- [#24477](https://github.com/apache/superset/pull/24477) fix: Total calculation in stacked Timeseries charts (@michael-s-molina)
- [#24471](https://github.com/apache/superset/pull/24471) fix(oracle): denormalize column names where applicable (@villebro)
- [#24476](https://github.com/apache/superset/pull/24476) fix: Revert enabling CSP (@kgabryje)
- [#24418](https://github.com/apache/superset/pull/24418) fix: Native filter dynamic numeric search (@john-bodley)
- [#24447](https://github.com/apache/superset/pull/24447) fix(charts): Fix chart load task error handling (@giftig)
- [#24405](https://github.com/apache/superset/pull/24405) fix: creating a new chart with dashboard time filters but filter can't apply again (@lilykuang)
- [#24434](https://github.com/apache/superset/pull/24434) fix: Revert to old endpoint temporarily to enable sharing saved queries (@jfrag1)
- [#24248](https://github.com/apache/superset/pull/24248) fix: save columns reference from sqllab save datasets flow (@hughhhh)
- [#24429](https://github.com/apache/superset/pull/24429) fix: Viz migration adjustments - 2 (@michael-s-molina)
- [#24440](https://github.com/apache/superset/pull/24440) fix(translations): regularise the capitalisation of 'CSV' in en localisation (@stuartyeates)
- [#24410](https://github.com/apache/superset/pull/24410) fix: force data load on import examples (@eschutho)
- [#24422](https://github.com/apache/superset/pull/24422) fix(sql-lab): remove redundant onChange schema property (@villebro)
- [#24420](https://github.com/apache/superset/pull/24420) fix: FE call to changed recent_activity endpoint (@dpgaspar)
- [#24428](https://github.com/apache/superset/pull/24428) fix: deck.gl Geojson path not visible (@kgabryje)
- [#24392](https://github.com/apache/superset/pull/24392) fix: Fixes #24391 (Problems with celery beat running with docker when the machine is rebooted suddenly) (@alvarolmedo)
- [#24221](https://github.com/apache/superset/pull/24221) fix(helm): Add fullname prefix to init job (@NickLarsenNZ)
- [#24121](https://github.com/apache/superset/pull/24121) fix: Address regression introduced in #22853 (@john-bodley)
- [#24143](https://github.com/apache/superset/pull/24143) fix: Ensure "Import Dashboard" menu item adheres to PVM (@john-bodley)
- [#24350](https://github.com/apache/superset/pull/24350) fix: Address dashboard permission regression in #23586 (@john-bodley)
- [#24363](https://github.com/apache/superset/pull/24363) fix: deck.gl Scatterplot min/max radius (@kgabryje)
- [#24344](https://github.com/apache/superset/pull/24344) fix(sqllab): Inefficient SqlaTable query (#24343) (@giftig)
- [#24341](https://github.com/apache/superset/pull/24341) fix: Viz migration adjustments - 1 (@michael-s-molina)
- [#24317](https://github.com/apache/superset/pull/24317) fix: update order of build for testing a release (@eschutho)
- [#24303](https://github.com/apache/superset/pull/24303) fix: Copy dashboard filters when copying dashboard (@jfrag1)
- [#24176](https://github.com/apache/superset/pull/24176) fix: Time shifts with different granularity for ECharts (@michael-s-molina)
- [#24315](https://github.com/apache/superset/pull/24315) fix: DB extension collapse (@betodealmeida)
- [#19808](https://github.com/apache/superset/pull/19808) fix(sql-lab): SQL Lab commit connection even if no CTA query is made (@snt1017)
- [#24265](https://github.com/apache/superset/pull/24265) fix(capitalization): Capitalizing the 'metric' label in Pivot Tables (@rusackas)
- [#24304](https://github.com/apache/superset/pull/24304) fix(dashboard): max call size stack error (@justinpark)
- [#24293](https://github.com/apache/superset/pull/24293) fix: Removes file extension from textUtils (@michael-s-molina)
- [#24291](https://github.com/apache/superset/pull/24291) fix: Text utils null value when reading module (@michael-s-molina)
- [#24279](https://github.com/apache/superset/pull/24279) fix(migrations): Fixing cross filter migration (@craig-rueda)
- [#24279](https://github.com/apache/superset/pull/24279) fix(migrations): Fixing cross filter migration (@craig-rueda)
- [#24256](https://github.com/apache/superset/pull/24256) fix: enable strong session protection by default (@dpgaspar)
- [#23562](https://github.com/apache/superset/pull/23562) fix(docs): Update databricks.mdx with correct pip package name (@amosdoublec)
- [#24217](https://github.com/apache/superset/pull/24217) fix: TypeScript warnings when importing types (@michael-s-molina)
- [#24222](https://github.com/apache/superset/pull/24222) fix(helm): Use correct default hostnames for postgres and redis (@NickLarsenNZ)
- [#24242](https://github.com/apache/superset/pull/24242) fix(dataset-api): allow undefined schema in post (@villebro)
- [#24207](https://github.com/apache/superset/pull/24207) fix: removing problematic "formattable" tag (@rusackas)
- [#24223](https://github.com/apache/superset/pull/24223) fix: Tag link issue from CRUD page (@hughhhh)
- [#24181](https://github.com/apache/superset/pull/24181) fix(translation): complete portuguese(brazilian) translation (@lucas1221)
- [#24177](https://github.com/apache/superset/pull/24177) fix(explore): rendering regression on standalone (@justinpark)
- [#24186](https://github.com/apache/superset/pull/24186) fix(plugin-chart-echarts): force min y-tick for log axis with zero (@villebro)
- [#24060](https://github.com/apache/superset/pull/24060) fix: always allow tags to be returned via the API (@hughhhh)
- [#24142](https://github.com/apache/superset/pull/24142) fix(sqllab): Table options rendering regression (@justinpark)
- [#24113](https://github.com/apache/superset/pull/24113) fix: Errors when saving dataset (@jfrag1)
- [#24158](https://github.com/apache/superset/pull/24158) fix(table): percentage metric should use verbose map (@Always-prog)
- [#24159](https://github.com/apache/superset/pull/24159) fix(reports): error when creation alert/report with localization (@Always-prog)
- [#23762](https://github.com/apache/superset/pull/23762) fix: repeated color in the same chart (@lilykuang)
- [#24124](https://github.com/apache/superset/pull/24124) fix: Revert tox basepython (@john-bodley)
- [#24134](https://github.com/apache/superset/pull/24134) fix(plugin-chart-echarts): normalize temporal string groupbys (@villebro)
- [#24120](https://github.com/apache/superset/pull/24120) fix(sqllab): Disable Select All on table selector (@justinpark)
- [#24114](https://github.com/apache/superset/pull/24114) fix(ci): remove username from owner (@villebro)
- [#23814](https://github.com/apache/superset/pull/23814) fix(ocient): convert pyocient GIS data types to geoJSON (@jwilliams-ocient)
- [#23867](https://github.com/apache/superset/pull/23867) fix(docs): Installation instruction changes (@artofcomputing)
- [#24070](https://github.com/apache/superset/pull/24070) fix(alert modal): set current user as default alert owner during new alert initialization (@curious86)
- [#24068](https://github.com/apache/superset/pull/24068) fix: Handle python_date_format in ExploreMixin (@john-bodley)
- [#24062](https://github.com/apache/superset/pull/24062) fix: handle `python_date_format` in ExploreMixin (@betodealmeida)
- [#24028](https://github.com/apache/superset/pull/24028) fix: typing and using enter to select the table on sql lab layout (@lilykuang)
- [#24009](https://github.com/apache/superset/pull/24009) fix(sqllab): rollback clean comments out (@justinpark)
- [#23971](https://github.com/apache/superset/pull/23971) fix: MySQL et al. super calls (@john-bodley)
- [#23715](https://github.com/apache/superset/pull/23715) fix(filters): Stop breaking if translateToSql returns an object (@Antonio-RiveroMartnez)
- [#23952](https://github.com/apache/superset/pull/23952) fix(sqllab): custom url params disappeared (@justinpark)
- [#23935](https://github.com/apache/superset/pull/23935) fix: methods incorrect type and update deprecated targets (@dpgaspar)
- [#23908](https://github.com/apache/superset/pull/23908) fix(sqllab): clean comments within quotes (@justinpark)
- [#23924](https://github.com/apache/superset/pull/23924) fix: timeout should be an integer (@betodealmeida)
- [#23892](https://github.com/apache/superset/pull/23892) fix(sql-editor): Fix run stop button color to improve usability (@curious86)
- [#23909](https://github.com/apache/superset/pull/23909) fix: remove feature flag for tags on Dashboard API for `Tags` (@hughhhh)
- [#23881](https://github.com/apache/superset/pull/23881) fix(native-filters): Address spelling mistakes (@john-bodley)
- [#23778](https://github.com/apache/superset/pull/23778) fix(chart): scrollbar keep flushing on and off (@justinpark)
- [#23868](https://github.com/apache/superset/pull/23868) fix: move dynamic schema out of base Postgres class (@hughhhh)
- [#23702](https://github.com/apache/superset/pull/23702) fix: npm run dev-server error resolved (@Abhishek-kumar-samsung)
- [#23872](https://github.com/apache/superset/pull/23872) fix(dremio): query with alias (@betodealmeida)
- [#23860](https://github.com/apache/superset/pull/23860) fix(alerts): flaky test error (@justinpark)
- [#23832](https://github.com/apache/superset/pull/23832) fix(native-filters): Address spelling mistakes (@john-bodley)
- [#23856](https://github.com/apache/superset/pull/23856) fix(tests): Ensure deterministic SELECT ordering for CSV upload tests (@john-bodley)
- [#23627](https://github.com/apache/superset/pull/23627) fix(chart): chart updates are not retained (@justinpark)
- [#23857](https://github.com/apache/superset/pull/23857) fix(ephemerals): Quick fix for ephemeral spin-up (@craig-rueda)
- [#23831](https://github.com/apache/superset/pull/23831) fix: Preserve filters from previous drillings in drill by (@kgabryje)
- [#23830](https://github.com/apache/superset/pull/23830) fix: Loading state when cols for drill by are loading (@kgabryje)
- [#23818](https://github.com/apache/superset/pull/23818) fix(revert): Reverts storybook-addon-mock inclusion (@michael-s-molina)
- [#23685](https://github.com/apache/superset/pull/23685) fix(utils): evaluate date parser multiple holiday results correctly (@arkid15r)
- [#23811](https://github.com/apache/superset/pull/23811) fix: Hide FiltersPanel in standalone mode 3 (@geido)
- [#23731](https://github.com/apache/superset/pull/23731) fix: pivot v2 charts created before `GENERIC_CHART_AXES` is enabled (@betodealmeida)
- [#23819](https://github.com/apache/superset/pull/23819) fix: Clean up docker-ephemeral-env secrets command (@michael-s-molina)
- [#23817](https://github.com/apache/superset/pull/23817) fix(rls api): Add missing init file (@jfrag1)
- [#23805](https://github.com/apache/superset/pull/23805) fix(sqllab): test failed due to legacy api url (@justinpark)
- [#23783](https://github.com/apache/superset/pull/23783) fix(datasource): saving new calculated columns (@Always-prog)
- [#23786](https://github.com/apache/superset/pull/23786) fix: Docker ephemeral env (@michael-s-molina)
- [#23797](https://github.com/apache/superset/pull/23797) fix: Context menu crashing when there is no dimension in Echarts Series charts (@kgabryje)
- [#23776](https://github.com/apache/superset/pull/23776) fix: [chart power query] error show when user input column with x-axis (@hughhhh)
- [#23779](https://github.com/apache/superset/pull/23779) fix(native-filters): Fix encoding of non-temporal default values (@john-bodley)
- [#23087](https://github.com/apache/superset/pull/23087) fix(sqllab): Persisting tab state for saved query (@piyush9923)
- [#23757](https://github.com/apache/superset/pull/23757) fix: Drill by modal resizing (@kgabryje)
- [#23754](https://github.com/apache/superset/pull/23754) fix: Further drilling by different groupby fields (@kgabryje)
- [#23758](https://github.com/apache/superset/pull/23758) fix: Make sure the DeprecatedSelect label is always a string (@michael-s-molina)
- [#23157](https://github.com/apache/superset/pull/23157) fix(cache): coerce schema_cache_timeout to None (@cemremengu)
- [#23747](https://github.com/apache/superset/pull/23747) fix(ace-editor): use monospace fonts by default (@villebro)
- [#23737](https://github.com/apache/superset/pull/23737) fix: get or create db with an existing invalid URL (@dpgaspar)
- [#23669](https://github.com/apache/superset/pull/23669) fix(sqllab): infinite running state on disconnect (@justinpark)
- [#22370](https://github.com/apache/superset/pull/22370) fix: is_select check for lowercase select with "WITH" clauses (@fcomuniz)
- [#23695](https://github.com/apache/superset/pull/23695) fix(sqllab): rendering performance regression (@justinpark)
- [#23686](https://github.com/apache/superset/pull/23686) fix: Database modal parameter inputs persisting after modal closed and reopened (@jfrag1)
- [#23675](https://github.com/apache/superset/pull/23675) fix(plugin-chart-echarts): reorder totals and support multimetric sort (@villebro)
- [#23117](https://github.com/apache/superset/pull/23117) fix(ci): Fix GitHub workflow behavior for forks (@jsoref)
- [#23692](https://github.com/apache/superset/pull/23692) fix: Further drill by in Pivot Table (@kgabryje)
- [#23649](https://github.com/apache/superset/pull/23649) fix: Zero values on Dual Line axis bounds (@michael-s-molina)
- [#23641](https://github.com/apache/superset/pull/23641) fix: url_params cache miss with global async query (@kekwan)
- [#23682](https://github.com/apache/superset/pull/23682) fix: allow for dependencies that could be undefined (@eschutho)
- [#23624](https://github.com/apache/superset/pull/23624) fix(docker): optimize docker build by better utilizing build cache (@sebastianliebscher)
- [#23671](https://github.com/apache/superset/pull/23671) fix(sqllab): Revert "rendering performance regression (#23653)" (@justinpark)
- [#23666](https://github.com/apache/superset/pull/23666) fix: presto CI failed test (@hughhhh)
- [#23604](https://github.com/apache/superset/pull/23604) fix: update log message for ALERT_REPORTS_NOTIFICATION_DRY_RUN (@nytai)
- [#23653](https://github.com/apache/superset/pull/23653) fix(sqllab): rendering performance regression (@justinpark)
- [#23637](https://github.com/apache/superset/pull/23637) fix: Removes Redux state mutations - iteration 3 (@michael-s-molina)
- [#23611](https://github.com/apache/superset/pull/23611) fix(saved_queries): wrong enum for object_type of saved_query (@akzarma)
- [#23396](https://github.com/apache/superset/pull/23396) fix(Gauge echart): displaying column label (@AkashBoora)
- [#22677](https://github.com/apache/superset/pull/22677) fix(localization): localize legacy pivot table (@artemonsh)
- [#23589](https://github.com/apache/superset/pull/23589) fix(charts): Time range filters are not being applied to charts that were overwritten (@Antonio-RiveroMartnez)
- [#23421](https://github.com/apache/superset/pull/23421) fix(#23176): adding URL decoding to SQLAlchemy URI (@RekhaZemoso)
- [#23617](https://github.com/apache/superset/pull/23617) fix: Error on Cypress test (@michael-s-molina)
- [#23588](https://github.com/apache/superset/pull/23588) fix: Disables email reports for unsaved charts (@michael-s-molina)
- [#23597](https://github.com/apache/superset/pull/23597) fix: Ensure verbose mapping exists for SQL Lab Query model (@john-bodley)
- [#23613](https://github.com/apache/superset/pull/23613) fix: Increases the options limit for Annotation Layers (@michael-s-molina)
- [#23587](https://github.com/apache/superset/pull/23587) fix(docker-compose): Make worker use correct healthcheck (#23455) (@sebastianliebscher)
- [#23129](https://github.com/apache/superset/pull/23129) fix(translation): correct translation errors for Chinese(zh) (@zRich)
- [#23585](https://github.com/apache/superset/pull/23585) fix: Ensure the reporting framework handles charts with no data (@john-bodley)
- [#23579](https://github.com/apache/superset/pull/23579) fix(revert): "fix: cache warmup solution non legacy charts. (#23012)" (@john-bodley)
- [#23535](https://github.com/apache/superset/pull/23535) fix: Removes Redux state mutations - iteration 2 (@michael-s-molina)
- [#23576](https://github.com/apache/superset/pull/23576) fix(dashboard): Cross filters badge for cols with verbose names (@kgabryje)
- [#23567](https://github.com/apache/superset/pull/23567) fix: QueryParamProvider error on backend rendered views (@michael-s-molina)
- [#23548](https://github.com/apache/superset/pull/23548) fix: tags features flag on base models (@hughhhh)
- [#23565](https://github.com/apache/superset/pull/23565) fix: Add default empty array to filter dependencies (@dayknightmare)
- [#23533](https://github.com/apache/superset/pull/23533) fix(plugin-chart-table): Include time control (@kgabryje)
- [#23549](https://github.com/apache/superset/pull/23549) fix(sqllab): undefined issue_codes on query error (@justinpark)
- [#23543](https://github.com/apache/superset/pull/23543) fix: Hide FilterBar for Reports (@geido)
- [#23514](https://github.com/apache/superset/pull/23514) fix(sqllab): dedupe table_schemas in active_tab (@justinpark)
- [#23522](https://github.com/apache/superset/pull/23522) fix: Removes Redux state mutations - iteration 1 (@michael-s-molina)
- [#22880](https://github.com/apache/superset/pull/22880) fix: moved alerts and reports default values to config (@Always-prog)
- [#23469](https://github.com/apache/superset/pull/23469) fix(area chart legacy): tool tip shows actual value rather than y axi… (@AkashBoora)
- [#23137](https://github.com/apache/superset/pull/23137) fix(conditional formatting): controls looses on save (@Always-prog)
- [#23517](https://github.com/apache/superset/pull/23517) fix(word cloud): series label format fixed for custom sql queries (@ashgorithm)
- [#23513](https://github.com/apache/superset/pull/23513) fix(plugin-generator): Addresses linter errors in newly generated Superset plugin (@alex-bain)
- [#23521](https://github.com/apache/superset/pull/23521) fix(dashboards): apply tag filter correctly (@akzarma)
- [#23515](https://github.com/apache/superset/pull/23515) fix(plugin-chart-table): Invalid d3Formatter on String column (@justinpark)
- [#23475](https://github.com/apache/superset/pull/23475) fix: Preserves selected scopes when toggling between scope types (@michael-s-molina)
- [#23502](https://github.com/apache/superset/pull/23502) fix(dashboard): Add remark plugin on markdown (@justinpark)
- [#23480](https://github.com/apache/superset/pull/23480) fix: Chart crashing if timeseries_limit_metric is an empty array (@kgabryje)
- [#23378](https://github.com/apache/superset/pull/23378) fix(sqllab): throw errors of commented out query (@justinpark)
- [#23471](https://github.com/apache/superset/pull/23471) fix: broken helm chart ingress (@paulinjo)
- [#23452](https://github.com/apache/superset/pull/23452) fix(chart): add missing toleration for init-job (@ZeJ0hn)
- [#23265](https://github.com/apache/superset/pull/23265) fix(sqllab): dedupe active_tab in tabHistory (@justinpark)
- [#23446](https://github.com/apache/superset/pull/23446) fix: Allow setting ingress hosts directly through yaml (@paulinjo)
- [#23414](https://github.com/apache/superset/pull/23414) fix: prevent ForeignKeyViolation error on delete (@betodealmeida)
- [#23386](https://github.com/apache/superset/pull/23386) fix: schedule query option showing up (@betodealmeida)
- [#23432](https://github.com/apache/superset/pull/23432) fix: safe check when computing chart thumbnail (@zephyring)
- [#23433](https://github.com/apache/superset/pull/23433) fix: database dropdown keys (@betodealmeida)
- [#23389](https://github.com/apache/superset/pull/23389) fix(dashboard): `show_native_filters` leftover (@betodealmeida)
- [#23409](https://github.com/apache/superset/pull/23409) fix(docker): multi-architecture image build (@EugeneTorap)
- [#23330](https://github.com/apache/superset/pull/23330) fix: revert back to use security manager authz for dashboard when get by uuid (@zephyring)
- [#23318](https://github.com/apache/superset/pull/23318) fix: Table sorting reset (@geido)
- [#23376](https://github.com/apache/superset/pull/23376) fix: dataset_macro (@betodealmeida)
- [#23356](https://github.com/apache/superset/pull/23356) fix: table schema permissions (@betodealmeida)
- [#23314](https://github.com/apache/superset/pull/23314) fix(native-filters): Caching scope (@john-bodley)
- [#23365](https://github.com/apache/superset/pull/23365) fix(chart-controls): Error if x_axis_sort and timeseries_limit_metric are included in main metrics (@kgabryje)
- [#23361](https://github.com/apache/superset/pull/23361) fix(safari): remove autocomplete in table select (@villebro)
- [#23302](https://github.com/apache/superset/pull/23302) fix(sqllab): empty large query results from localStorage (@justinpark)
- [#23322](https://github.com/apache/superset/pull/23322) fix(examples): Cleanup granularity_sqla column (@john-bodley)
- [#23324](https://github.com/apache/superset/pull/23324) fix(trino): Disallow alias to source column (@john-bodley)
- [#23329](https://github.com/apache/superset/pull/23329) fix(dashboard): deepmerge htmlSchemaOverrides (@justinpark)
- [#23348](https://github.com/apache/superset/pull/23348) fix: dashboard DAO small code improvement (@dpgaspar)
- [#23347](https://github.com/apache/superset/pull/23347) fix(dashboard): Cross filters with time shifted series (@kgabryje)
- [#23339](https://github.com/apache/superset/pull/23339) fix(trino): normalize non-iso timestamps (@villebro)
- [#23296](https://github.com/apache/superset/pull/23296) fix(clickhouse): Update to working clickhouse-connect version (@genzgd)
- [#23260](https://github.com/apache/superset/pull/23260) fix(examples): Cleanup dashboard filter scopes (@john-bodley)
- [#23283](https://github.com/apache/superset/pull/23283) fix(dashboard): Allow selecting text in cells in Table and PivotTable without triggering cross filters (@kgabryje)
- [#23262](https://github.com/apache/superset/pull/23262) fix: ignore ts warnings from older typescript versions (@eschutho)
- [#23256](https://github.com/apache/superset/pull/23256) fix(dashboard): Missing filter card styles (@kgabryje)
- [#23250](https://github.com/apache/superset/pull/23250) fix(dashboard): Cross-filter search icon in filter bar (@kgabryje)
- [#23242](https://github.com/apache/superset/pull/23242) fix: Video Game Sales dashboard default filters (@john-bodley)
- [#23239](https://github.com/apache/superset/pull/23239) fix(explore): Dashboard filters on adhoc cols not working in Explore (@kgabryje)
- [#23194](https://github.com/apache/superset/pull/23194) fix(dashboard): Cross-filters not working properly for new dashboards (@kgabryje)
- [#23215](https://github.com/apache/superset/pull/23215) fix(dashboard): Page crashing when cross filter applied on adhoc column (@kgabryje)
- [#23202](https://github.com/apache/superset/pull/23202) fix(docs): Change postgres to postgresql in brew install command (@lyndsiWilliams)
- [#23130](https://github.com/apache/superset/pull/23130) fix: Pagination of VirtualTable (@EugeneTorap)
- [#23022](https://github.com/apache/superset/pull/23022) fix(dashboard): Chart's empty state not centered (@kgabryje)
- [#23135](https://github.com/apache/superset/pull/23135) fix: gamma sql_json test (@dpgaspar)
- [#23126](https://github.com/apache/superset/pull/23126) fix(ci): explicity set yaml Loader (@villebro)

**Others**

- [#25275](https://github.com/apache/superset/pull/25275) chore: Remove the ability to switch to filter-box chart when DASHBOARD_NATIVE_FILTERS feature is enabled (@john-bodley)
- [#25211](https://github.com/apache/superset/pull/25211) chore(trino): remove unnecessary index checks (@villebro)
- [#25161](https://github.com/apache/superset/pull/25161) chore: Add a note about adhoc subqueries in UPDATING.md (@michael-s-molina)
- [#25127](https://github.com/apache/superset/pull/25127) docs: Fix typo in UPDATING.md (@john-bodley)
- [#25129](https://github.com/apache/superset/pull/25129) refactor(frontend): make "Search" box the first filter for charts and datasets (@sfirke)
- [#25115](https://github.com/apache/superset/pull/25115) docs: Update UPDATING.md regarding potential breaking change to `ab_user.email` column (@john-bodley)
- [#24942](https://github.com/apache/superset/pull/24942) refactor(pinot): The `python_date_format` for a temporal column was not being passed to `get_timestamp_expr` (@ege-st)
- [#24826](https://github.com/apache/superset/pull/24826) chore: remove CssTemplate and Annotation access from gamma role (@lilykuang)
- [#25016](https://github.com/apache/superset/pull/25016) chore: use os.getenv to simplify superset_config.py (@sebastianliebscher)
- [#25025](https://github.com/apache/superset/pull/25025) chore: Pass the dashboard id when requesting filter values (@michael-s-molina)
- [#25003](https://github.com/apache/superset/pull/25003) chore: isolate examples database by default (@dpgaspar)
- [#24923](https://github.com/apache/superset/pull/24923) chore: modify UPDATING.md for logs table migrations (@cnabro)
- [#24324](https://github.com/apache/superset/pull/24324) chore: rate limit requests (@betodealmeida)
- [#24935](https://github.com/apache/superset/pull/24935) chore: Removes duplicated featureFlags.ts (@michael-s-molina)
- [#24864](https://github.com/apache/superset/pull/24864) chore: Refine native dashboard cleanup logic (@john-bodley)
- [#24804](https://github.com/apache/superset/pull/24804) chore: Refactor dashboard security access (@john-bodley)
- [#24774](https://github.com/apache/superset/pull/24774) chore: add talisman env var to config (@eschutho)
- [#24613](https://github.com/apache/superset/pull/24613) build(deps): bump tox from 4.6.3 to 4.6.4 in /requirements (@dependabot[bot])
- [#24769](https://github.com/apache/superset/pull/24769) docs: update security policy and add CVE info (@dpgaspar)
- [#24758](https://github.com/apache/superset/pull/24758) chore(view_api): return application/json as content-type for api/v1/form_data endpoint (@zephyring)
- [#24759](https://github.com/apache/superset/pull/24759) chore(docs): Adding link to additional visualization content (@rusackas)
- [#24766](https://github.com/apache/superset/pull/24766) docs: Fix STANDARD_ROLES.md for Gamma role permissions on tableschemaview (@mattitoo)
- [#24736](https://github.com/apache/superset/pull/24736) chore: make control panel sub sections look better (@mistercrunch)
- [#24559](https://github.com/apache/superset/pull/24559) chore(native filters): Expandable filter config modal (@justinpark)
- [#24741](https://github.com/apache/superset/pull/24741) chore: make antd table font size same as data table (@mistercrunch)
- [#24627](https://github.com/apache/superset/pull/24627) chore: turn off talisman for ephemeral environments in ci (@eschutho)
- [#24731](https://github.com/apache/superset/pull/24731) chore: Bump PyYAML bounds (@john-bodley)
- [#24694](https://github.com/apache/superset/pull/24694) chore: Remove obsolete legacy visualizations (@john-bodley)
- [#24689](https://github.com/apache/superset/pull/24689) chore: move deprecated default version to 4.0.0 (@dpgaspar)
- [#24607](https://github.com/apache/superset/pull/24607) chore(command): Condense delete/bulk-delete operations (@john-bodley)
- [#24647](https://github.com/apache/superset/pull/24647) chore: Bump holidays to 0.28 (@arkid15r)
- [#24652](https://github.com/apache/superset/pull/24652) chore: Bump/relax Flask libs (@john-bodley)
- [#24466](https://github.com/apache/superset/pull/24466) chore(dao): Condense delete/bulk-delete operations (@john-bodley)
- [#24554](https://github.com/apache/superset/pull/24554) chore(sqllab): Log current local storage usage (@justinpark)
- [#24452](https://github.com/apache/superset/pull/24452) build(deps): bump tox from 4.6.1 to 4.6.3 in /requirements (@dependabot[bot])
- [#24524](https://github.com/apache/superset/pull/24524) build(deps-dev): bump @types/node from 20.3.1 to 20.3.2 in /superset-websocket (@dependabot[bot])
- [#24522](https://github.com/apache/superset/pull/24522) build(deps-dev): bump @typescript-eslint/parser from 5.60.0 to 5.60.1 in /superset-websocket (@dependabot[bot])
- [#24501](https://github.com/apache/superset/pull/24501) build(deps): bump semver from 7.3.8 to 7.5.3 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#24404](https://github.com/apache/superset/pull/24404) chore: deprecate FLASK_ENV and improve conf.ENVIRONMENT_TAG_CONFIG (@mistercrunch)
- [#24534](https://github.com/apache/superset/pull/24534) build(docker): add dockerize image (@alekseyolg)
- [#24462](https://github.com/apache/superset/pull/24462) docs: updating images and markdown (@rusackas)
- [#24543](https://github.com/apache/superset/pull/24543) chore: Un-revert enabling CSP by default (@kgabryje)
- [#24514](https://github.com/apache/superset/pull/24514) refactor: pkg_resources -> importlib.metadata (@cwegener)
- [#24538](https://github.com/apache/superset/pull/24538) chore: Constrain selenium version (@john-bodley)
- [#24505](https://github.com/apache/superset/pull/24505) chore: update d3-colors (@hughhhh)
- [#24499](https://github.com/apache/superset/pull/24499) chore: remove marshmallow-enum dependency and bump FAB (@dpgaspar)
- [#24504](https://github.com/apache/superset/pull/24504) build(docker): simplification of assembly to facilitate further support (@alekseyolg)
- [#24503](https://github.com/apache/superset/pull/24503) chore: update ansi-regex (@hughhhh)
- [#24489](https://github.com/apache/superset/pull/24489) chore(sqllab): add extra_json on tabstate (@justinpark)
- [#24497](https://github.com/apache/superset/pull/24497) build(docker): pin the underlying debian base image (@boenshao)
- [#24371](https://github.com/apache/superset/pull/24371) chore(sqllab): Remove table metadata from state (@justinpark)
- [#24443](https://github.com/apache/superset/pull/24443) build(deps-dev): bump eslint from 8.42.0 to 8.43.0 in /superset-websocket (@dependabot[bot])
- [#24454](https://github.com/apache/superset/pull/24454) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.11 to 5.60.0 in /superset-websocket (@dependabot[bot])
- [#24474](https://github.com/apache/superset/pull/24474) docs: Add CTA to community calendar subscription (@thiagorossener)
- [#24465](https://github.com/apache/superset/pull/24465) chore(dao): Add generic type for better type checking (@john-bodley)
- [#24397](https://github.com/apache/superset/pull/24397) build(deps): bump pre-commit from 3.3.2 to 3.3.3 in /requirements (@dependabot[bot])
- [#24453](https://github.com/apache/superset/pull/24453) build(deps-dev): bump @typescript-eslint/parser from 5.59.11 to 5.60.0 in /superset-websocket (@dependabot[bot])
- [#24262](https://github.com/apache/superset/pull/24262) chore: Enable CSP by default (@kgabryje)
- [#23853](https://github.com/apache/superset/pull/23853) chore: Migrate warm up cache endpoint to api v1 (@jfrag1)
- [#24331](https://github.com/apache/superset/pull/24331) chore(dao): Organize DAOs according to SIP-92 (@john-bodley)
- [#23835](https://github.com/apache/superset/pull/23835) docs: Show clickable link instead of code-formatting (@rusackas)
- [#24437](https://github.com/apache/superset/pull/24437) chore: toning down grayscale on X icon (@mistercrunch)
- [#24415](https://github.com/apache/superset/pull/24415) chore: Remove obsolete Druid NoSQL REGEX operator (@john-bodley)
- [#24419](https://github.com/apache/superset/pull/24419) build(deps): bump tox from 4.6.0 to 4.6.1 in /requirements (@dependabot[bot])
- [#24378](https://github.com/apache/superset/pull/24378) build(deps-dev): bump @types/node from 20.2.5 to 20.3.1 in /superset-websocket (@dependabot[bot])
- [#24403](https://github.com/apache/superset/pull/24403) chore: cleanup sqlalchemy warnings (@mistercrunch)
- [#24430](https://github.com/apache/superset/pull/24430) chore(ci): make eslint and jest run in --quiet mode (@mistercrunch)
- [#24423](https://github.com/apache/superset/pull/24423) chore: remove deprecated apis /slice_json/ and /annotation_json/ (@dpgaspar)
- [#24400](https://github.com/apache/superset/pull/24400) chore: remove deprecated apis and ENABLE_BROAD_ACTIVITY_ACCESS (@dpgaspar)
- [#24393](https://github.com/apache/superset/pull/24393) docs: Restyle documentation landing page and community page (@thiagorossener)
- [#24401](https://github.com/apache/superset/pull/24401) chore: Remove previously deprecated dataset metrics column from RESTful API (@john-bodley)
- [#24375](https://github.com/apache/superset/pull/24375) chore: remove deprecated apis on superset, get_or_create_table, sqllab_viz (@dpgaspar)
- [#24379](https://github.com/apache/superset/pull/24379) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.9 to 5.59.11 in /superset-websocket (@dependabot[bot])
- [#24310](https://github.com/apache/superset/pull/24310) chore: Update GitHub issue templates (@john-bodley)
- [#24365](https://github.com/apache/superset/pull/24365) build(deps-dev): bump @typescript-eslint/parser from 5.59.8 to 5.59.11 in /superset-websocket (@dependabot[bot])
- [#24360](https://github.com/apache/superset/pull/24360) chore: remove deprecated apis stop_query, queries, search_queries (@dpgaspar)
- [#24353](https://github.com/apache/superset/pull/24353) chore: remove deprecated apis copy_dash, save_dash and add_slices (@dpgaspar)
- [#24198](https://github.com/apache/superset/pull/24198) chore: remove user registrations menu for non-admins (@villebro)
- [#24354](https://github.com/apache/superset/pull/24354) chore: remove deprecated apis on superset, testconn, validate_sql_json, schemas_access_for_file_upload (@dpgaspar)
- [#24381](https://github.com/apache/superset/pull/24381) chore: remove deprecated api /superset/available_domains (@dpgaspar)
- [#24359](https://github.com/apache/superset/pull/24359) chore: remove deprecated apis estimate_query_cost, results, sql_json, csv (@dpgaspar)
- [#24286](https://github.com/apache/superset/pull/24286) build(deps-dev): bump eslint from 8.41.0 to 8.42.0 in /superset-websocket (@dependabot[bot])
- [#24338](https://github.com/apache/superset/pull/24338) build(deps-dev): bump @types/uuid from 9.0.1 to 9.0.2 in /superset-websocket (@dependabot[bot])
- [#24337](https://github.com/apache/superset/pull/24337) build(deps-dev): bump @types/ws from 8.5.4 to 8.5.5 in /superset-websocket (@dependabot[bot])
- [#24362](https://github.com/apache/superset/pull/24362) chore: Disable redux errors (@kgabryje)
- [#24342](https://github.com/apache/superset/pull/24342) chore: remove deprecated api /superset/tables/<int:db_id>/... (@dpgaspar)
- [#24335](https://github.com/apache/superset/pull/24335) chore: remove deprecated api /superset/filter/... (@dpgaspar)
- [#24333](https://github.com/apache/superset/pull/24333) chore: remove deprecated api /superset/datasources (@dpgaspar)
- [#23997](https://github.com/apache/superset/pull/23997) chore(druid): Remove legacy Druid NoSQL logic (@john-bodley)
- [#24330](https://github.com/apache/superset/pull/24330) chore: Removes getUiOverrideRegistry (@michael-s-molina)
- [#24339](https://github.com/apache/superset/pull/24339) docs: Add BurdaForward to "In the Wild" and merge "News" and "Entertainment" to "Media & Entertainment" (@mattitoo)
- [#24082](https://github.com/apache/superset/pull/24082) chore(sqllab): Remove validation result from state (@justinpark)
- [#24322](https://github.com/apache/superset/pull/24322) chore: Deprecates some NVD3 charts in 3.0 (@michael-s-molina)
- [#24313](https://github.com/apache/superset/pull/24313) docs: add link to intro with supported database types (@sfirke)
- [#24312](https://github.com/apache/superset/pull/24312) chore: Remove unused sliceCanEdit logic (@john-bodley)
- [#24299](https://github.com/apache/superset/pull/24299) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.8 to 5.59.9 in /superset-websocket (@dependabot[bot])
- [#24297](https://github.com/apache/superset/pull/24297) build(deps): bump tox from 4.5.2 to 4.6.0 in /requirements (@dependabot[bot])
- [#24295](https://github.com/apache/superset/pull/24295) chore: Adds #24029 breaking change to UPDATING.md (@michael-s-molina)
- [#24288](https://github.com/apache/superset/pull/24288) docs: Adds new permissions from 2.1.0 and fixes some sql_lab permissions (@mattitoo)
- [#24250](https://github.com/apache/superset/pull/24250) chore(build): creating default superset_text.yaml placeholder file (@rusackas)
- [#24118](https://github.com/apache/superset/pull/24118) chore(docs): upgrading docusaurus (fixes header links) (@rusackas)
- [#24110](https://github.com/apache/superset/pull/24110) build(deps): bump pre-commit from 3.3.1 to 3.3.2 in /requirements (@dependabot[bot])
- [#24246](https://github.com/apache/superset/pull/24246) build(deps-dev): bump @typescript-eslint/parser from 5.59.7 to 5.59.8 in /superset-websocket (@dependabot[bot])
- [#24253](https://github.com/apache/superset/pull/24253) docs: fix broken link in the security page (@eltimen)
- [#24251](https://github.com/apache/superset/pull/24251) chore: tests for #24249 (@betodealmeida)
- [#24206](https://github.com/apache/superset/pull/24206) chore(native-filters): Ensure consistent error handling (@john-bodley)
- [#24231](https://github.com/apache/superset/pull/24231) docs: removed extra ` from documentation (@SaishNarvekar)
- [#24235](https://github.com/apache/superset/pull/24235) docs: point the reader to "setup.py" for latest package version (@boenshao)
- [#24245](https://github.com/apache/superset/pull/24245) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.7 to 5.59.8 in /superset-websocket (@dependabot[bot])
- [#24240](https://github.com/apache/superset/pull/24240) build(deps-dev): bump @types/node from 20.2.3 to 20.2.5 in /superset-websocket (@dependabot[bot])
- [#24239](https://github.com/apache/superset/pull/24239) build(deps): bump winston from 3.8.2 to 3.9.0 in /superset-websocket (@dependabot[bot])
- [#24238](https://github.com/apache/superset/pull/24238) build(deps): bump tox from 4.5.1 to 4.5.2 in /requirements (@dependabot[bot])
- [#24214](https://github.com/apache/superset/pull/24214) refactor: Extracts type definitions from ExtensionsRegistry (@michael-s-molina)
- [#24184](https://github.com/apache/superset/pull/24184) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.6 to 5.59.7 in /superset-websocket (@dependabot[bot])
- [#24167](https://github.com/apache/superset/pull/24167) build(deps-dev): bump eslint from 8.40.0 to 8.41.0 in /superset-websocket (@dependabot[bot])
- [#24183](https://github.com/apache/superset/pull/24183) build(deps-dev): bump @typescript-eslint/parser from 5.59.6 to 5.59.7 in /superset-websocket (@dependabot[bot])
- [#24202](https://github.com/apache/superset/pull/24202) chore(ssh): Allow users to set TUNNEL_TIMEOUT from config (@hughhhh)
- [#24026](https://github.com/apache/superset/pull/24026) chore(sqllab): Remove functionNames from sqlLab state (@justinpark)
- [#24045](https://github.com/apache/superset/pull/24045) chore: Bump sqlparse to 0.4.4 (@EugeneTorap)
- [#24168](https://github.com/apache/superset/pull/24168) build(deps-dev): bump @types/node from 20.2.0 to 20.2.3 in /superset-websocket (@dependabot[bot])
- [#24135](https://github.com/apache/superset/pull/24135) chore(sqllab): remove deprecated PyArrow API (@sebastianliebscher)
- [#24128](https://github.com/apache/superset/pull/24128) chore: deprecate rls base related filters (@villebro)
- [#24117](https://github.com/apache/superset/pull/24117) chore: Refactor command exceptions (@john-bodley)
- [#24029](https://github.com/apache/superset/pull/24029) chore: Update QUERY_LOGGER and SQL_QUERY_MUTATOR signatures (@john-bodley)
- [#24107](https://github.com/apache/superset/pull/24107) chore(report): Use for/else clause (@john-bodley)
- [#24111](https://github.com/apache/superset/pull/24111) build(deps-dev): bump @types/node from 20.1.7 to 20.2.0 in /superset-websocket (@dependabot[bot])
- [#23941](https://github.com/apache/superset/pull/23941) build: helm template to set init job annotations (@ybudweiser)
- [#24106](https://github.com/apache/superset/pull/24106) chore: update packages for vanta FE security concerns (@hughhhh)
- [#24087](https://github.com/apache/superset/pull/24087) build(deps-dev): bump @types/node from 20.1.4 to 20.1.7 in /superset-websocket (@dependabot[bot])
- [#22801](https://github.com/apache/superset/pull/22801) chore(thumbnails): change default executor to logged in user (@villebro)
- [#24081](https://github.com/apache/superset/pull/24081) chore(docs): Updating DB connection instructions in 1st Dash instruct… (@rusackas)
- [#22799](https://github.com/apache/superset/pull/22799) chore(reports): change default executor to owner (@villebro)
- [#24073](https://github.com/apache/superset/pull/24073) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.5 to 5.59.6 in /superset-websocket (@dependabot[bot])
- [#24050](https://github.com/apache/superset/pull/24050) chore: add extension for related DB assets on delete (@betodealmeida)
- [#24074](https://github.com/apache/superset/pull/24074) build(deps-dev): bump @typescript-eslint/parser from 5.59.2 to 5.59.6 in /superset-websocket (@dependabot[bot])
- [#24080](https://github.com/apache/superset/pull/24080) chore(docs): tidy up supported DB engines for metadata store (@sfirke)
- [#24079](https://github.com/apache/superset/pull/24079) chore(docs): Updated awkward phrase in FAQ, "force" (@kikobarr)
- [#24069](https://github.com/apache/superset/pull/24069) chore(trino): Bump Trino version to address an IANA time zone issue (@john-bodley)
- [#23581](https://github.com/apache/superset/pull/23581) chore: bump dependencies (@betodealmeida)
- [#24065](https://github.com/apache/superset/pull/24065) build(deps): bump vm2 from 3.9.15 to 3.9.18 in /superset-frontend/cypress-base (@dependabot[bot])
- [#24066](https://github.com/apache/superset/pull/24066) build(deps): bump vm2 from 3.9.17 to 3.9.18 in /superset-frontend (@dependabot[bot])
- [#24058](https://github.com/apache/superset/pull/24058) chore: add log for ssh tunnel information (@hughhhh)
- [#24025](https://github.com/apache/superset/pull/24025) chore(docs): add version for postgres when doing brew install (@rusackas)
- [#24052](https://github.com/apache/superset/pull/24052) build(deps-dev): bump @types/node from 20.1.2 to 20.1.4 in /superset-websocket (@dependabot[bot])
- [#23965](https://github.com/apache/superset/pull/23965) chore: bump werkzeug and Flask (@dpgaspar)
- [#24033](https://github.com/apache/superset/pull/24033) chore: Update mypy and fix stubs issue (@EugeneTorap)
- [#24023](https://github.com/apache/superset/pull/24023) chore: remove duplicates of `validate_adhoc_subquery` (@betodealmeida)
- [#24001](https://github.com/apache/superset/pull/24001) chore: remove deprecated distutils (@sebastianliebscher)
- [#24017](https://github.com/apache/superset/pull/24017) build(deps-dev): bump @types/node from 20.1.1 to 20.1.2 in /superset-websocket (@dependabot[bot])
- [#23756](https://github.com/apache/superset/pull/23756) test: cover empty AdvancedDataTypes internet_address and internet_port (@sebastianliebscher)
- [#23770](https://github.com/apache/superset/pull/23770) chore: fix deprecation warnings for SQLALchemy URL (@sebastianliebscher)
- [#23976](https://github.com/apache/superset/pull/23976) chore: mark explore_json as deprecated in 3.0 (@betodealmeida)
- [#23981](https://github.com/apache/superset/pull/23981) chore: Deprecate DND feature flags (@kgabryje)
- [#23984](https://github.com/apache/superset/pull/23984) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.2 to 5.59.5 in /superset-websocket (@dependabot[bot])
- [#23983](https://github.com/apache/superset/pull/23983) build(deps-dev): bump @types/node from 20.1.0 to 20.1.1 in /superset-websocket (@dependabot[bot])
- [#23951](https://github.com/apache/superset/pull/23951) chore(deps): Add dependency-review action (@rusackas)
- [#23974](https://github.com/apache/superset/pull/23974) chore(actions): adding JavaScript to CodeQL config (@rusackas)
- [#24002](https://github.com/apache/superset/pull/24002) chore: Comment 3.8 PY required CI checks (@EugeneTorap)
- [#23986](https://github.com/apache/superset/pull/23986) chore: Bump python libs (@EugeneTorap)
- [#23994](https://github.com/apache/superset/pull/23994) docs(feature flags): remove the conflicting entry for DRILL_BY (@sfirke)
- [#23760](https://github.com/apache/superset/pull/23760) chore(sqllab): Refactor react-query by redux-toolkit query (@justinpark)
- [#23961](https://github.com/apache/superset/pull/23961) build(deps-dev): bump eslint from 8.39.0 to 8.40.0 in /superset-websocket (@dependabot[bot])
- [#23962](https://github.com/apache/superset/pull/23962) build(deps-dev): bump @types/node from 20.0.0 to 20.1.0 in /superset-websocket (@dependabot[bot])
- [#23744](https://github.com/apache/superset/pull/23744) chore(slack): use recommended method for file upload (@betodealmeida)
- [#23923](https://github.com/apache/superset/pull/23923) chore(helm): Split service templates into separate files (@dnskr)
- [#23936](https://github.com/apache/superset/pull/23936) chore: deprecate /superset/add_slices (@dpgaspar)
- [#23911](https://github.com/apache/superset/pull/23911) docs: fixing a broken markdown link about SSH tunneling (@rusackas)
- [#23949](https://github.com/apache/superset/pull/23949) chore: add codeQL to CI (@dpgaspar)
- [#23947](https://github.com/apache/superset/pull/23947) build(deps-dev): bump @types/node from 18.16.3 to 20.0.0 in /superset-websocket (@dependabot[bot])
- [#23926](https://github.com/apache/superset/pull/23926) chore(helm): Declare missing properties (@dnskr)
- [#23934](https://github.com/apache/superset/pull/23934) chore: Deprecates viz.py (@michael-s-molina)
- [#23795](https://github.com/apache/superset/pull/23795) docs: Add description of standard Superset roles (@mattitoo)
- [#23871](https://github.com/apache/superset/pull/23871) refactor: useEffectEvent for efficient deps (@justinpark)
- [#23913](https://github.com/apache/superset/pull/23913) build(deps): bump pre-commit from 3.2.2 to 3.3.1 in /requirements (@dependabot[bot])
- [#23895](https://github.com/apache/superset/pull/23895) chore(ci): bump actions (@sebastianliebscher)
- [#23841](https://github.com/apache/superset/pull/23841) build(deps-dev): bump @types/jsonwebtoken from 9.0.1 to 9.0.2 in /superset-websocket (@dependabot[bot])
- [#23894](https://github.com/apache/superset/pull/23894) build(deps-dev): bump @typescript-eslint/parser from 5.59.0 to 5.59.2 in /superset-websocket (@dependabot[bot])
- [#23891](https://github.com/apache/superset/pull/23891) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.59.0 to 5.59.2 in /superset-websocket (@dependabot[bot])
- [#23726](https://github.com/apache/superset/pull/23726) chore(helm): Use template comments for the chart license header (@dnskr)
- [#23887](https://github.com/apache/superset/pull/23887) build(deps-dev): bump @types/node from 18.16.0 to 18.16.3 in /superset-websocket (@dependabot[bot])
- [#23849](https://github.com/apache/superset/pull/23849) chore: Add Cypress tests for drill by (@kgabryje)
- [#23680](https://github.com/apache/superset/pull/23680) chore: bump wtforms and add missing flask-limiter (@dpgaspar)
- [#23862](https://github.com/apache/superset/pull/23862) chore: Use nh3 lib instead of bleach (@EugeneTorap)
- [#23844](https://github.com/apache/superset/pull/23844) chore: Bump polyline to 2.0.0 (@EugeneTorap)
- [#23845](https://github.com/apache/superset/pull/23845) chore: Bump redis to 4.5.4 (@EugeneTorap)
- [#23854](https://github.com/apache/superset/pull/23854) chore: Add logging events for drill by (@kgabryje)
- [#23729](https://github.com/apache/superset/pull/23729) chore: migrate `sqllab_viz` endpoint to api v1 (@hughhhh)
- [#23813](https://github.com/apache/superset/pull/23813) chore: Upgrade Cypress to 10.11.0 (@kgabryje)
- [#23794](https://github.com/apache/superset/pull/23794) docs: discourage the use of SQLite (@dpgaspar)
- [#23785](https://github.com/apache/superset/pull/23785) chore: Deprecates 3.0 consented feature flags (@michael-s-molina)
- [#23820](https://github.com/apache/superset/pull/23820) docs: Add Superset Overview Video to README (@satokonak)
- [#23796](https://github.com/apache/superset/pull/23796) docs: cleanup references to `apache-superset/superset-ui` (@charpeni)
- [#22916](https://github.com/apache/superset/pull/22916) chore: Add tests to SQL lab button components (@diegomedina248)
- [#23791](https://github.com/apache/superset/pull/23791) build(deps-dev): bump @types/node from 18.15.13 to 18.16.0 in /superset-websocket (@dependabot[bot])
- [#23790](https://github.com/apache/superset/pull/23790) build(deps-dev): bump eslint from 8.38.0 to 8.39.0 in /superset-websocket (@dependabot[bot])
- [#23789](https://github.com/apache/superset/pull/23789) build(deps-dev): bump prettier from 2.8.7 to 2.8.8 in /superset-websocket (@dependabot[bot])
- [#23798](https://github.com/apache/superset/pull/23798) chore: Add DRILL_BY to FEATURE_FLAGS.md (@kgabryje)
- [#23784](https://github.com/apache/superset/pull/23784) chore: Deprecates FilterBox (@michael-s-molina)
- [#23765](https://github.com/apache/superset/pull/23765) build(deps-dev): bump @types/node from 18.15.12 to 18.15.13 in /superset-websocket (@dependabot[bot])
- [#23772](https://github.com/apache/superset/pull/23772) chore(e2e): skip the worst offender of flaky tests. (@rusackas)
- [#23670](https://github.com/apache/superset/pull/23670) chore(feature flags): updating the status of a few flags (@rusackas)
- [#23704](https://github.com/apache/superset/pull/23704) chore: remove RemovedInMarshmallow4 warnings (@sebastianliebscher)
- [#23759](https://github.com/apache/superset/pull/23759) chore(actions): Fix for Chromatic action using actions/checkout@v3 (@rusackas)
- [#23725](https://github.com/apache/superset/pull/23725) chore(docs): copy change submitted through BugHerd (@rusackas)
- [#23488](https://github.com/apache/superset/pull/23488) refactor(sqllab): Remove tableOptions from redux state (@justinpark)
- [#23746](https://github.com/apache/superset/pull/23746) build(deps-dev): bump @types/node from 18.15.11 to 18.15.12 in /superset-websocket (@dependabot[bot])
- [#23753](https://github.com/apache/superset/pull/23753) build(deps): bump vm2 from 3.9.15 to 3.9.17 in /superset-frontend (@dependabot[bot])
- [#23718](https://github.com/apache/superset/pull/23718) build(deps-dev): bump @typescript-eslint/parser from 5.58.0 to 5.59.0 in /superset-websocket (@dependabot[bot])
- [#23734](https://github.com/apache/superset/pull/23734) chore(chart-data): add post processing error message to response (@villebro)
- [#23678](https://github.com/apache/superset/pull/23678) chore(api v1): Deprecate datasource/save and datasource/get endpoints (@jfrag1)
- [#23714](https://github.com/apache/superset/pull/23714) chore(api v1): Deprecate superset/override_role_permissions endpoint (@jfrag1)
- [#23681](https://github.com/apache/superset/pull/23681) chore(helm): Reformat helm chart templates (@dnskr)
- [#23719](https://github.com/apache/superset/pull/23719) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.58.0 to 5.59.0 in /superset-websocket (@dependabot[bot])
- [#23663](https://github.com/apache/superset/pull/23663) chore: Removes deprecated feature flags for 3.0 (@michael-s-molina)
- [#23683](https://github.com/apache/superset/pull/23683) docs(translations): point broken tutorial link to Internet Archive copy (@sfirke)
- [#23674](https://github.com/apache/superset/pull/23674) chore(presto): Expose schema and indexes to \_partition_query method (@john-bodley)
- [#23609](https://github.com/apache/superset/pull/23609) docs: nvm error while local setup (@Abhishek-kumar-samsung)
- [#23654](https://github.com/apache/superset/pull/23654) chore: Update cross-filter tooltip text (@yousoph)
- [#23651](https://github.com/apache/superset/pull/23651) chore: Removes the UX_BETA feature flag (@michael-s-molina)
- [#23652](https://github.com/apache/superset/pull/23652) chore: Enables GENERIC_CHART_AXES by default (@michael-s-molina)
- [#23656](https://github.com/apache/superset/pull/23656) chore(db_engine_specs): Refactor get_index (@john-bodley)
- [#23460](https://github.com/apache/superset/pull/23460) refactor: introduce redux toolkit (@justinpark)
- [#23642](https://github.com/apache/superset/pull/23642) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.57.1 to 5.58.0 in /superset-websocket (@dependabot[bot])
- [#23643](https://github.com/apache/superset/pull/23643) build(deps-dev): bump @typescript-eslint/parser from 5.57.1 to 5.58.0 in /superset-websocket (@dependabot[bot])
- [#23646](https://github.com/apache/superset/pull/23646) docs: update CHANGELOG with 2.1.0 (@dpgaspar)
- [#23640](https://github.com/apache/superset/pull/23640) chore(feature flag): removing unused ENFORCE_DB_ENCRYPTION_UI flag (@rusackas)
- [#22853](https://github.com/apache/superset/pull/22853) chore: Refactor ExploreMixin to power both Datasets (SqlaTable) and Query models (@hughhhh)
- [#22853](https://github.com/apache/superset/pull/22853) chore: Refactor ExploreMixin to power both Datasets (SqlaTable) and Query models (@hughhhh)
- [#23633](https://github.com/apache/superset/pull/23633) build(deps-dev): bump eslint from 8.36.0 to 8.38.0 in /superset-websocket (@dependabot[bot])
- [#23625](https://github.com/apache/superset/pull/23625) build(deps): bump vm2 from 3.9.14 to 3.9.15 in /superset-frontend/cypress-base (@dependabot[bot])
- [#19733](https://github.com/apache/superset/pull/19733) docs(contributing): add local vscode config for backend debugging (@cemremengu)
- [#23626](https://github.com/apache/superset/pull/23626) build(deps): bump vm2 from 3.9.13 to 3.9.15 in /superset-frontend (@dependabot[bot])
- [#23572](https://github.com/apache/superset/pull/23572) build(deps-dev): bump @typescript-eslint/parser from 5.55.0 to 5.57.1 in /superset-websocket (@dependabot[bot])
- [#23112](https://github.com/apache/superset/pull/23112) chore: Migrate copy_dash endpoint to api v1 (@jfrag1)
- [#23596](https://github.com/apache/superset/pull/23596) chore(deps): bump kind-of dependency (@rusackas)
- [#23595](https://github.com/apache/superset/pull/23595) chore(deps): bumps ansi-regex to 5.0.1 (@rusackas)
- [#23482](https://github.com/apache/superset/pull/23482) refactor: Moves CRUD features to src/features (@michael-s-molina)
- [#23537](https://github.com/apache/superset/pull/23537) docs(security): more context around Talisman, note side effect of force_https on Alerts & Reports (@sfirke)
- [#23573](https://github.com/apache/superset/pull/23573) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.55.0 to 5.57.1 in /superset-websocket (@dependabot[bot])
- [#23518](https://github.com/apache/superset/pull/23518) build(deps-dev): bump @types/node from 18.15.5 to 18.15.11 in /superset-websocket (@dependabot[bot])
- [#23571](https://github.com/apache/superset/pull/23571) build(deps): bump pre-commit from 3.2.0 to 3.2.2 in /requirements (@dependabot[bot])
- [#23496](https://github.com/apache/superset/pull/23496) build(deps-dev): bump prettier from 2.8.6 to 2.8.7 in /superset-websocket (@dependabot[bot])
- [#23544](https://github.com/apache/superset/pull/23544) chore: Remove wrong information from the Alerts & Reports docs (@geido)
- [#22964](https://github.com/apache/superset/pull/22964) chore: Migrate /superset/user_slices and /superset/fave_slices to API v1 (@diegomedina248)
- [#23491](https://github.com/apache/superset/pull/23491) perf(sqla): avoid unnecessary type check on adhoc column (@villebro)
- [#22803](https://github.com/apache/superset/pull/22803) chore(welcome): harmonize submenu with other routes (@villebro)
- [#23527](https://github.com/apache/superset/pull/23527) ci: disable flaky async test (@villebro)
- [#23536](https://github.com/apache/superset/pull/23536) chore: allow logs to show error levels for ssh tunnel (@hughhhh)
- [#23481](https://github.com/apache/superset/pull/23481) chore: Adds a tooltip to pre-filter in native filters modal (@michael-s-molina)
- [#23165](https://github.com/apache/superset/pull/23165) chore: Migrate /superset/favstar to API v1 (@diegomedina248)
- [#23501](https://github.com/apache/superset/pull/23501) docs: Adds notes to Superset plugin generator about TypeScript errors (@alex-bain)
- [#23477](https://github.com/apache/superset/pull/23477) chore: Changes the inputs of native filters modal to have the same width (@michael-s-molina)
- [#23429](https://github.com/apache/superset/pull/23429) chore: Dataset specific MetadataBar (@kgabryje)
- [#23465](https://github.com/apache/superset/pull/23465) perf(postprocessing): improve pivot postprocessing operation (@Usiel)
- [#23420](https://github.com/apache/superset/pull/23420) docs(contributing): How create or change SECRET_KEY (@pankajsoni22)
- [#23437](https://github.com/apache/superset/pull/23437) build(deps-dev): bump eslint-config-prettier from 8.7.0 to 8.8.0 in /superset-websocket (@dependabot[bot])
- [#23257](https://github.com/apache/superset/pull/23257) chore(sqllab): Remove schemaOptions from redux store (@justinpark)
- [#23417](https://github.com/apache/superset/pull/23417) docs(contributing): added note for creating SECRET_KEY (@Govindarajan-D)
- [#23438](https://github.com/apache/superset/pull/23438) build(deps-dev): bump @types/node from 18.15.3 to 18.15.5 in /superset-websocket (@dependabot[bot])
- [#23451](https://github.com/apache/superset/pull/23451) build(deps-dev): bump prettier from 2.8.4 to 2.8.6 in /superset-websocket (@dependabot[bot])
- [#23430](https://github.com/apache/superset/pull/23430) chore: Add DRILL_BY feature flag (@kgabryje)
- [#23398](https://github.com/apache/superset/pull/23398) chore: Update typing for `Table` component (@hughhhh)
- [#23422](https://github.com/apache/superset/pull/23422) build(deps): bump pre-commit from 3.1.0 to 3.2.0 in /requirements (@dependabot[bot])
- [#23342](https://github.com/apache/superset/pull/23342) build(deps-dev): bump eslint from 8.35.0 to 8.36.0 in /superset-websocket (@dependabot[bot])
- [#23431](https://github.com/apache/superset/pull/23431) docs(security): note the need to set TALISMAN_ENABLED = True (@sfirke)
- [#23303](https://github.com/apache/superset/pull/23303) chore(native-filters): Fetch only the required dataset fields (@john-bodley)
- [#23331](https://github.com/apache/superset/pull/23331) chore: update releasing process for testing (@eschutho)
- [#23226](https://github.com/apache/superset/pull/23226) chore: Hugh/migrate estimate query cost to v1 (@hughhhh)
- [#23359](https://github.com/apache/superset/pull/23359) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.53.0 to 5.55.0 in /superset-websocket (@dependabot[bot])
- [#23366](https://github.com/apache/superset/pull/23366) build(deps-dev): bump webpack from 5.52.1 to 5.76.0 in /superset-frontend (@dependabot[bot])
- [#23343](https://github.com/apache/superset/pull/23343) build(deps): bump ws from 8.12.1 to 8.13.0 in /superset-websocket (@dependabot[bot])
- [#23403](https://github.com/apache/superset/pull/23403) chore(docs): three typos (@rusackas)
- [#23385](https://github.com/apache/superset/pull/23385) chore: improve schema security (@betodealmeida)
- [#23368](https://github.com/apache/superset/pull/23368) build(deps-dev): bump webpack from 5.64.0 to 5.76.0 in /docs (@dependabot[bot])
- [#23367](https://github.com/apache/superset/pull/23367) build(deps-dev): bump webpack from 5.67.0 to 5.76.0 in /superset-embedded-sdk (@dependabot[bot])
- [#23379](https://github.com/apache/superset/pull/23379) build(deps-dev): bump @typescript-eslint/parser from 5.54.1 to 5.55.0 in /superset-websocket (@dependabot[bot])
- [#23369](https://github.com/apache/superset/pull/23369) build(deps): bump @sideway/formula from 3.0.0 to 3.0.1 in /docs (@dependabot[bot])
- [#23261](https://github.com/apache/superset/pull/23261) chore(dashboard): Disable 'Set filter mapping' when appropriate (@john-bodley)
- [#23371](https://github.com/apache/superset/pull/23371) chore: Add code-owners to Select, MetadataBar and DropdownContainer (@geido)
- [#23227](https://github.com/apache/superset/pull/23227) chore: Migrate /superset/schemas_access_for_file_upload to v1 (@hughhhh)
- [#23360](https://github.com/apache/superset/pull/23360) build(deps-dev): bump @types/node from 18.14.6 to 18.15.3 in /superset-websocket (@dependabot[bot])
- [#23216](https://github.com/apache/superset/pull/23216) chore: Remove Cross Filter scoping modal (@geido)
- [#23294](https://github.com/apache/superset/pull/23294) build(deps-dev): bump @typescript-eslint/parser from 5.53.0 to 5.54.1 in /superset-websocket (@dependabot[bot])
- [#23323](https://github.com/apache/superset/pull/23323) docs(alerts and reports): Update ExecutorType class (@mrmooon)
- [#23290](https://github.com/apache/superset/pull/23290) chore: log different selenium timeout errors differently (@eschutho)
- [#23316](https://github.com/apache/superset/pull/23316) docs: add lost \_filters param docs (@villebro)
- [#23317](https://github.com/apache/superset/pull/23317) chore: bump docusaurus to latest stable (@villebro)
- [#23281](https://github.com/apache/superset/pull/23281) build(deps-dev): bump @types/node from 18.14.1 to 18.14.6 in /superset-websocket (@dependabot[bot])
- [#23292](https://github.com/apache/superset/pull/23292) build(deps-dev): bump eslint-config-prettier from 8.6.0 to 8.7.0 in /superset-websocket (@dependabot[bot])
- [#23166](https://github.com/apache/superset/pull/23166) docs: typo 'admnistrators' in security.mdx (@camac)
- [#22890](https://github.com/apache/superset/pull/22890) chore: upgrade @ant-design/icons for react upgrade (@lilykuang)
- [#23266](https://github.com/apache/superset/pull/23266) chore(cache): Tuning logging in cache manager (@craig-rueda)
- [#23255](https://github.com/apache/superset/pull/23255) chore(webdriver): Tuning the Webdriver logging a bit (@craig-rueda)
- [#23142](https://github.com/apache/superset/pull/23142) chore: Remove the ability to add filter-box charts when DASHBOARD_NATIVE_FILTERS feature is enabled (@john-bodley)
- [#23241](https://github.com/apache/superset/pull/23241) refactor: Organizes the pages in their own folder (@michael-s-molina)
- [#23122](https://github.com/apache/superset/pull/23122) build(deps): bump pip-compile-multi from 2.6.1 to 2.6.2 in /requirements (@dependabot[bot])
- [#23225](https://github.com/apache/superset/pull/23225) chore: Add statsd logger for ssh tunneling creation (@hughhhh)
- [#23168](https://github.com/apache/superset/pull/23168) build(deps): bump pre-commit from 3.0.4 to 3.1.0 in /requirements (@dependabot[bot])
- [#22859](https://github.com/apache/superset/pull/22859) build(deps): bump ua-parser-js from 0.7.28 to 0.7.33 in /superset-frontend (@dependabot[bot])
- [#23201](https://github.com/apache/superset/pull/23201) chore: adding code owners for github actions/workflows (@rusackas)
- [#23211](https://github.com/apache/superset/pull/23211) build(deps-dev): bump eslint from 8.34.0 to 8.35.0 in /superset-websocket (@dependabot[bot])
- [#23152](https://github.com/apache/superset/pull/23152) build(deps-dev): bump @types/uuid from 9.0.0 to 9.0.1 in /superset-websocket (@dependabot[bot])
- [#23207](https://github.com/apache/superset/pull/23207) docs: fix typo (@vivekDebugs)
- [#22342](https://github.com/apache/superset/pull/22342) build(deps): bump express and @applitools/eyes-cypress in /superset-frontend/cypress-base (@dependabot[bot])
- [#23132](https://github.com/apache/superset/pull/23132) build(deps-dev): bump @typescript-eslint/eslint-plugin from 5.52.0 to 5.53.0 in /superset-websocket (@dependabot[bot])
- [#23203](https://github.com/apache/superset/pull/23203) test: Remove test playgrounds (@lyndsiWilliams)
- [#23180](https://github.com/apache/superset/pull/23180) build(deps-dev): bump @types/node from 18.13.0 to 18.14.1 in /superset-websocket (@dependabot[bot])
- [#23133](https://github.com/apache/superset/pull/23133) build(deps-dev): bump @typescript-eslint/parser from 5.51.0 to 5.53.0 in /superset-websocket (@dependabot[bot])
- [#23145](https://github.com/apache/superset/pull/23145) chore: refactor SparklineCell for react 17 and react 18 upgrade (@lilykuang)
- [#23160](https://github.com/apache/superset/pull/23160) build: Add helm chart option to deploy sidecars with node and worker (@mkramer5454)
- [#23144](https://github.com/apache/superset/pull/23144) chore: revert "feat(native_filter_migration): add transition mode (#16992)" (@john-bodley)
- [#23158](https://github.com/apache/superset/pull/23158) chore: Bump cryptography to 39.0.1 (@EugeneTorap)
- [#23108](https://github.com/apache/superset/pull/23108) chore: Remove yarn.lock from the root folder (@EugeneTorap)
