/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import org.apache.sysds.parser.Statement;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.BalanceToAvgFederatedScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DataPartitionFederatedScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.KeepDataOnWorkerFederatedScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.ReplicateToMaxFederatedScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.ShuffleFederatedScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.SubsampleToMinFederatedScheme;

public class FederatedDataPartitioner {
    private final DataPartitionFederatedScheme _scheme;
    private final int _seed;

    public FederatedDataPartitioner(Statement.FederatedPSScheme scheme, int seed) {
        this._seed = seed;
        switch (scheme) {
            case KEEP_DATA_ON_WORKER: {
                this._scheme = new KeepDataOnWorkerFederatedScheme();
                break;
            }
            case SHUFFLE: {
                this._scheme = new ShuffleFederatedScheme();
                break;
            }
            case REPLICATE_TO_MAX: {
                this._scheme = new ReplicateToMaxFederatedScheme();
                break;
            }
            case SUBSAMPLE_TO_MIN: {
                this._scheme = new SubsampleToMinFederatedScheme();
                break;
            }
            case BALANCE_TO_AVG: {
                this._scheme = new BalanceToAvgFederatedScheme();
                break;
            }
            default: {
                throw new DMLRuntimeException(String.format("FederatedDataPartitioner: not support data partition scheme '%s'", new Object[]{scheme}));
            }
        }
    }

    public DataPartitionFederatedScheme.Result doPartitioning(MatrixObject features, MatrixObject labels) {
        return this._scheme.partition(features, labels, this._seed);
    }
}

