/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.DnnOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LeftIndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class HopRewriteUtils {
    private static final Log LOG = LogFactory.getLog((String)HopRewriteUtils.class.getName());

    public static boolean isValueTypeCast(Types.OpOp1 op) {
        return op == Types.OpOp1.CAST_AS_BOOLEAN || op == Types.OpOp1.CAST_AS_INT || op == Types.OpOp1.CAST_AS_DOUBLE;
    }

    public static boolean getBooleanValue(LiteralOp op) {
        switch (op.getValueType()) {
            case FP64: {
                return op.getDoubleValue() != 0.0;
            }
            case INT64: {
                return op.getLongValue() != 0L;
            }
            case BOOLEAN: {
                return op.getBooleanValue();
            }
        }
        throw new HopsException("Invalid boolean value: " + op.getValueType());
    }

    public static boolean getBooleanValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case FP64: {
                    return op.getDoubleValue() != 0.0;
                }
                case INT64: {
                    return op.getLongValue() != 0L;
                }
                case BOOLEAN: {
                    return op.getBooleanValue();
                }
            }
            throw new HopsException("Invalid boolean value: " + op.getValueType());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double getDoubleValue(LiteralOp op) {
        switch (op.getValueType()) {
            case FP64: 
            case STRING: {
                return op.getDoubleValue();
            }
            case INT64: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1.0 : 0.0;
            }
        }
        throw new HopsException("Invalid double value: " + op.getValueType());
    }

    public static double getDoubleValueSafe(LiteralOp op) {
        switch (op.getValueType()) {
            case FP64: {
                return op.getDoubleValue();
            }
            case INT64: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1.0 : 0.0;
            }
        }
        return Double.MAX_VALUE;
    }

    public static long getIntValue(LiteralOp op) {
        switch (op.getValueType()) {
            case FP64: {
                return UtilFunctions.toLong(op.getDoubleValue());
            }
            case INT64: 
            case STRING: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1L : 0L;
            }
        }
        throw new HopsException("Invalid int value: " + op.getValueType());
    }

    public static long getIntValueSafe(Hop op) {
        return HopRewriteUtils.getIntValueSafe((LiteralOp)op);
    }

    public static long getIntValueSafe(LiteralOp op) {
        switch (op.getValueType()) {
            case FP64: {
                return UtilFunctions.toLong(op.getDoubleValue());
            }
            case INT64: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1L : 0L;
            }
        }
        return Long.MAX_VALUE;
    }

    public static boolean isLiteralOfValue(Hop hop, Double ... val) {
        return Arrays.stream(val).anyMatch(d -> HopRewriteUtils.isLiteralOfValue(hop, (double)d));
    }

    public static boolean isLiteralOfValue(Hop hop, double val) {
        return hop instanceof LiteralOp && (hop.getValueType() == Types.ValueType.FP64 || hop.getValueType() == Types.ValueType.INT64) && HopRewriteUtils.getDoubleValueSafe((LiteralOp)hop) == val;
    }

    public static boolean isLiteralOfValue(Hop hop, String val) {
        return hop instanceof LiteralOp && ((LiteralOp)hop).getStringValue().equals(val);
    }

    public static boolean isLiteralOfValue(Hop hop, boolean val) {
        try {
            return hop instanceof LiteralOp && hop.getValueType() == Types.ValueType.BOOLEAN && ((LiteralOp)hop).getBooleanValue() == val;
        }
        catch (HopsException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ScalarObject getScalarObject(LiteralOp op) {
        try {
            return ScalarObjectFactory.createScalarObject(op.getValueType(), op);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create scalar object for constant. Continue.", ex);
        }
    }

    public static int getChildReferencePos(Hop parent, Hop child) {
        return parent.getInput().indexOf(child);
    }

    public static void removeChildReference(Hop parent, Hop child) {
        parent.getInput().remove(child);
        child.getParent().remove(parent);
    }

    public static void removeChildReferenceByPos(Hop parent, Hop child, int posChild) {
        parent.getInput().remove(posChild);
        child.getParent().remove(parent);
    }

    public static void removeAllChildReferences(Hop parent) {
        for (Hop child : parent.getInput()) {
            child.getParent().remove(parent);
        }
        parent.getInput().clear();
    }

    public static void addChildReference(Hop parent, Hop child) {
        parent.getInput().add(child);
        child.getParent().add(parent);
    }

    public static void addChildReference(Hop parent, Hop child, int pos) {
        parent.getInput().add(pos, child);
        child.getParent().add(parent);
    }

    public static Hop rewireAllParentChildReferences(Hop hold, Hop hnew) {
        List<Hop> parents = hold.getParent();
        while (!parents.isEmpty()) {
            HopRewriteUtils.replaceChildReference(parents.get(0), hold, hnew);
        }
        return hnew;
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew) {
        int pos = HopRewriteUtils.getChildReferencePos(parent, inOld);
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        parent.refreshSizeInformation();
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos) {
        HopRewriteUtils.replaceChildReference(parent, inOld, inNew, pos, true);
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos, boolean refresh) {
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        if (refresh) {
            parent.refreshSizeInformation();
        }
    }

    public static void cleanupUnreferenced(Hop ... inputs) {
        for (Hop input : inputs) {
            if (!input.getParent().isEmpty()) continue;
            HopRewriteUtils.removeAllChildReferences(input);
        }
    }

    public static Hop getOtherInput(Hop hop, Hop input) {
        for (Hop c : hop.getInput()) {
            if (c == input) continue;
            return c;
        }
        return null;
    }

    public static Hop getLargestInput(Hop hop) {
        return hop.getInput().stream().max(Comparator.comparing(h -> h.getLength())).orElse(null);
    }

    public static Hop createDataGenOp(Hop input, double value) {
        Hop rows = input.rowsKnown() ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NROW, input);
        Hop cols = input.colsKnown() ? new LiteralOp(input.getDim2()) : new UnaryOp("tmpcols", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NCOL, input);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
        datagen.setBlocksize(input.getBlocksize());
        HopRewriteUtils.copyLineNumbers(input, (Hop)datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static DataGenOp copyDataGenOp(DataGenOp inputGen, double scale, double shift) {
        HashMap<String, Integer> params = inputGen.getParamIndexMap();
        Hop min = inputGen.getInput().get(params.get("min"));
        Hop max = inputGen.getInput().get(params.get("max"));
        Hop pdf = inputGen.getInput().get(params.get("pdf"));
        Hop mean = inputGen.getInput().get(params.get("lambda"));
        Hop sparsity = inputGen.getInput().get(params.get("sparsity"));
        Hop seed = inputGen.getInput().get(params.get("seed"));
        if (!(min instanceof LiteralOp) || !(max instanceof LiteralOp)) {
            return null;
        }
        double smin = HopRewriteUtils.getDoubleValue((LiteralOp)min);
        double smax = HopRewriteUtils.getDoubleValue((LiteralOp)max);
        smin = smin * scale + shift;
        smax = smax * scale + shift;
        LiteralOp sminHop = new LiteralOp(smin);
        LiteralOp smaxHop = new LiteralOp(smax);
        HashMap<String, Hop> params2 = new HashMap<String, Hop>();
        if (!params.containsKey("dims")) {
            Hop rows = inputGen.getInput().get(params.get("rows"));
            Hop cols = inputGen.getInput().get(params.get("cols"));
            params2.put("rows", rows);
            params2.put("cols", cols);
        } else {
            Hop dims = inputGen.getInput().get(params.get("dims"));
            params2.put("dims", dims);
        }
        params2.put("min", sminHop);
        params2.put("max", smaxHop);
        params2.put("pdf", pdf);
        params2.put("lambda", mean);
        params2.put("sparsity", sparsity);
        params2.put("seed", seed);
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params2);
        datagen.setBlocksize(inputGen.getBlocksize());
        HopRewriteUtils.copyLineNumbers(inputGen, (Hop)datagen);
        if (smin == 0.0 && smax == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, Hop colInput, double value) {
        Hop rows = rowInput.rowsKnown() ? new LiteralOp(rowInput.getDim1()) : new UnaryOp("tmprows", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NROW, rowInput);
        Hop cols = colInput.colsKnown() ? new LiteralOp(colInput.getDim2()) : new UnaryOp("tmpcols", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
        datagen.setBlocksize(rowInput.getBlocksize());
        HopRewriteUtils.copyLineNumbers(rowInput, (Hop)datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, boolean tRowInput, Hop colInput, boolean tColInput, double value) {
        Hop rows;
        long ncol;
        long nrow = tRowInput ? rowInput.getDim2() : rowInput.getDim1();
        long l = ncol = tColInput ? colInput.getDim1() : rowInput.getDim2();
        Hop hop = nrow >= 0L ? new LiteralOp(nrow) : (rows = new UnaryOp("tmprows", Types.DataType.SCALAR, Types.ValueType.INT64, tRowInput ? Types.OpOp1.NCOL : Types.OpOp1.NROW, rowInput));
        Hop cols = ncol >= 0L ? new LiteralOp(ncol) : new UnaryOp("tmpcols", Types.DataType.SCALAR, Types.ValueType.INT64, tColInput ? Types.OpOp1.NROW : Types.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, new DataIdentifier("tmp"), params);
        datagen.setBlocksize(colInput.getBlocksize());
        HopRewriteUtils.copyLineNumbers(rowInput, (Hop)datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOpByVal(Hop rowInput, Hop colInput, Hop dimsInput, Types.DataType dt, Types.ValueType vt, double value) {
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        if (dt.isTensor()) {
            params.put("dims", dimsInput);
        } else {
            params.put("rows", rowInput);
            params.put("cols", colInput);
        }
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataIdentifier di = new DataIdentifier("tmp");
        di.setDataType(dt);
        di.setValueType(vt);
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.RAND, di, params);
        datagen.setBlocksize(rowInput.getBlocksize());
        HopRewriteUtils.copyLineNumbers(rowInput, (Hop)datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOpByVal(List<LiteralOp> values, long rows, long cols) {
        StringBuilder sb = new StringBuilder();
        for (LiteralOp lit : values) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(lit.getStringValue());
        }
        LiteralOp str = new LiteralOp(sb.toString());
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", new LiteralOp(rows));
        params.put("cols", new LiteralOp(cols));
        params.put("min", str);
        params.put("max", str);
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.SINIT, new DataIdentifier("tmp", Types.DataType.MATRIX), params);
        datagen.setBlocksize(ConfigurationManager.getBlocksize());
        HopRewriteUtils.copyLineNumbers(values.get(0), (Hop)datagen);
        return datagen;
    }

    public static boolean isDataGenOp(Hop hop, Types.OpOpDG ... ops) {
        return hop instanceof DataGenOp && ArrayUtils.contains((Object[])ops, (Object)((Object)((DataGenOp)hop).getOp()));
    }

    public static boolean isDataGenOpWithLiteralInputs(Hop hop, Types.OpOpDG ... ops) {
        boolean ret = HopRewriteUtils.isDataGenOp(hop, ops);
        for (Hop c : hop.getInput()) {
            ret &= c instanceof LiteralOp;
        }
        return ret;
    }

    public static boolean isDataGenOpWithConstantValue(Hop hop) {
        return hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Types.OpOpDG.RAND && ((DataGenOp)hop).hasConstantValue();
    }

    public static boolean isDataGenOpWithConstantValue(Hop hop, double value) {
        return hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Types.OpOpDG.RAND && ((DataGenOp)hop).hasConstantValue(value);
    }

    public static boolean isDataGenOpWithNonDeterminism(Hop hop) {
        if (!HopRewriteUtils.isDataGenOp(hop, Types.OpOpDG.RAND, Types.OpOpDG.SAMPLE)) {
            return false;
        }
        return HopRewriteUtils.isDataGenOp(hop, Types.OpOpDG.SAMPLE) || HopRewriteUtils.isDataGenOp(hop, Types.OpOpDG.RAND) && !((DataGenOp)hop).hasConstantValue() && ((DataGenOp)hop).hasUnspecifiedSeed();
    }

    public static Hop getDataGenOpConstantValue(Hop hop) {
        return ((DataGenOp)hop).getConstantValue();
    }

    public static DataOp createTransientRead(String name, Hop h) {
        DataOp tread = new DataOp(name, h.getDataType(), h.getValueType(), Types.OpOpData.TRANSIENTREAD, null, h.getDim1(), h.getDim2(), h.getNnz(), h.getUpdateType(), h.getBlocksize());
        tread.setVisited();
        HopRewriteUtils.copyLineNumbers(h, (Hop)tread);
        return tread;
    }

    public static DataOp createTransientRead(String name, MatrixBlock mb) {
        DataOp tread = new DataOp(name, Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOpData.TRANSIENTREAD, null, mb.getNumRows(), mb.getNumColumns(), mb.getNonZeros(), MatrixObject.UpdateType.COPY, ConfigurationManager.getBlocksize());
        tread.setVisited();
        HopRewriteUtils.copyLineNumbers(mb, (Hop)tread);
        tread.setFileName(name);
        return tread;
    }

    public static DataOp createTransientRead(String name, MatrixObject mo) {
        DataOp tread = new DataOp(name, Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOpData.TRANSIENTREAD, null, mo.getNumRows(), mo.getNumColumns(), mo.getNnz(), MatrixObject.UpdateType.COPY, mo.getBlocksize());
        tread.setVisited();
        HopRewriteUtils.copyLineNumbers(mo, (Hop)tread);
        tread.setFileName(name);
        return tread;
    }

    public static DataOp createTransientWrite(String name, Hop in) {
        return HopRewriteUtils.createDataOp(name, in, Types.OpOpData.TRANSIENTWRITE);
    }

    public static DataOp createDataOp(String name, Hop in, Types.OpOpData type) {
        DataOp dop = new DataOp(name, in.getDataType(), in.getValueType(), in, type, null);
        dop.setVisited();
        dop.setOutputParams(in.getDim1(), in.getDim2(), in.getNnz(), in.getUpdateType(), in.getBlocksize());
        HopRewriteUtils.copyLineNumbers(in, (Hop)dop);
        return dop;
    }

    public static ReorgOp createTranspose(Hop input) {
        return HopRewriteUtils.createReorg(input, Types.ReOrgOp.TRANS);
    }

    public static ReorgOp createReorg(Hop input, String rop) {
        return HopRewriteUtils.createReorg(input, Types.ReOrgOp.valueOfByOpcode(rop));
    }

    public static ReorgOp createReorg(Hop input, Types.ReOrgOp rop) {
        ReorgOp reorg = new ReorgOp(input.getName(), input.getDataType(), input.getValueType(), rop, input);
        reorg.setBlocksize(input.getBlocksize());
        HopRewriteUtils.copyLineNumbers(input, (Hop)reorg);
        reorg.refreshSizeInformation();
        return reorg;
    }

    public static ReorgOp createReorg(List<Hop> inputs, Types.ReOrgOp rop) {
        Hop main = inputs.get(0);
        ReorgOp reorg = new ReorgOp(main.getName(), main.getDataType(), main.getValueType(), rop, inputs);
        reorg.setBlocksize(main.getBlocksize());
        HopRewriteUtils.copyLineNumbers(main, (Hop)reorg);
        reorg.refreshSizeInformation();
        return reorg;
    }

    public static UnaryOp createUnary(Hop input, String type) {
        return HopRewriteUtils.createUnary(input, Types.OpOp1.valueOfByOpcode(type));
    }

    public static UnaryOp createUnary(Hop input, Types.OpOp1 type) {
        Types.DataType dt = type.isScalarOutput() ? Types.DataType.SCALAR : (type == Types.OpOp1.CAST_AS_MATRIX ? Types.DataType.MATRIX : input.getDataType());
        Types.ValueType vt = input.getValueType();
        switch (type) {
            case CAST_AS_MATRIX: 
            case CAST_AS_DOUBLE: {
                vt = Types.ValueType.FP64;
                break;
            }
            case CAST_AS_INT: {
                vt = Types.ValueType.INT64;
                break;
            }
            case CAST_AS_BOOLEAN: {
                vt = Types.ValueType.BOOLEAN;
            }
        }
        UnaryOp unary = new UnaryOp(input.getName(), dt, vt, type, input);
        unary.setBlocksize(input.getBlocksize());
        if (type.isScalarOutput() || type == Types.OpOp1.CAST_AS_MATRIX) {
            int dim = type.isScalarOutput() ? 0 : 1;
            int blksz = type == Types.OpOp1.CAST_AS_SCALAR ? 0 : ConfigurationManager.getBlocksize();
            HopRewriteUtils.setOutputParameters(unary, dim, dim, blksz, -1L);
        }
        HopRewriteUtils.copyLineNumbers(input, (Hop)unary);
        unary.refreshSizeInformation();
        return unary;
    }

    public static BinaryOp createBinaryMinus(Hop input) {
        return HopRewriteUtils.createBinary((Hop)new LiteralOp(0L), input, Types.OpOp2.MINUS);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, String op) {
        return HopRewriteUtils.createBinary(input1, input2, Types.OpOp2.valueOfByOpcode(op), false);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, Types.OpOp2 op) {
        return HopRewriteUtils.createBinary(input1, input2, op, false);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, Types.OpOp2 op, boolean outer) {
        Hop mainInput = input1.getDataType().isMatrix() ? input1 : (input2.getDataType().isMatrix() ? input2 : input1);
        Hop otherInput = mainInput == input1 ? input2 : input1;
        BinaryOp bop = new BinaryOp(mainInput.getName(), mainInput.getDataType(), mainInput.getValueType(), op, input1, input2);
        if (otherInput.getValueType().isFP() && !mainInput.getValueType().isFP()) {
            bop.setValueType(otherInput.getValueType());
        }
        if (bop.isPPredOperation() && bop.getDataType().isScalar()) {
            bop.setValueType(Types.ValueType.BOOLEAN);
        }
        if (bop.getDataType().isMatrix()) {
            bop.setValueType(Types.ValueType.FP64);
        }
        bop.setOuterVectorOperation(outer);
        bop.setBlocksize(mainInput.getBlocksize());
        HopRewriteUtils.copyLineNumbers(mainInput, (Hop)bop);
        bop.refreshSizeInformation();
        return bop;
    }

    public static AggUnaryOp createSum(Hop input) {
        return HopRewriteUtils.createAggUnaryOp(input, Types.AggOp.SUM, Types.Direction.RowCol);
    }

    public static AggUnaryOp createAggUnaryOp(Hop input, String op) {
        return HopRewriteUtils.createAggUnaryOp(input, InstructionUtils.getAggOp(op), InstructionUtils.getAggDirection(op));
    }

    public static AggUnaryOp createAggUnaryOp(Hop input, Types.AggOp op, Types.Direction dir) {
        Types.DataType dt = dir == Types.Direction.RowCol ? Types.DataType.SCALAR : input.getDataType();
        AggUnaryOp auop = new AggUnaryOp(input.getName(), dt, input.getValueType(), op, dir, input);
        auop.setBlocksize(input.getBlocksize());
        HopRewriteUtils.copyLineNumbers(input, (Hop)auop);
        auop.refreshSizeInformation();
        return auop;
    }

    public static AggBinaryOp createTsmm(Hop input, boolean left) {
        ReorgOp trans = HopRewriteUtils.createTranspose(input);
        return HopRewriteUtils.createMatrixMultiply(left ? trans : input, left ? input : trans);
    }

    public static AggBinaryOp createMatrixMultiply(Hop left, Hop right) {
        AggBinaryOp mmult = new AggBinaryOp(left.getName(), left.getDataType(), left.getValueType(), Types.OpOp2.MULT, Types.AggOp.SUM, left, right);
        mmult.setBlocksize(left.getBlocksize());
        HopRewriteUtils.copyLineNumbers(left, (Hop)mmult);
        mmult.refreshSizeInformation();
        return mmult;
    }

    public static ParameterizedBuiltinOp createParameterizedBuiltinOp(Hop input, LinkedHashMap<String, Hop> args, Types.ParamBuiltinOp op) {
        Types.DataType dt = op == Types.ParamBuiltinOp.TOSTRING ? Types.DataType.SCALAR : Types.DataType.MATRIX;
        Types.ValueType vt = op == Types.ParamBuiltinOp.TOSTRING ? Types.ValueType.STRING : Types.ValueType.FP64;
        ParameterizedBuiltinOp pbop = new ParameterizedBuiltinOp("tmp", dt, vt, op, args);
        pbop.setBlocksize(input.getBlocksize());
        HopRewriteUtils.copyLineNumbers(input, (Hop)pbop);
        pbop.refreshSizeInformation();
        return pbop;
    }

    public static Hop createScalarIndexing(Hop input, long rix, long cix) {
        IndexingOp ix = HopRewriteUtils.createIndexingOp(input, rix, cix);
        return HopRewriteUtils.createUnary((Hop)ix, Types.OpOp1.CAST_AS_SCALAR);
    }

    public static IndexingOp createIndexingOp(Hop input, Hop batchsize) {
        LiteralOp rl = new LiteralOp(1L);
        LiteralOp cl = new LiteralOp(1L);
        UnaryOp cu = HopRewriteUtils.createUnary(input, Types.OpOp1.NCOL);
        return HopRewriteUtils.createIndexingOp(input, rl, batchsize, cl, cu);
    }

    public static IndexingOp createIndexingOp(Hop input, long rix, long cix) {
        LiteralOp row = new LiteralOp(rix);
        LiteralOp col = new LiteralOp(cix);
        return HopRewriteUtils.createIndexingOp(input, row, row, col, col);
    }

    public static IndexingOp createIndexingOp(Hop input, long rl, long ru, long cl, long cu) {
        return HopRewriteUtils.createIndexingOp(input, new LiteralOp(rl), new LiteralOp(ru), new LiteralOp(cl), new LiteralOp(cu));
    }

    public static IndexingOp createIndexingOp(Hop input, Hop rl, Hop ru, Hop cl, Hop cu) {
        IndexingOp ix = new IndexingOp("tmp", Types.DataType.MATRIX, Types.ValueType.FP64, input, rl, ru, cl, cu, rl == ru, cl == cu);
        ix.setBlocksize(input.getBlocksize());
        HopRewriteUtils.copyLineNumbers(input, (Hop)ix);
        ix.refreshSizeInformation();
        return ix;
    }

    public static LeftIndexingOp createLeftIndexingOp(Hop lhs, Hop rhs, Hop rl, Hop ru, Hop cl, Hop cu) {
        LeftIndexingOp ix = new LeftIndexingOp("tmp", Types.DataType.MATRIX, Types.ValueType.FP64, lhs, rhs, rl, ru, cl, cu, rl == ru, cl == cu);
        ix.setBlocksize(lhs.getBlocksize());
        HopRewriteUtils.copyLineNumbers(lhs, (Hop)ix);
        ix.refreshSizeInformation();
        return ix;
    }

    public static NaryOp createNary(Types.OpOpN op, Hop ... inputs) {
        Hop mainInput = inputs[0];
        boolean containsMatrix = Arrays.stream(inputs).anyMatch(Hop::isMatrix);
        boolean containsFP64 = Arrays.stream(inputs).anyMatch(h -> h.getValueType() == Types.ValueType.FP64);
        Types.DataType dtOut = containsMatrix ? Types.DataType.MATRIX : mainInput.getDataType();
        Types.ValueType vtOut = containsFP64 ? Types.ValueType.FP64 : mainInput.getValueType();
        NaryOp nop = new NaryOp(mainInput.getName(), dtOut, vtOut, op, inputs);
        nop.setBlocksize(mainInput.getBlocksize());
        HopRewriteUtils.copyLineNumbers(mainInput, (Hop)nop);
        nop.refreshSizeInformation();
        return nop;
    }

    public static Hop createValueHop(Hop hop, boolean row) {
        Hop ret = null;
        ret = row ? (hop.rowsKnown() ? new LiteralOp(hop.getDim1()) : new UnaryOp("tmprows", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NROW, hop)) : (hop.colsKnown() ? new LiteralOp(hop.getDim2()) : new UnaryOp("tmpcols", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NCOL, hop));
        return ret;
    }

    public static DataGenOp createSeqDataGenOp(Hop input) {
        return HopRewriteUtils.createSeqDataGenOp(input, true);
    }

    public static DataGenOp createSeqDataGenOp(Hop input, boolean asc) {
        Hop to;
        Hop hop = to = input.rowsKnown() ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NROW, input);
        if (asc) {
            return HopRewriteUtils.createSeqDataGenOp(input, new LiteralOp(1L), to, new LiteralOp(1L));
        }
        return HopRewriteUtils.createSeqDataGenOp(input, to, new LiteralOp(1L), new LiteralOp(-1L));
    }

    public static DataGenOp createSeqDataGenOp(Hop proxy, Hop from, Hop to, Hop incr) {
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("from", from);
        params.put("to", to);
        params.put("incr", incr);
        DataGenOp datagen = new DataGenOp(Types.OpOpDG.SEQ, new DataIdentifier("tmp"), params);
        datagen.setBlocksize(proxy.getBlocksize());
        HopRewriteUtils.copyLineNumbers(proxy, (Hop)datagen);
        return datagen;
    }

    public static TernaryOp createTernary(Hop mleft, Hop smid, Hop mright, String opcode) {
        return HopRewriteUtils.createTernary(mleft, smid, mright, Types.OpOp3.valueOfByOpcode(opcode));
    }

    public static TernaryOp createTernary(Hop mleft, Hop smid, Hop mright, Types.OpOp3 op) {
        Types.DataType dt = op == Types.OpOp3.IFELSE ? mright.getDataType() : Types.DataType.MATRIX;
        Types.ValueType vt = op == Types.OpOp3.IFELSE ? mright.getValueType() : Types.ValueType.FP64;
        TernaryOp ternOp = new TernaryOp("tmp", dt, vt, op, mleft, smid, mright);
        ternOp.setBlocksize(Math.max(mleft.getBlocksize(), mright.getBlocksize()));
        HopRewriteUtils.copyLineNumbers(mleft, (Hop)ternOp);
        ternOp.refreshSizeInformation();
        return ternOp;
    }

    public static TernaryOp createTernary(Hop in1, Hop in2, Hop in3, Hop in4, Hop in5, Types.OpOp3 op) {
        TernaryOp ternOp = new TernaryOp("tmp", Types.DataType.MATRIX, Types.ValueType.FP64, op, in1, in2, in3, in4, in5, new LiteralOp(true));
        ternOp.setBlocksize(Math.max(in1.getBlocksize(), in2.getBlocksize()));
        HopRewriteUtils.copyLineNumbers(in1, (Hop)ternOp);
        ternOp.refreshSizeInformation();
        return ternOp;
    }

    public static Hop createComputeNnz(Hop input) {
        return HopRewriteUtils.createSum(HopRewriteUtils.createBinary(input, (Hop)new LiteralOp(0L), Types.OpOp2.NOTEQUAL));
    }

    public static void setOutputParameters(Hop hop, long rlen, long clen, int blen, long nnz) {
        hop.setDim1(rlen);
        hop.setDim2(clen);
        hop.setBlocksize(blen);
        hop.setNnz(nnz);
    }

    public static void setOutputParametersForScalar(Hop hop) {
        hop.setDataType(Types.DataType.SCALAR);
        hop.setDim1(0L);
        hop.setDim2(0L);
        hop.setBlocksize(-1);
        hop.setNnz(-1L);
    }

    public static void refreshOutputParameters(Hop hnew, Hop hold) {
        hnew.setDim1(hold.getDim1());
        hnew.setDim2(hold.getDim2());
        hnew.setBlocksize(hold.getBlocksize());
        hnew.refreshSizeInformation();
    }

    public static void copyLineNumbers(Hop src, Hop dest) {
        dest.setParseInfo(src);
    }

    public static void copyLineNumbers(MatrixBlock mb, Hop tread) {
        tread.setBeginLine(1);
        tread.setEndLine(mb.getNumRows());
        tread.setBeginColumn(1);
        tread.setEndColumn(mb.getNumColumns());
    }

    public static void copyLineNumbers(MatrixObject mo, Hop tread) {
        tread.setBeginLine(1);
        tread.setEndLine((int)mo.getNumRows());
        tread.setBeginColumn(1);
        tread.setEndColumn((int)mo.getNumColumns());
    }

    public static void updateHopCharacteristics(Hop hop, int blen, Hop src) {
        HopRewriteUtils.updateHopCharacteristics(hop, blen, new MemoTable(), src);
    }

    public static void updateHopCharacteristics(Hop hop, int blen, MemoTable memo, Hop src) {
        hop.setBlocksize(blen);
        hop.refreshSizeInformation();
        hop.computeMemEstimate(memo);
        HopRewriteUtils.copyLineNumbers(src, hop);
    }

    public static boolean isDimsKnown(Hop hop) {
        return hop.dimsKnown();
    }

    public static boolean isEmpty(Hop hop) {
        return hop.getNnz() == 0L;
    }

    public static boolean isEqualMatrixSize(BinaryOp hop) {
        return hop.getDataType().isMatrix() && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && HopRewriteUtils.isEqualSize(hop.getInput().get(0), hop.getInput().get(1));
    }

    public static boolean isEqualSize(Hop hop1, Hop hop2) {
        return hop1.dimsKnown() && hop2.dimsKnown() && hop1.getDim1() == hop2.getDim1() && hop1.getDim2() == hop2.getDim2();
    }

    public static boolean isEqualSize(Hop hop1, Hop ... hops) {
        boolean ret = hop1.dimsKnown();
        for (int i = 0; i < hops.length && ret; ret &= HopRewriteUtils.isEqualSize(hop1, hops[i]), ++i) {
        }
        return ret;
    }

    public static boolean isSingleBlock(Hop hop) {
        return HopRewriteUtils.isSingleBlock(hop, true) && HopRewriteUtils.isSingleBlock(hop, false);
    }

    public static boolean isSingleBlock(Hop hop, boolean cols) {
        if (DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE) {
            return true;
        }
        return cols ? hop.colsKnown() && hop.getDim2() <= (long)hop.getBlocksize() : hop.rowsKnown() && hop.getDim1() <= (long)hop.getBlocksize();
    }

    public static boolean isOuterProductLikeMM(Hop hop) {
        return HopRewriteUtils.isMatrixMultiply(hop) && hop.dimsKnown() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(0).getDim1() > hop.getInput().get(0).getDim2() && hop.getInput().get(1).getDim1() < hop.getInput().get(1).getDim2();
    }

    public static boolean isOuterBinary(Hop hop) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).isOuter();
    }

    public static boolean isValidOuterBinaryOp(Types.OpOp2 op) {
        return op.isValidOuter();
    }

    public static boolean isSparse(Hop hop) {
        return hop.dimsKnown(true) && MatrixBlock.evalSparseFormatInMemory(hop.getDim1(), hop.getDim2(), hop.getNnz());
    }

    public static boolean isDense(Hop hop) {
        return hop.dimsKnown(true) && !MatrixBlock.evalSparseFormatInMemory(hop.getDim1(), hop.getDim2(), hop.getNnz());
    }

    public static boolean isSparse(Hop hop, double threshold) {
        return hop.getSparsity() < threshold;
    }

    public static boolean isEqualValue(Hop hop1, Hop hop2) {
        return HopRewriteUtils.isEqualValue((LiteralOp)hop1, (LiteralOp)hop2);
    }

    public static boolean isEqualValue(LiteralOp hop1, LiteralOp hop2) {
        if (hop1.getValueType() == Types.ValueType.STRING || hop2.getValueType() == Types.ValueType.STRING) {
            return hop1.getStringValue().equals(hop2.getStringValue());
        }
        return HopRewriteUtils.getDoubleValue(hop1) == HopRewriteUtils.getDoubleValue(hop2);
    }

    public static boolean isNotMatrixVectorBinaryOperation(Hop hop) {
        boolean ret = true;
        if (hop instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hop;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            boolean mv = left.getDim1() > 1L && right.getDim1() == 1L || left.getDim2() > 1L && right.getDim2() == 1L;
            ret = HopRewriteUtils.isDimsKnown(bop) && !mv;
        }
        return ret;
    }

    public static boolean isReorg(Hop hop, Types.ReOrgOp type) {
        return hop instanceof ReorgOp && ((ReorgOp)hop).getOp() == type;
    }

    public static boolean isReorg(Hop hop, Types.ReOrgOp ... types) {
        return hop instanceof ReorgOp && ArrayUtils.contains((Object[])types, (Object)((Object)((ReorgOp)hop).getOp()));
    }

    public static boolean isTransposeOperation(Hop hop) {
        return HopRewriteUtils.isReorg(hop, Types.ReOrgOp.TRANS);
    }

    public static boolean isTransposeOperation(Hop hop, int maxParents) {
        return HopRewriteUtils.isTransposeOperation(hop) && hop.getParent().size() <= maxParents;
    }

    public static boolean containsTransposeOperation(List<Hop> hops) {
        boolean ret = false;
        for (Hop hop : hops) {
            ret |= HopRewriteUtils.isTransposeOperation(hop);
        }
        return ret;
    }

    public static boolean isTransposeOfItself(Hop hop1, Hop hop2) {
        return HopRewriteUtils.isTransposeOperation(hop1) && hop1.getInput().get(0) == hop2 || HopRewriteUtils.isTransposeOperation(hop2) && hop2.getInput().get(0) == hop1;
    }

    public static boolean isTsmm(Hop input) {
        return HopRewriteUtils.isMatrixMultiply(input) && HopRewriteUtils.isTransposeOfItself(input.getInput().get(0), input.getInput().get(1));
    }

    public static boolean isTsmmInput(Hop input) {
        if (input.getParent().size() == 2) {
            for (int i = 0; i < 2; ++i) {
                if (!HopRewriteUtils.isMatrixMultiply(input.getParent().get(i)) || !HopRewriteUtils.isTransposeOfItself(input.getParent().get(i).getInput().get(0), input.getParent().get(i).getInput().get(1))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(Hop hop, Types.OpOp2 type) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == type;
    }

    public static boolean isBinary(Hop hop, Types.OpOp2 ... types) {
        return hop instanceof BinaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((BinaryOp)hop).getOp()));
    }

    public static boolean isBinary(Hop hop, Types.OpOp2 type, int maxParents) {
        return HopRewriteUtils.isBinary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isBinaryPPred(Hop hop) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).isPPredOperation();
    }

    public static boolean isBinarySparseSafe(Hop hop) {
        if (!(hop instanceof BinaryOp)) {
            return false;
        }
        if (HopRewriteUtils.isBinary(hop, Types.OpOp2.MULT, Types.OpOp2.DIV)) {
            return true;
        }
        BinaryOp bop = (BinaryOp)hop;
        Hop lit = bop.getInput().get(0) instanceof LiteralOp ? bop.getInput().get(0) : (bop.getInput().get(1) instanceof LiteralOp ? bop.getInput().get(1) : null);
        return lit != null && OptimizerUtils.isBinaryOpSparsityConditionalSparseSafe(bop.getOp(), (LiteralOp)lit);
    }

    public static boolean isBinaryMatrixScalarOperation(Hop hop) {
        return hop instanceof BinaryOp && (hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isScalar() || hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).getDataType().isScalar());
    }

    public static boolean isBinaryMatrixMatrixOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim1() > 1L && hop.getInput().get(1).getDim2() > 1L;
    }

    public static boolean isBinaryMatrixMatrixOperationWithSharedInput(Hop hop) {
        boolean ret = HopRewriteUtils.isBinaryMatrixMatrixOperation(hop);
        ret = ret && (HopRewriteUtils.rContainsInput(hop.getInput().get(0), hop.getInput().get(1), new HashSet<Long>()) || HopRewriteUtils.rContainsInput(hop.getInput().get(1), hop.getInput().get(0), new HashSet<Long>()));
        return ret;
    }

    public static boolean isBinaryMatrixScalar(Hop hop, Types.OpOp2 type, double val) {
        return HopRewriteUtils.isBinary(hop, type) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(0), val) || HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), val));
    }

    public static boolean isTernary(Hop hop, Types.OpOp3 type) {
        return hop instanceof TernaryOp && ((TernaryOp)hop).getOp() == type;
    }

    public static boolean isTernary(Hop hop, Types.OpOp3 ... types) {
        return hop instanceof TernaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((TernaryOp)hop).getOp()));
    }

    public static boolean containsInput(Hop current, Hop probe) {
        return HopRewriteUtils.rContainsInput(current, probe, new HashSet<Long>());
    }

    private static boolean rContainsInput(Hop current, Hop probe, HashSet<Long> memo) {
        if (memo.contains(current.getHopID())) {
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < current.getInput().size() && !ret; ret |= HopRewriteUtils.rContainsInput(current.getInput().get(i), probe, memo), ++i) {
        }
        boolean bl = current == probe;
        memo.add(current.getHopID());
        return ret |= bl;
    }

    public static boolean isData(Hop hop, Types.OpOpData ... types) {
        boolean ret = false;
        for (Types.OpOpData type : types) {
            ret |= HopRewriteUtils.isData(hop, type);
        }
        return ret;
    }

    public static boolean isData(Hop hop, Types.OpOpData type) {
        return hop instanceof DataOp && ((DataOp)hop).getOp() == type;
    }

    public static boolean isData(Hop hop, Types.OpOpData type, Types.DataType dt) {
        return HopRewriteUtils.isData(hop, type) && hop.getDataType() == dt;
    }

    public static boolean isTransformEncode(Hop hop) {
        return hop instanceof FunctionOp && ((FunctionOp)hop).getFunctionName().equalsIgnoreCase(Opcodes.TRANSFORMENCODE.toString());
    }

    public static boolean isBinaryMatrixColVectorOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim2() == 1L;
    }

    public static boolean isBinaryMatrixRowVectorOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim1() == 1L;
    }

    public static boolean isUnary(Hop hop, Types.OpOp1 type) {
        return hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == type;
    }

    public static boolean isUnary(Hop hop, Types.OpOp1 type, int maxParents) {
        return HopRewriteUtils.isUnary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isUnary(Hop hop, Types.OpOp1 ... types) {
        return hop instanceof UnaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((UnaryOp)hop).getOp()));
    }

    public static boolean isTerminalHop(Hop hop) {
        return HopRewriteUtils.isUnary(hop, Types.OpOp1.PRINT) || HopRewriteUtils.isNary(hop, Types.OpOpN.PRINTF) || HopRewriteUtils.isData(hop, Types.OpOpData.PERSISTENTWRITE) || HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTWRITE) || hop instanceof FunctionOp;
    }

    public static boolean isMatrixMultiply(Hop hop) {
        return hop instanceof AggBinaryOp && ((AggBinaryOp)hop).isMatrixMultiply();
    }

    public static boolean isAggUnaryOp(Hop hop, Types.AggOp op, Types.Direction dir) {
        return HopRewriteUtils.isAggUnaryOp(hop, op) && ((AggUnaryOp)hop).getDirection() == dir;
    }

    public static boolean isAggUnaryOp(Hop hop, Types.AggOp ... op) {
        if (!(hop instanceof AggUnaryOp)) {
            return false;
        }
        Types.AggOp hopOp = ((AggUnaryOp)hop).getOp();
        return ArrayUtils.contains((Object[])op, (Object)((Object)hopOp));
    }

    public static boolean isSum(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Types.AggOp.SUM;
    }

    public static boolean isSumSq(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Types.AggOp.SUM_SQ;
    }

    public static boolean isParameterizedBuiltinOp(Hop hop, Types.ParamBuiltinOp type) {
        return hop instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)hop).getOp().equals((Object)type);
    }

    public static boolean isParameterizedBuiltinOp(Hop hop, Types.ParamBuiltinOp ... types) {
        return hop instanceof ParameterizedBuiltinOp && ArrayUtils.contains((Object[])types, (Object)((Object)((ParameterizedBuiltinOp)hop).getOp()));
    }

    public static boolean isRemoveEmpty(Hop hop, boolean rows) {
        return HopRewriteUtils.isParameterizedBuiltinOp(hop, Types.ParamBuiltinOp.RMEMPTY) && HopRewriteUtils.isLiteralOfValue(((ParameterizedBuiltinOp)hop).getParameterHop("margin"), rows ? "rows" : "cols");
    }

    public static boolean isRemoveEmpty(Hop hop) {
        return HopRewriteUtils.isParameterizedBuiltinOp(hop, Types.ParamBuiltinOp.RMEMPTY);
    }

    public static boolean isNary(Hop hop, Types.OpOpN type) {
        return hop instanceof NaryOp && ((NaryOp)hop).getOp() == type;
    }

    public static boolean isNary(Hop hop, Types.OpOpN ... types) {
        return hop instanceof NaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((NaryOp)hop).getOp()));
    }

    public static boolean isDnn(Hop hop, Types.OpOpDnn type) {
        return hop instanceof DnnOp && ((DnnOp)hop).getOp() == type;
    }

    public static boolean isDnn(Hop hop, Types.OpOpDnn ... types) {
        return hop instanceof DnnOp && ArrayUtils.contains((Object[])types, (Object)((Object)((DnnOp)hop).getOp()));
    }

    public static boolean isNonZeroIndicator(Hop pred, Hop hop) {
        return pred instanceof BinaryOp && ((BinaryOp)pred).getOp() == Types.OpOp2.NOTEQUAL && pred.getInput().get(0) == hop && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0;
    }

    public static boolean checkInputDataTypes(Hop hop, Types.DataType ... dt) {
        for (int i = 0; i < hop.getInput().size(); ++i) {
            if (hop.getInput().get(i).getDataType() == dt[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAvgRowsGteCols(List<Hop> list) {
        if (list.isEmpty()) {
            return false;
        }
        double avg = list.stream().mapToDouble(h -> h.getDim1()).sum();
        return avg / (double)list.size() >= (double)list.get(0).getDim2();
    }

    public static boolean checkConsistentRows(List<Hop> list1, List<Hop> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        boolean ret = true;
        int len = list1.size();
        for (int i = 0; i < len; ++i) {
            ret &= list1.get(i).getDim1() == list2.get(i).getDim1();
        }
        return ret;
    }

    public static boolean isColumnRightIndexing(Hop hop) {
        return hop instanceof IndexingOp && ((IndexingOp)hop).isColLowerEqualsUpper() && (hop.dimsKnown() && hop.getDim1() == hop.getInput().get(0).getDim1() || HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isUnary(hop.getInput().get(2), Types.OpOp1.NROW) && hop.getInput().get(2).getInput().get(0) == hop.getInput().get(0));
    }

    public static boolean isFullColumnIndexing(LeftIndexingOp hop) {
        return hop.isColLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), hop.getDim1()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(3), hop.getInput().get(0), true));
    }

    public static boolean isFullColumnIndexing(IndexingOp hop) {
        return hop.isColLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), hop.getDim1()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(2), hop.getInput().get(0), true));
    }

    public static boolean isFullRowIndexing(LeftIndexingOp hop) {
        return hop.isRowLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(4), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(5), hop.getDim2()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(5), hop.getInput().get(0), false));
    }

    public static boolean isFullRowIndexing(IndexingOp hop) {
        return hop.isRowLowerEqualsUpper() && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0) && (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(4), hop.getDim2()) || HopRewriteUtils.isSizeExpressionOf(hop.getInput().get(4), hop.getInput().get(0), false));
    }

    public static boolean isColumnRangeIndexing(IndexingOp hop) {
        return (HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(2), hop.getInput().get(0).getDim1()) || hop.getDim1() == hop.getInput().get(0).getDim1()) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0) && hop.getInput().get(4) instanceof LiteralOp;
    }

    public static boolean isConsecutiveIndex(Hop index, Hop index2) {
        return index instanceof LiteralOp && index2 instanceof LiteralOp ? HopRewriteUtils.getDoubleValueSafe((LiteralOp)index2) == HopRewriteUtils.getDoubleValueSafe((LiteralOp)index) + 1.0 : HopRewriteUtils.isBinaryMatrixScalar(index2, Types.OpOp2.PLUS, 1.0) && (index2.getInput().get(0) == index || index2.getInput().get(1) == index);
    }

    public static boolean isUnnecessaryRightIndexing(Hop hop) {
        if (!(hop instanceof IndexingOp) || hop.isScalar()) {
            return false;
        }
        return ((IndexingOp)hop).isAllRowsAndCols() || HopRewriteUtils.isEqualSize(hop, hop.getInput().get(0)) && (hop.getDim1() != 1L || hop.getDim2() != 1L) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(1), 1.0) && HopRewriteUtils.isLiteralOfValue(hop.getInput().get(3), 1.0);
    }

    public static boolean isScalarMatrixBinaryMult(Hop hop) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == Types.OpOp2.MULT && (hop.getInput().get(0).getDataType() == Types.DataType.SCALAR && hop.getInput().get(1).getDataType() == Types.DataType.MATRIX || hop.getInput().get(0).getDataType() == Types.DataType.MATRIX && hop.getInput().get(1).getDataType() == Types.DataType.SCALAR);
    }

    public static boolean isBasic1NSequence(Hop hop) {
        if (hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Types.OpOpDG.SEQ) {
            DataGenOp dgop = (DataGenOp)hop;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return from instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)from) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == 1.0;
        }
        return false;
    }

    public static boolean isBasic1NSequence(Hop seq, Hop input, boolean row) {
        if (seq instanceof DataGenOp && ((DataGenOp)seq).getOp() == Types.OpOpDG.SEQ) {
            DataGenOp dgop = (DataGenOp)seq;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return HopRewriteUtils.isLiteralOfValue(from, 1.0) && HopRewriteUtils.isLiteralOfValue(incr, 1.0) && HopRewriteUtils.isSizeExpressionOf(to, input, row);
        }
        return false;
    }

    public static boolean isBasicN1Sequence(Hop hop) {
        DataGenOp dgop;
        boolean ret = false;
        if (hop instanceof DataGenOp && (dgop = (DataGenOp)hop).getOp() == Types.OpOpDG.SEQ) {
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            ret = to instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)to) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == -1.0;
        }
        return ret;
    }

    public static Hop getBasic1NSequenceMax(Hop hop) {
        if (HopRewriteUtils.isDataGenOp(hop, Types.OpOpDG.SEQ)) {
            DataGenOp dgop = (DataGenOp)hop;
            return dgop.getInput().get(dgop.getParamIndex("to"));
        }
        throw new HopsException("Failed to retrieve 'to' argument from basic 1-N sequence.");
    }

    public static boolean isSizeExpressionOf(Hop size, Hop input, boolean row) {
        return input.dimsKnown() && HopRewriteUtils.isLiteralOfValue(size, row ? (double)input.getDim1() : (double)input.getDim2()) || (row ? HopRewriteUtils.isUnary(size, Types.OpOp1.NROW) : HopRewriteUtils.isUnary(size, Types.OpOp1.NCOL)) && (size.getInput().get(0) == input || HopRewriteUtils.isColumnRightIndexing(input) && size.getInput().get(0) == input.getInput().get(0));
    }

    public static boolean hasOnlyWriteParents(Hop hop, boolean inclTransient, boolean inclPersistent) {
        boolean ret = true;
        List<Hop> parents = hop.getParent();
        for (Hop p : parents) {
            if (inclTransient && inclPersistent) {
                ret &= p instanceof DataOp && (((DataOp)p).getOp() == Types.OpOpData.TRANSIENTWRITE || ((DataOp)p).getOp() == Types.OpOpData.PERSISTENTWRITE);
                continue;
            }
            if (inclTransient) {
                ret &= p instanceof DataOp && ((DataOp)p).getOp() == Types.OpOpData.TRANSIENTWRITE;
                continue;
            }
            if (!inclPersistent) continue;
            ret &= p instanceof DataOp && ((DataOp)p).getOp() == Types.OpOpData.PERSISTENTWRITE;
        }
        return ret;
    }

    public static boolean hasOnlyUnaryBinaryParents(Hop hop, boolean disallowLhs) {
        boolean ret = true;
        for (Hop p : hop.getParent()) {
            ret &= p instanceof UnaryOp || p instanceof BinaryOp && (!disallowLhs || p.getInput().get(1) == hop);
        }
        return ret;
    }

    public static boolean alwaysRequiresReblock(Hop hop) {
        return hop instanceof DataOp && ((DataOp)hop).getOp() == Types.OpOpData.PERSISTENTREAD && ((DataOp)hop).getFileFormat() != Types.FileFormat.BINARY;
    }

    public static boolean containsOp(List<Hop> candidates, Class<? extends Hop> clazz) {
        if (candidates != null) {
            for (Hop cand : candidates) {
                if (!cand.getClass().equals(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean rHasSimpleReadChain(Hop root, String var) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            ret = root.getParent().size() <= 1;
        }
        for (Hop c : root.getInput()) {
            if (!HopRewriteUtils.rHasSimpleReadChain(c, var)) continue;
            ret |= root.getParent().size() <= 1;
        }
        root.setVisited();
        return ret;
    }

    public static boolean rContainsRead(Hop root, String var, boolean includeMetaOp) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            boolean onlyMetaOp = true;
            if (!includeMetaOp) {
                for (Hop p : root.getParent()) {
                    onlyMetaOp &= p instanceof UnaryOp && (((UnaryOp)p).getOp() == Types.OpOp1.NROW || ((UnaryOp)p).getOp() == Types.OpOp1.NCOL);
                }
                ret = !onlyMetaOp;
            } else {
                ret = true;
            }
        }
        for (Hop c : root.getInput()) {
            ret |= HopRewriteUtils.rContainsRead(c, var, includeMetaOp);
        }
        root.setVisited();
        return ret;
    }

    public static Hop createPartialTsmmCbind(Hop X, Hop deltaX, Hop tsmmIn1) {
        ReorgOp tLastCol = HopRewriteUtils.createTranspose(deltaX);
        AggBinaryOp bottomLeft = HopRewriteUtils.createMatrixMultiply(tLastCol, X);
        ReorgOp topRight = HopRewriteUtils.createTranspose(bottomLeft);
        AggBinaryOp bottomRight = HopRewriteUtils.createMatrixMultiply(tLastCol, deltaX);
        BinaryOp rowOne = HopRewriteUtils.createBinary(tsmmIn1, (Hop)topRight, Types.OpOp2.CBIND);
        BinaryOp rowTwo = HopRewriteUtils.createBinary((Hop)bottomLeft, (Hop)bottomRight, Types.OpOp2.CBIND);
        return HopRewriteUtils.createBinary((Hop)rowOne, (Hop)rowTwo, Types.OpOp2.RBIND);
    }

    public static boolean isValidOp(Types.AggOp input, Types.AggOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Types.OpOp1 input, Types.OpOp1 ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Types.OpOp2 input, Types.OpOp2 ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Types.ReOrgOp input, Types.ReOrgOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Types.ParamBuiltinOp input, Types.ParamBuiltinOp ... validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static int getValidOpPos(Types.OpOp2 input, Types.OpOp2 ... validTab) {
        return ArrayUtils.indexOf((Object[])validTab, (Object)((Object)input));
    }

    public static int compareSize(Hop hop1, Hop hop2) {
        long size1 = hop1.getDim1() * hop1.getDim2();
        long size2 = hop2.getDim1() * hop2.getDim2();
        return Long.compare(size1, size2);
    }

    public static boolean isLastLevelStatementBlock(StatementBlock sb) {
        return !(sb instanceof FunctionStatementBlock) && !(sb instanceof WhileStatementBlock) && !(sb instanceof IfStatementBlock) && !(sb instanceof ForStatementBlock);
    }

    public static boolean isLoopStatementBlock(StatementBlock sb) {
        return sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock;
    }

    public static boolean isLastLevelLoopStatementBlock(StatementBlock sb) {
        block6: {
            block5: {
                if (!HopRewriteUtils.isLoopStatementBlock(sb)) {
                    return false;
                }
                if (!(sb instanceof WhileStatementBlock)) break block5;
                WhileStatement wstmt = (WhileStatement)sb.getStatement(0);
                if (wstmt.getBody().isEmpty()) {
                    return false;
                }
                for (StatementBlock csb : wstmt.getBody()) {
                    if (HopRewriteUtils.isLastLevelStatementBlock(csb)) continue;
                    return false;
                }
                break block6;
            }
            if (!(sb instanceof ForStatementBlock)) break block6;
            ForStatement fstmt = (ForStatement)sb.getStatement(0);
            if (fstmt.getBody().isEmpty()) {
                return false;
            }
            for (StatementBlock csb : fstmt.getBody()) {
                if (HopRewriteUtils.isLastLevelStatementBlock(csb)) continue;
                return false;
            }
        }
        return true;
    }

    public static long getMaxNrowInput(Hop hop) {
        return HopRewriteUtils.getMaxInputDim(hop, true);
    }

    public static long getMaxNcolInput(Hop hop) {
        return HopRewriteUtils.getMaxInputDim(hop, false);
    }

    public static long getMaxInputDim(Hop hop, boolean dim1) {
        return hop.getInput().stream().mapToLong(h -> dim1 ? h.getDim1() : h.getDim2()).max().orElse(-1L);
    }

    public static long getSumValidInputDims(Hop hop, boolean dim1) {
        if (!HopRewriteUtils.hasValidInputDims(hop, dim1)) {
            return -1L;
        }
        return hop.getInput().stream().mapToLong(h -> dim1 ? h.getDim1() : h.getDim2()).sum();
    }

    public static boolean hasValidInputDims(Hop hop, boolean dim1) {
        return hop.getInput().stream().allMatch(h -> dim1 ? h.rowsKnown() : h.colsKnown());
    }

    public static long getSumValidInputNnz(Hop hop) {
        if (!HopRewriteUtils.hasValidInputNnz(hop)) {
            return -1L;
        }
        return hop.getInput().stream().mapToLong(h -> h.getNnz()).sum();
    }

    public static boolean hasValidInputNnz(Hop hop) {
        return hop.getInput().stream().allMatch(h -> h.getNnz() >= 0L);
    }

    public static long getMaxInputDim(DataCharacteristics[] dc, boolean dim1) {
        return Arrays.stream(dc).mapToLong(h -> dim1 ? h.getRows() : h.getRows()).max().orElse(-1L);
    }

    public static long getSumValidInputDims(DataCharacteristics[] mc, boolean dim1) {
        if (!HopRewriteUtils.hasValidInputDims(mc, dim1)) {
            return -1L;
        }
        return Arrays.stream(mc).mapToLong(h -> dim1 ? h.getRows() : h.getCols()).sum();
    }

    public static boolean hasValidInputDims(DataCharacteristics[] mc, boolean dim1) {
        return Arrays.stream(mc).allMatch(h -> dim1 ? h.rowsKnown() : h.colsKnown());
    }

    public static long getSumValidInputNnz(DataCharacteristics[] mc, boolean worstcase) {
        if (!HopRewriteUtils.hasValidInputNnz(mc, worstcase)) {
            return -1L;
        }
        return Arrays.stream(mc).mapToLong(h -> h.nnzKnown() ? h.getNonZeros() : h.getLength()).sum();
    }

    public static boolean hasValidInputNnz(DataCharacteristics[] mc, boolean worstcase) {
        return Arrays.stream(mc).allMatch(h -> h.nnzKnown() || worstcase && h.dimsKnown());
    }

    public static boolean hasListInputs(Hop hop) {
        return hop.getInput() != null && hop.getInput().stream().anyMatch(h -> h.getDataType().isList());
    }

    public static boolean containsSecondOrderBuiltin(List<Hop> roots) {
        Hop.resetVisitStatus(roots);
        return roots.stream().anyMatch(r -> HopRewriteUtils.containsSecondOrderBuiltin(r));
    }

    private static boolean containsSecondOrderBuiltin(Hop hop) {
        if (hop.isVisited()) {
            return false;
        }
        hop.setVisited();
        return HopRewriteUtils.isNary(hop, Types.OpOpN.EVAL) || HopRewriteUtils.isParameterizedBuiltinOp(hop, Types.ParamBuiltinOp.PARAMSERV) && !HopRewriteUtils.knownParamservFunctions(hop) || hop.getInput().stream().anyMatch(c -> HopRewriteUtils.containsSecondOrderBuiltin(c));
    }

    public static boolean knownParamservFunctions(Hop hop) {
        ParameterizedBuiltinOp pop = (ParameterizedBuiltinOp)hop;
        return pop.getParameterHop("upd") instanceof LiteralOp && pop.getParameterHop("agg") instanceof LiteralOp && (pop.getParameterHop("val") == null || pop.getParameterHop("val") instanceof LiteralOp);
    }

    public static boolean knownParamservFunctions(Hop hop, DMLProgram prog) {
        if (!HopRewriteUtils.knownParamservFunctions(hop)) {
            return false;
        }
        try {
            ParameterizedBuiltinOp pop = (ParameterizedBuiltinOp)hop;
            String supd = ((LiteralOp)pop.getParameterHop("upd")).getStringValue();
            String sagg = ((LiteralOp)pop.getParameterHop("agg")).getStringValue();
            return prog.getFunctionStatementBlock(supd) != null && prog.getFunctionStatementBlock(sagg) != null;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return false;
        }
    }

    public static void setUnoptimizedFunctionCalls(StatementBlock sb) {
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatement fstmt = (FunctionStatement)sb.getStatement(0);
            for (StatementBlock c : fstmt.getBody()) {
                HopRewriteUtils.setUnoptimizedFunctionCalls(c);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatement stmt = (IfStatement)sb.getStatement(0);
            for (StatementBlock c : stmt.getIfBody()) {
                HopRewriteUtils.setUnoptimizedFunctionCalls(c);
            }
            for (StatementBlock c : stmt.getElseBody()) {
                HopRewriteUtils.setUnoptimizedFunctionCalls(c);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatement stmt = (WhileStatement)sb.getStatement(0);
            for (StatementBlock c : stmt.getBody()) {
                HopRewriteUtils.setUnoptimizedFunctionCalls(c);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatement stmt = (ForStatement)sb.getStatement(0);
            for (StatementBlock c : stmt.getBody()) {
                HopRewriteUtils.setUnoptimizedFunctionCalls(c);
            }
        } else {
            for (Hop root : sb.getHops()) {
                if (!(root instanceof FunctionOp)) continue;
                ((FunctionOp)root).setCallOptimized(false);
            }
        }
    }
}

