/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.Preconditions;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncherOperationBase;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;

@InterfaceAudience.Private
public class ContainerOp {
    final ContainerLauncherOperationBase command;
    final OPType opType;

    public ContainerOp(OPType opType, ContainerLauncherOperationBase command) {
        this.opType = opType;
        this.command = command;
    }

    public OPType getOpType() {
        return this.opType;
    }

    public ContainerLauncherOperationBase getBaseOperation() {
        return this.command;
    }

    public ContainerLaunchRequest getLaunchRequest() {
        Preconditions.checkState((this.opType == OPType.LAUNCH_REQUEST ? 1 : 0) != 0);
        return (ContainerLaunchRequest)this.command;
    }

    public ContainerStopRequest getStopRequest() {
        Preconditions.checkState((this.opType == OPType.STOP_REQUEST ? 1 : 0) != 0);
        return (ContainerStopRequest)this.command;
    }

    public String toString() {
        return "ContainerOp{opType=" + (Object)((Object)this.opType) + ", command=" + this.command + '}';
    }

    static enum OPType {
        LAUNCH_REQUEST,
        STOP_REQUEST;

    }
}

