/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.Node;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int providesIndex;
    private final int providesWithCount;
    private final int[] providesWithIndex;

    private static String getImplementationClassNameAtIndex(ConstantPool constantPool, int index, boolean compactClassName) {
        String className = constantPool.getConstantString(index, (byte)7);
        if (compactClassName) {
            return Utility.compactClassName(className, false);
        }
        return className;
    }

    ModuleProvides(DataInput file) throws IOException {
        this.providesIndex = file.readUnsignedShort();
        this.providesWithCount = file.readUnsignedShort();
        this.providesWithIndex = new int[this.providesWithCount];
        for (int i = 0; i < this.providesWithCount; ++i) {
            this.providesWithIndex[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleProvides(this);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.providesIndex);
        file.writeShort(this.providesWithCount);
        for (int entry : this.providesWithIndex) {
            file.writeShort(entry);
        }
    }

    public String[] getImplementationClassNames(ConstantPool constantPool, boolean compactClassName) {
        String[] implementationClassNames = new String[this.providesWithCount];
        for (int i = 0; i < this.providesWithCount; ++i) {
            implementationClassNames[i] = ModuleProvides.getImplementationClassNameAtIndex(constantPool, this.providesWithIndex[i], compactClassName);
        }
        return implementationClassNames;
    }

    public String getInterfaceName(ConstantPool constantPool) {
        return constantPool.constantToString(this.providesIndex, (byte)7);
    }

    public String toString() {
        return "provides(" + this.providesIndex + ", " + this.providesWithCount + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder buf = new StringBuilder();
        String interfaceName = this.getInterfaceName(constantPool);
        buf.append(interfaceName);
        buf.append(", with(").append(this.providesWithCount).append("):\n");
        for (int index : this.providesWithIndex) {
            String className = ModuleProvides.getImplementationClassNameAtIndex(constantPool, index, true);
            buf.append("      ").append(className).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

