/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.Trigger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.openejb.threads.future.CUScheduledFuture;
import org.apache.openejb.threads.future.CUTriggerScheduledFuture;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.ManagedExecutorServiceImpl;
import org.apache.openejb.threads.task.CUCallable;
import org.apache.openejb.threads.task.CURunnable;
import org.apache.openejb.threads.task.ManagedTaskListenerTask;
import org.apache.openejb.threads.task.TriggerCallable;
import org.apache.openejb.threads.task.TriggerRunnable;
import org.apache.openejb.threads.task.TriggerTask;

public class ManagedScheduledExecutorServiceImpl
extends ManagedExecutorServiceImpl
implements ManagedScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final ContextServiceImpl contextService;

    public ManagedScheduledExecutorServiceImpl(ScheduledExecutorService delegate, ContextServiceImpl contextService) {
        super(delegate, contextService);
        this.delegate = delegate;
        this.contextService = contextService;
    }

    public ScheduledFuture<?> schedule(Runnable runnable, Trigger trigger) {
        Objects.requireNonNull(runnable);
        Date taskScheduledTime = new Date();
        AtomicReference futureHandle = new AtomicReference();
        TriggerRunnable wrapper = new TriggerRunnable(this, this.contextService, runnable, new CURunnable(runnable, this.contextService), trigger, taskScheduledTime, ManagedScheduledExecutorServiceImpl.getTaskId(runnable), (AtomicReference)AtomicReference.class.cast(futureHandle));
        return this.initTriggerScheduledFuture((AtomicReference)AtomicReference.class.cast(futureHandle), wrapper);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> vCallable, Trigger trigger) {
        Objects.requireNonNull(vCallable);
        Date taskScheduledTime = new Date();
        AtomicReference futureHandle = new AtomicReference();
        TriggerCallable<V> wrapper = new TriggerCallable<V>(this, this.contextService, vCallable, new CUCallable<V>(vCallable, this.contextService), trigger, taskScheduledTime, ManagedScheduledExecutorServiceImpl.getTaskId(vCallable), futureHandle);
        return this.initTriggerScheduledFuture(futureHandle, wrapper);
    }

    private <V> ScheduledFuture<V> initTriggerScheduledFuture(AtomicReference<Future<V>> futureHandle, TriggerTask<V> wrapper) {
        wrapper.scheduleNextRun();
        ScheduledFuture proxy = (ScheduledFuture)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ScheduledFuture.class}, new TriggerBasedScheduledFutureFacade<V>(futureHandle));
        return new CUTriggerScheduledFuture<V>(proxy, wrapper);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Objects.requireNonNull(command);
        CURunnable wrapper = new CURunnable(command, this.contextService);
        ScheduledFuture<?> future = this.delegate.schedule(wrapper, delay, unit);
        wrapper.taskSubmitted(future, this, command);
        return new CUScheduledFuture((ScheduledFuture)ScheduledFuture.class.cast(future), (ManagedTaskListenerTask)wrapper);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Objects.requireNonNull(callable);
        CUCallable<V> wrapper = new CUCallable<V>(callable);
        ScheduledFuture<V> future = this.delegate.schedule(wrapper, delay, unit);
        wrapper.taskSubmitted(future, this, callable);
        return new CUScheduledFuture<V>(future, (ManagedTaskListenerTask)wrapper);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Objects.requireNonNull(command);
        CURunnable wrapper = new CURunnable(command, this.contextService);
        ScheduledFuture<?> future = this.delegate.scheduleAtFixedRate(wrapper, initialDelay, period, unit);
        wrapper.taskSubmitted(future, this, command);
        return new CUScheduledFuture((ScheduledFuture)ScheduledFuture.class.cast(future), (ManagedTaskListenerTask)wrapper);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Objects.requireNonNull(command);
        CURunnable wrapper = new CURunnable(command, this.contextService);
        ScheduledFuture<?> future = this.delegate.scheduleWithFixedDelay(wrapper, initialDelay, delay, unit);
        wrapper.taskSubmitted(future, this, command);
        return new CUScheduledFuture((ScheduledFuture)ScheduledFuture.class.cast(future), (ManagedTaskListenerTask)wrapper);
    }

    public static long nowMs() {
        return System.currentTimeMillis();
    }

    private static String getTaskId(Object runnable) {
        ManagedTask managedTask;
        Map executionProps;
        if (runnable instanceof ManagedTask && (executionProps = (managedTask = (ManagedTask)runnable).getExecutionProperties()) != null) {
            return (String)executionProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
        }
        return null;
    }

    @Override
    public ScheduledExecutorService getDelegate() {
        return this.delegate;
    }

    private record TriggerBasedScheduledFutureFacade<V>(AtomicReference<ScheduledFuture<V>> delegate) implements InvocationHandler
    {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate.get(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

