/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ExecutionContext;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;

public class AllPropertiesRecipe
extends AbstractRecipe {
    @Override
    public boolean canCreate(Type type) {
        return RecipeHelper.isAssignable(type, Properties.class);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Recipe outerRecipe = RecipeHelper.getCaller();
        if (!(outerRecipe instanceof ObjectRecipe)) {
            throw new ConstructionException("UnsetPropertiesRecipe can only be nested in an ObjectRecipe: outerRecipe=" + outerRecipe);
        }
        ObjectRecipe objectRecipe = (ObjectRecipe)outerRecipe;
        Map<String, Object> allProperties = objectRecipe.getProperties();
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : allProperties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        if (this.getName() != null) {
            ExecutionContext.getContext().addObject(this.getName(), properties);
        }
        return properties;
    }
}

