/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.Primitives;

public class FibonacciBackOff
implements BackOff {
    private final long initialDelayInMillis;
    private final long maxDelayInMillis;
    private final Jitter jitter;
    private long lastDelayA;
    private long lastDelayB;

    public FibonacciBackOff(long initialDelayInMillis, Jitter jitter, long maxDelayInMillis) {
        this.initialDelayInMillis = Preconditions.check(initialDelayInMillis, initialDelayInMillis >= 0L, "Initial delay must be >= 0");
        this.jitter = Preconditions.checkNotNull(jitter, "Jitter must be set");
        long l = this.maxDelayInMillis = maxDelayInMillis <= 0L ? Long.MAX_VALUE : maxDelayInMillis;
        if (maxDelayInMillis > 0L) {
            Preconditions.check(initialDelayInMillis, initialDelayInMillis < maxDelayInMillis, "Initial delay must be < max delay");
        }
    }

    @Override
    public synchronized long getInMillis(Throwable cause) {
        if (this.lastDelayA == 0L) {
            this.lastDelayA = this.initialDelayInMillis;
            return this.lastDelayA + this.jitter.generate();
        }
        if (this.lastDelayB == 0L) {
            this.lastDelayB = this.initialDelayInMillis << 1;
            return this.lastDelayB + this.jitter.generate();
        }
        long delay = this.lastDelayA + this.lastDelayB;
        this.lastDelayA = this.lastDelayB;
        this.lastDelayB = delay;
        return Primitives.clamp(delay + this.jitter.generate(), 0L, this.maxDelayInMillis);
    }
}

