/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.security;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.soap.client.security.SOAPClientSecurityContext;

public class SOAPClientSecurityProfileIdLookupFunction
implements ContextDataLookupFunction<MessageContext, String> {
    @Nonnull
    private Function<MessageContext, SOAPClientSecurityContext> soapContextLookup = new ChildContextLookup(SOAPClientSecurityContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));

    public void setSOAPClientSecurityContextLookup(@Nonnull Function<MessageContext, SOAPClientSecurityContext> lookup) {
        this.soapContextLookup = (Function)Constraint.isNotNull(lookup, (String)"SOAPClientSecurityContext lookup function was null");
    }

    @Nullable
    public String apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        SOAPClientSecurityContext context = this.soapContextLookup.apply(messageContext);
        if (context != null) {
            return context.getSecurityConfigurationProfileId();
        }
        return null;
    }
}

