/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.RateLimitConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RateLimitConfigImpl
implements RateLimitConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final RateLimit instance;
    private final boolean onMethod;
    private Integer _value;
    private Long _window;
    private ChronoUnit _windowUnit;
    private Long _minSpacing;
    private ChronoUnit _minSpacingUnit;
    private RateLimitType _type;

    private RateLimitConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.rateLimit;
        this.onMethod = method.annotationsPresentDirectly.contains(RateLimit.class);
    }

    public static RateLimitConfigImpl create(FaultToleranceMethod method) {
        if (method.rateLimit == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(RateLimit.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new RateLimitConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/value";
                this._value = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/value";
                this._value = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            }
            if (this._value == null) {
                this._value = config.getOptionalValue("RateLimit/value", Integer.TYPE).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public long window() {
        if (this._window == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/window";
                this._window = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/window";
                this._window = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._window == null) {
                this._window = config.getOptionalValue("RateLimit/window", Long.TYPE).orElse(null);
            }
            if (this._window == null) {
                this._window = this.instance.window();
            }
        }
        return this._window;
    }

    public ChronoUnit windowUnit() {
        if (this._windowUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/windowUnit";
                this._windowUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/windowUnit";
                this._windowUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._windowUnit == null) {
                this._windowUnit = config.getOptionalValue("RateLimit/windowUnit", ChronoUnit.class).orElse(null);
            }
            if (this._windowUnit == null) {
                this._windowUnit = this.instance.windowUnit();
            }
        }
        return this._windowUnit;
    }

    public long minSpacing() {
        if (this._minSpacing == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/minSpacing";
                this._minSpacing = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/minSpacing";
                this._minSpacing = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._minSpacing == null) {
                this._minSpacing = config.getOptionalValue("RateLimit/minSpacing", Long.TYPE).orElse(null);
            }
            if (this._minSpacing == null) {
                this._minSpacing = this.instance.minSpacing();
            }
        }
        return this._minSpacing;
    }

    public ChronoUnit minSpacingUnit() {
        if (this._minSpacingUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/minSpacingUnit";
                this._minSpacingUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/minSpacingUnit";
                this._minSpacingUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._minSpacingUnit == null) {
                this._minSpacingUnit = config.getOptionalValue("RateLimit/minSpacingUnit", ChronoUnit.class).orElse(null);
            }
            if (this._minSpacingUnit == null) {
                this._minSpacingUnit = this.instance.minSpacingUnit();
            }
        }
        return this._minSpacingUnit;
    }

    public RateLimitType type() {
        if (this._type == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/RateLimit/type";
                this._type = config.getOptionalValue(key, RateLimitType.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/RateLimit/type";
                this._type = config.getOptionalValue(key, RateLimitType.class).orElse(null);
            }
            if (this._type == null) {
                this._type = config.getOptionalValue("RateLimit/type", RateLimitType.class).orElse(null);
            }
            if (this._type == null) {
                this._type = this.instance.type();
            }
        }
        return this._type;
    }

    public void materialize() {
        this.value();
        this.window();
        this.windowUnit();
        this.minSpacing();
        this.minSpacingUnit();
        this.type();
    }
}

