/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.web.LightweightWebAppBuilder;

public final class LightweightWebAppBuilderListenerExtractor {
    public static <T> Collection<T> findByTypeForContext(String context, Class<T> type) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        if (!LightweightWebAppBuilder.class.isInstance(builder)) {
            return Collections.emptyList();
        }
        for (AppContext app : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
            for (WebContext web : app.getWebContexts()) {
                if (!web.getContextRoot().replace("/", "").equals(context.replace("/", ""))) continue;
                Collection potentials = ((LightweightWebAppBuilder)LightweightWebAppBuilder.class.cast(builder)).listenersFor(web.getContextRoot());
                if (potentials == null) {
                    return Collections.emptyList();
                }
                ArrayList<T> filtered = new ArrayList<T>(potentials.size());
                for (Object o : potentials) {
                    if (!type.isInstance(o)) continue;
                    filtered.add(type.cast(o));
                }
                return filtered;
            }
        }
        return Collections.emptyList();
    }

    private LightweightWebAppBuilderListenerExtractor() {
    }
}

