/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLVariableXPathMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathCollectionMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;

public class XMLVariableXPathCollectionMappingNodeValue
extends XMLVariableXPathMappingNodeValue
implements ContainerValue {
    VariableXPathCollectionMapping mapping;
    private int index = -1;

    public XMLVariableXPathCollectionMappingNodeValue(VariableXPathCollectionMapping variableXPathCollectionMapping) {
        this.mapping = variableXPathCollectionMapping;
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value);
    }

    @Override
    public VariableXPathCollectionMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.mapping.isReadOnly()) {
            return false;
        }
        Object cp = this.mapping.getContainerPolicy();
        Object collection = this.mapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            AbstractNullPolicy wrapperNP = this.mapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL)) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (null == iterator || !cp.hasNext(iterator)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.mapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON()) {
            ArrayList<XPathFragment> frags = new ArrayList<XPathFragment>();
            ArrayList values = new ArrayList();
            while (cp.hasNext(iterator)) {
                Object nextValue = cp.next(iterator, (CoreAbstractSession)session);
                XPathFragment frag = this.mapping.getXPathFragmentForValue(nextValue = this.mapping.convertObjectValueToDataValue(nextValue, session, marshalRecord.getMarshaller()), (NamespaceResolver)marshalRecord.getNamespaceResolver(), marshalRecord.isNamespaceAware(), marshalRecord.getNamespaceSeparator());
                if (frag == null) continue;
                int index = frags.indexOf(frag);
                if (index > -1) {
                    ((List)values.get(index)).add(nextValue);
                    continue;
                }
                frags.add(frag);
                ArrayList<Object> valuesList = new ArrayList<Object>();
                valuesList.add(nextValue);
                values.add(valuesList);
            }
            for (int i = 0; i < frags.size(); ++i) {
                XPathFragment nextFragment = (XPathFragment)frags.get(i);
                List listValue = (List)values.get(i);
                if (nextFragment == null) continue;
                int valueSize = listValue.size();
                if (valueSize > 1) {
                    marshalRecord.startCollection();
                }
                for (int j = 0; j < valueSize; ++j) {
                    this.marshalSingleValue(nextFragment, marshalRecord, object, listValue.get(j), session, namespaceResolver, ObjectMarshalContext.getInstance());
                }
                if (valueSize <= 1) continue;
                marshalRecord.endCollection();
            }
        } else {
            while (cp.hasNext(iterator)) {
                Object objectValue = cp.next(iterator, (CoreAbstractSession)session);
                objectValue = this.mapping.convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller());
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
        }
        return true;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.mapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.mapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean getReuseContainer() {
        return this.mapping.getReuseContainer();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.mapping.isDefaultEmptyContainer();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return false;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return true;
    }
}

