/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.xbean.osgi.bundle.util.BundleResourceHelper;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.apache.xbean.osgi.bundle.util.DelegatingBundleReference;
import org.osgi.framework.Bundle;

public class BundleClassLoader
extends ClassLoader
implements DelegatingBundleReference {
    protected final Bundle bundle;
    protected final BundleResourceHelper resourceHelper;

    public BundleClassLoader(Bundle bundle) {
        this(bundle, BundleResourceHelper.getSearchWiredBundles(true), BundleResourceHelper.getConvertResourceUrls(false));
    }

    public BundleClassLoader(Bundle bundle, boolean searchWiredBundles) {
        this(bundle, searchWiredBundles, BundleResourceHelper.getConvertResourceUrls(false));
    }

    public BundleClassLoader(Bundle bundle, boolean searchWiredBundles, boolean convertResourceUrls) {
        this.bundle = bundle;
        this.resourceHelper = new BundleResourceHelper(bundle, searchWiredBundles, convertResourceUrls);
    }

    public String toString() {
        return "[BundleClassLoader] " + this.bundle;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        return this.resourceHelper.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.resourceHelper.getResources(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.getResources(name);
    }

    public void setSearchWiredBundles(boolean search) {
        this.resourceHelper.setSearchWiredBundles(search);
    }

    public boolean getSearchWiredBundles() {
        return this.resourceHelper.getSearchWiredBundles();
    }

    public void setConvertResourceUrls(boolean convert) {
        this.resourceHelper.setConvertResourceUrls(convert);
    }

    public boolean getConvertResourceUrls() {
        return this.resourceHelper.getConvertResourceUrls();
    }

    @Override
    public Bundle getBundle(boolean unwrap) {
        if (unwrap && this.bundle instanceof DelegatingBundle) {
            return ((DelegatingBundle)this.bundle).getMainBundle();
        }
        return this.bundle;
    }

    public Bundle getBundle() {
        return this.getBundle(true);
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        BundleClassLoader otherBundleClassLoader = (BundleClassLoader)other;
        return this.bundle == otherBundleClassLoader.bundle;
    }
}

