/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.geronimo.connector.ConnectionReleaser;
import org.apache.geronimo.connector.ConnectorTransactionContext;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.TxUtil;

public class TransactionCachingInterceptor
implements ConnectionInterceptor,
ConnectionReleaser {
    protected static Logger log = Logger.getLogger(TransactionCachingInterceptor.class.getName());
    private final ConnectionInterceptor next;
    private final TransactionManager transactionManager;

    public TransactionCachingInterceptor(ConnectionInterceptor next, TransactionManager transactionManager) {
        this.next = next;
        this.transactionManager = transactionManager;
    }

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
        if (transaction != null) {
            ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
            if (connectionInfo.isUnshareable()) {
                if (!managedConnectionInfos.containsUnshared(connectionInfo.getManagedConnectionInfo())) {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.addUnshared(connectionInfo.getManagedConnectionInfo());
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Enlisting connection already associated with handle " + this.infoString(connectionInfo));
                    }
                }
            } else {
                ManagedConnectionInfo managedConnectionInfo = managedConnectionInfos.getShared();
                if (managedConnectionInfo != null) {
                    ManagedConnectionInfo previousMci = connectionInfo.getManagedConnectionInfo();
                    if (previousMci != null && previousMci != managedConnectionInfo && previousMci.getManagedConnection() != null) {
                        this.next.getConnection(connectionInfo);
                        managedConnectionInfos.addUnshared(previousMci);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Enlisting existing connection associated with connection handle with current tx  " + this.infoString(connectionInfo));
                        }
                    } else {
                        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "supplying connection from tx cache  " + this.infoString(connectionInfo));
                        }
                    }
                } else {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.setShared(connectionInfo.getManagedConnectionInfo());
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "supplying connection from pool " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this);
                    }
                }
            }
        } else {
            this.next.getConnection(connectionInfo);
        }
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionReturnAction == ConnectionReturnAction.DESTROY) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "destroying connection " + this.infoString(connectionInfo));
            }
            this.next.returnConnection(connectionInfo, connectionReturnAction);
            return;
        }
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                if (TxUtil.isActive(transaction)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "tx active, not returning connection  " + this.infoString(connectionInfo));
                    }
                    return;
                }
                ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
                managedConnectionInfos.remove(connectionInfo.getManagedConnectionInfo());
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "tx ended, return during synchronization afterCompletion " + this.infoString(connectionInfo));
                }
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "tx ended, returning connection " + this.infoString(connectionInfo));
        }
        this.internalReturn(connectionInfo, connectionReturnAction);
    }

    private void internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionInfo.getManagedConnectionInfo().hasConnectionHandles()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "not returning connection from tx cache (has handles) " + this.infoString(connectionInfo));
            }
            return;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "completed return of connection through tx cache " + this.infoString(connectionInfo));
        }
    }

    @Override
    public void destroy() {
        this.next.destroy();
    }

    @Override
    public void afterCompletion(Object stuff) {
        ManagedConnectionInfos managedConnectionInfos = (ManagedConnectionInfos)stuff;
        ManagedConnectionInfo sharedMCI = managedConnectionInfos.getShared();
        if (sharedMCI != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Transaction completed, attempting to return shared connection MCI: " + this.infoString(sharedMCI));
            }
            this.returnHandle(sharedMCI);
        }
        for (ManagedConnectionInfo managedConnectionInfo : managedConnectionInfos.getUnshared()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Transaction completed, attempting to return unshared connection MCI: " + this.infoString(managedConnectionInfo));
            }
            this.returnHandle(managedConnectionInfo);
        }
    }

    private void returnHandle(ManagedConnectionInfo managedConnectionInfo) {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
        this.internalReturn(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
    }

    private String infoString(Object connectionInfo) {
        return "for tx caching interceptor " + this + " " + connectionInfo;
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[transactionManager=").append(this.transactionManager).append("]\n");
        this.next.info(s);
    }

    public static class ManagedConnectionInfos {
        private ManagedConnectionInfo shared;
        private Set<ManagedConnectionInfo> unshared = new HashSet<ManagedConnectionInfo>(1);

        public ManagedConnectionInfo getShared() {
            return this.shared;
        }

        public void setShared(ManagedConnectionInfo shared) {
            this.shared = shared;
        }

        public Set<ManagedConnectionInfo> getUnshared() {
            return this.unshared;
        }

        public void addUnshared(ManagedConnectionInfo unsharedMCI) {
            this.unshared.add(unsharedMCI);
        }

        public boolean containsUnshared(ManagedConnectionInfo unsharedMCI) {
            return this.unshared.contains(unsharedMCI);
        }

        public void remove(ManagedConnectionInfo managedConnectionInfo) {
            if (this.shared == managedConnectionInfo) {
                this.shared = null;
            } else {
                this.unshared.remove(managedConnectionInfo);
            }
        }
    }
}

