/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.config.WebBeansContext;

public class OWBContextThreadListener
implements ThreadContextListener {
    private final ThreadSingletonService singletonService = SystemInstance.get().getComponent(ThreadSingletonService.class);

    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        OWBContextHolder holder;
        BeanContext beanContext = newContext.getBeanContext();
        if (beanContext == null) {
            return;
        }
        ModuleContext moduleContext = beanContext.getModuleContext();
        AppContext appContext = moduleContext.getAppContext();
        WebBeansContext owbContext = appContext.getWebBeansContext();
        if (owbContext != null) {
            Object oldOWBContext = this.singletonService.contextEntered(owbContext);
            holder = new OWBContextHolder(oldOWBContext);
        } else {
            holder = OWBContextHolder.EMPTY_CONTEXT;
        }
        newContext.set(OWBContextHolder.class, holder);
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        OWBContextHolder holder = exitedContext.get(OWBContextHolder.class);
        if (holder == null) {
            throw new NullPointerException("OWBContext not set in this thread");
        }
        if (holder != OWBContextHolder.EMPTY_CONTEXT) {
            Object oldOWBContextContext = holder.getContext();
            this.singletonService.contextExited(oldOWBContextContext);
        }
    }

    private static final class OWBContextHolder {
        static OWBContextHolder EMPTY_CONTEXT = new OWBContextHolder(null);
        private final Object context;

        private OWBContextHolder(Object context) {
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }
    }
}

