/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jdbc.database;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.apache.batchee.container.services.persistence.jdbc.database.Database;

public class DerbyDatabase
implements Database {
    private final Collection<String> forbiddenFields = Arrays.asList("read", "write", "commit", "rollback");

    @Override
    public String integer() {
        return "integer";
    }

    @Override
    public String bigint() {
        return "bigint";
    }

    @Override
    public String varchar255() {
        return "varchar(255)";
    }

    @Override
    public String varchar20() {
        return "varchar(20)";
    }

    @Override
    public String blob() {
        return "blob";
    }

    @Override
    public String timestamp() {
        return "timestamp";
    }

    @Override
    public String autoIncrementId() {
        return "NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
    }

    @Override
    public String columnName(String name) {
        if (this.forbiddenFields.contains(name)) {
            return name.toUpperCase(Locale.ENGLISH) + "0";
        }
        return name;
    }
}

